/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.effectiveRegion;

import edu.zju.common.CExecutor;
import edu.zju.genome.abstractGenome.Genome;
import edu.zju.genome.effectiveRegion.ChromosomeEffectiveRegion;
import edu.zju.genome.effectiveRegion.GeneEffectiveRegion;
import edu.zju.parameter.EffectiveRegionParameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GenomeEffectiveRegion
extends Genome {
    private HashMap<String, ChromosomeEffectiveRegion> chromosomeEffectiveRegion;
    private int effectiveRegionLength = 0;
    private boolean ready = false;
    private int maxPosition = 0;
    private static EffectiveRegionParameter effectiveRegionParameter = null;

    public GenomeEffectiveRegion(EffectiveRegionParameter regionParameter, edu.zju.genome.gffGenome.Genome genome) {
        super(genome);
        effectiveRegionParameter = regionParameter;
        this.chromosomeEffectiveRegion = new HashMap();
        this.setGenomeEffectivetRegion(genome);
    }

    private void setGenomeEffectivetRegion(edu.zju.genome.gffGenome.Genome genome) {
        CExecutor.print(CExecutor.getRunningTime() + "Building genome effective region, please wait ");
        int total = 0;
        for (String chrID : genome.getChrIDs()) {
            ChromosomeEffectiveRegion chromosomeEffectiveRegion = new ChromosomeEffectiveRegion(genome.getChromosome(chrID));
            this.addChromosomeEffectiveRegion(chromosomeEffectiveRegion);
            total += chromosomeEffectiveRegion.getLength();
            CExecutor.print("*");
        }
        CExecutor.println("");
        this.setEffectiveRegionLength(total);
        this.ready = true;
        CExecutor.println(CExecutor.getRunningTime() + "Effective region: " + this.getChrIDs() + "\n");
    }

    private void addChromosomeEffectiveRegion(ChromosomeEffectiveRegion chromosomeEffectiveRegion) {
        this.chromosomeEffectiveRegion.put(chromosomeEffectiveRegion.getID(), chromosomeEffectiveRegion);
        if (this.getMaxPosition() < chromosomeEffectiveRegion.getMaxPosition()) {
            this.setMaxPosition(chromosomeEffectiveRegion.getMaxPosition());
        }
    }

    public int getLengt() {
        return this.effectiveRegionLength;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    private void setMaxPosition(int pos) {
        this.maxPosition = pos;
    }

    public ChromosomeEffectiveRegion getChromosomeEffectiveRegion(String chrID) {
        if (!this.chromosomeEffectiveRegion.keySet().contains(chrID)) {
            throw new NullPointerException();
        }
        return this.chromosomeEffectiveRegion.get(chrID);
    }

    public HashMap<String, ChromosomeEffectiveRegion> getChromosomeEffectiveRegions() {
        return this.chromosomeEffectiveRegion;
    }

    public boolean isReady() {
        return this.ready;
    }

    private void setEffectiveRegionLength(int length) {
        this.effectiveRegionLength = length;
    }

    public boolean isInEffectiveRegion(String chrID, int position) {
        if (!this.getChrIDs().contains(chrID)) {
            if (this.getChrIDs().contains("Chr" + chrID)) {
                chrID = "Chr" + chrID;
            } else {
                CExecutor.println("Do not find chromosome " + chrID + "; please check whether your chromosome id in vcf file is comsistent with chromosome id in gff file");
                return false;
            }
        }
        return this.getChromosomeEffectiveRegion(chrID).isInEffectiveRegion(position);
    }

    public LinkedList<Map.Entry<String, Integer>> getGeneEffectiveRegionLength() {
        HashMap<String, Integer> geneEffectiveRegionLength = new HashMap<String, Integer>();
        Iterator<String> it = this.getChromosomeEffectiveRegions().keySet().iterator();
        while (it.hasNext()) {
            ChromosomeEffectiveRegion chromosomeEffectiveRegion = this.getChromosomeEffectiveRegions().get(it.next());
            geneEffectiveRegionLength.putAll(chromosomeEffectiveRegion.getGeneEffectiveRegionLengthInChromosome());
        }
        LinkedList<Map.Entry<String, Integer>> sortedList = new LinkedList<Map.Entry<String, Integer>>(geneEffectiveRegionLength.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return sortedList;
    }

    public Set<String> getChromosomesID() {
        return this.chromosomeEffectiveRegion.keySet();
    }

    public Set<String> getGeneNames() {
        TreeSet<String> nameSet = new TreeSet<String>();
        Iterator<String> iterator = this.getChromosomesID().iterator();
        while (iterator.hasNext()) {
            nameSet.addAll(this.getChromosomeEffectiveRegion(iterator.next()).getGenesID());
        }
        return nameSet;
    }

    public GeneEffectiveRegion getGeneEffectiveRegion(String geneID) {
        for (String chrID : this.getChromosomesID()) {
            GeneEffectiveRegion geneEffectiveRegion = this.getChromosomeEffectiveRegion(chrID).get1GeneEffectiveRegionByGeneID(geneID);
            if (geneEffectiveRegion == null) continue;
            return geneEffectiveRegion;
        }
        return null;
    }

    static EffectiveRegionParameter getEffectiveRegionParameter() {
        return effectiveRegionParameter;
    }

    public LinkedList<GeneEffectiveRegion> getGeneEffectiveRegions() {
        LinkedList<GeneEffectiveRegion> list = new LinkedList<GeneEffectiveRegion>();
        for (String chr : this.getChrIDs()) {
            list.addAll(this.getChromosomeEffectiveRegion(chr).getChrGeneEffectiveRegions());
        }
        return list;
    }
}

