/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.effectiveRegion;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public class PositionContainer {
    private TreeSet<Integer> pointPositionContainer = new TreeSet();

    public void add2Container(LinkedList<int[]> regions) {
        for (int[] region : regions) {
            this.add2Container(region);
        }
    }

    public void add2Container(int[] region) {
        for (int i = region[0]; i <= region[1]; ++i) {
            this.add2Container(i);
        }
    }

    public void add2Container(int position) {
        this.pointPositionContainer.add(position);
    }

    public LinkedList<int[]> converterPointPosition2Region() {
        int former = 0;
        int middle = 0;
        int latter2 = 0;
        int[] segment = new int[2];
        LinkedList<int[]> segments = new LinkedList<int[]>();
        if (this.pointPositionContainer.size() == 0) {
            return segments;
        }
        for (int latter2 : this.pointPositionContainer) {
            if (former == 0) {
                former = latter2;
                middle = latter2;
                continue;
            }
            if (latter2 == middle + 1) {
                middle = latter2;
                continue;
            }
            if (latter2 == middle + 1) continue;
            segment[0] = former;
            segment[1] = middle;
            former = latter2;
            middle = latter2;
            segments.add(segment);
            segment = new int[2];
        }
        segment[0] = former;
        segment[1] = middle;
        segments.add(segment);
        return segments;
    }

    public void cleanContainer() {
        this.pointPositionContainer.clear();
    }

    public LinkedList<int[]> getUTR(LinkedList<int[]> exon, LinkedList<int[]> cds, String featureType, String strand) {
        if (exon.size() == 0 || cds.size() == 0) {
            return this.converterPointPosition2Region();
        }
        if (strand.equals("+") && featureType.equals("five_prime_UTR") || strand.equals("-") && featureType.equals("three_prime_UTR")) {
            this.add2Container(exon);
            int smallestCDSPosition = this.pointPositionContainer.last();
            for (int[] pos : cds) {
                for (int i = pos[0]; i <= pos[1]; ++i) {
                    this.removePosition(i);
                    if (smallestCDSPosition <= i) continue;
                    smallestCDSPosition = i;
                }
            }
            this.removePosition(">", smallestCDSPosition);
        } else {
            this.add2Container(exon);
            int bigestCDSPosition = this.pointPositionContainer.first();
            for (int[] pos : cds) {
                for (int i = pos[0]; i <= pos[1]; ++i) {
                    this.removePosition(i);
                    if (bigestCDSPosition >= i) continue;
                    bigestCDSPosition = i;
                }
            }
            this.removePosition("<", bigestCDSPosition);
        }
        return this.converterPointPosition2Region();
    }

    private void removePosition(LinkedList<int[]> position) {
        for (int[] pos : position) {
            for (int i = pos[0]; i <= pos[1]; ++i) {
                this.removePosition(i);
            }
        }
    }

    private void removePosition(int i) {
        this.pointPositionContainer.remove(i);
    }

    private void removePosition(String flag, int marker) {
        int pos;
        Iterator<Integer> iterator;
        if (flag.equals(">")) {
            iterator = this.pointPositionContainer.iterator();
            while (iterator.hasNext()) {
                pos = iterator.next();
                if (pos < marker) continue;
                iterator.remove();
            }
        }
        if (flag.equals("<")) {
            iterator = this.pointPositionContainer.iterator();
            while (iterator.hasNext()) {
                pos = iterator.next();
                if (pos > marker) continue;
                iterator.remove();
            }
        }
    }

    public int getNoRepeatPositionLength() {
        return this.pointPositionContainer.size();
    }
}

