/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.gffGenome;

import edu.zju.genome.gffGenome.Transcript;
import edu.zju.genome.gffGenome.TranscriptModule;
import java.util.HashMap;
import java.util.LinkedList;

public class Gene
extends edu.zju.genome.abstractGenome.Gene {
    private int[] site = new int[2];
    private HashMap<String, Transcript> transcripts;

    public Gene(String geneID, String geneName, String chrID, String strand, int start, int end) {
        super(geneID, geneName, chrID, strand);
        this.setPosition(start, end);
        this.transcripts = new HashMap();
    }

    protected void addTranscript(Transcript transcript) {
        this.transcripts.put(transcript.getID(), transcript);
    }

    private void setPosition(int startPositon, int endPosition) {
        this.site[0] = startPositon;
        this.site[1] = endPosition;
    }

    public LinkedList<Transcript> getTranscripts() {
        return new LinkedList<Transcript>(this.transcripts.values());
    }

    public Transcript getTranscript(String transcriptID) {
        return this.transcripts.get(transcriptID);
    }

    public int[] getSite() {
        return this.site;
    }

    public LinkedList<int[]> get1ModuleRegions(String feature) {
        LinkedList<int[]> regions = new LinkedList<int[]>();
        for (Transcript transcript : this.getTranscripts()) {
            regions.addAll(transcript.get1TypeModuleRegion(feature));
        }
        if ((feature.equals("five_prime_UTR") || feature.equals("three_prime_UTR")) && regions.size() == 0) {
            for (Transcript transcript : this.getTranscripts()) {
                regions.addAll(transcript.getUTR(feature, this.getStrand()));
            }
        }
        return regions;
    }

    protected void renewTranscript(Transcript transcript) {
        this.transcripts.put(transcript.getID(), transcript);
    }

    protected void addTranscriptModule(TranscriptModule transcriptModule) {
        Transcript transcript = this.getTranscript(transcriptModule.getParent());
        transcript.addTranscriptModule(transcriptModule);
        this.renewTranscript(transcript);
    }
}

