/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.gffGenome;

import edu.zju.common.CExecutor;
import edu.zju.common.LineHandler;
import edu.zju.genome.gffGenome.Chromosome;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class Genome
extends edu.zju.genome.abstractGenome.Genome {
    private HashMap<String, Chromosome> chromosomes;
    private boolean ready = false;
    private int genomeLength = 0;

    public Genome(String organism) {
        super(organism);
    }

    public Genome(String organism, LinkedList<String> genomeInformation) {
        super(organism);
        this.chromosomes = new HashMap();
        this.setGenome(genomeInformation);
    }

    public boolean isReady() {
        return this.ready;
    }

    private void setGenome(LinkedList<String> genomeInformation) {
        String chrID = null;
        LinkedList<String> chromosomeInformation = new LinkedList<String>();
        String line = null;
        LineHandler lh = new LineHandler();
        Iterator it = genomeInformation.iterator();
        while (it.hasNext()) {
            line = (String)it.next();
            lh.splitByTab(line);
            if (chrID == null) {
                chrID = lh.linesplit[0].trim().toString();
            }
            if (!chrID.equals(lh.linesplit[0].trim().toString())) {
                Chromosome chromosome = new Chromosome(chrID, chromosomeInformation);
                this.addChromosome(chromosome);
                chromosomeInformation = new LinkedList();
                chromosomeInformation.add(line);
                chrID = lh.linesplit[0].trim().toString();
            } else {
                chromosomeInformation.add(line);
            }
            it.remove();
        }
        Chromosome chromosome = new Chromosome(chrID, chromosomeInformation);
        this.addChromosome(chromosome);
        CExecutor.println("\n" + CExecutor.getRunningTime() + "GFF annotation: " + this.getChrIDs());
        chromosomeInformation.clear();
        this.ready = true;
    }

    private void addChromosome(Chromosome chromosome) {
        if (!(chromosome.getID().trim().isEmpty() || chromosome.getID().contains("ChrUn") || chromosome.getID().contains("ChrSy"))) {
            this.chromosomes.put(chromosome.getID(), chromosome);
            this.chrNumPlusOne();
            this.addChrID(chromosome.getID());
        }
    }

    public Chromosome getChromosome(String chromosomeID) {
        if (!this.chromosomes.containsKey(chromosomeID)) {
            CExecutor.println("There is no " + chromosomeID);
            return null;
        }
        return this.chromosomes.get(chromosomeID);
    }

    public LinkedList<Chromosome> getChromosomes() {
        LinkedList<Chromosome> chromosomes = new LinkedList<Chromosome>();
        for (String chrName : this.getChrIDs()) {
            chromosomes.add(this.getChromosome(chrName));
        }
        return chromosomes;
    }
}

