/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.gips;

import edu.zju.genome.effectiveRegion.GeneEffectiveRegion;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.gips.CandidateGeneBag;
import edu.zju.gips.SampleGene;
import edu.zju.gips.SampleGeneBag;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.SampleParameter;
import edu.zju.parameter.SampleParameterBag;
import edu.zju.variant.SNP;
import edu.zju.variant.SampleVariant;
import edu.zju.variant.SampleVariantBag;
import java.util.Iterator;

public class CandidateGeneSelector {
    private GenomeEffectiveRegion genomeEffectiveRegion;
    private SampleVariantBag sampleVariantBag;
    private SampleGeneBag geneSignificanceBag = new SampleGeneBag(0);
    private SampleParameterBag sampleParameterBag;

    public CandidateGeneSelector(GenomeEffectiveRegion genomeEffectiveRegion1, SampleParameterBag sampleParameterBag1, SampleGeneBag significanceBag) {
        this.setGenomeEffectiveRegion(genomeEffectiveRegion1);
        this.setSampleParameterBag(sampleParameterBag1);
        this.setGeneSignificanceBag(significanceBag);
    }

    private void setGenomeEffectiveRegion(GenomeEffectiveRegion genomeEffectiveRegion1) {
        this.genomeEffectiveRegion = genomeEffectiveRegion1;
    }

    private void setSampleParameterBag(SampleParameterBag sampleParameterBag1) {
        this.sampleParameterBag = sampleParameterBag1;
    }

    private void setSampleVariantBag(SampleVariantBag sampleVariantBag1) {
        this.sampleVariantBag = sampleVariantBag1;
    }

    private void setGeneSignificanceBag(SampleGeneBag bag) {
        this.geneSignificanceBag = bag;
    }

    public CandidateGeneBag selectCandidateGene() {
        int anticipation = GlobalParameter.getAnticipation();
        CandidateGeneBag candidateGeneBag = new CandidateGeneBag(anticipation);
        for (SampleGene candidateGeneToBeSelected : this.geneSignificanceBag.getSampleGenes()) {
            GeneEffectiveRegion geneEffectiveRegion = this.genomeEffectiveRegion.getGeneEffectiveRegion(candidateGeneToBeSelected.getID());
            Iterator<SampleParameter> sampleParameterIterator = this.sampleParameterBag.getBag().iterator();
            while (sampleParameterIterator.hasNext()) {
                SampleVariant sampleVariant = sampleParameterIterator.next().getSampleVariant();
                try {
                    for (SNP snp : sampleVariant.get1ChromosomeSNPs(geneEffectiveRegion.getChrID())) {
                        if (!geneEffectiveRegion.isInGeneEffectiveRegion(snp.getPosition())) continue;
                        String geneName = candidateGeneToBeSelected.getGeneName().trim();
                        if (snp.getSNPAnnotations().size() != 0 && !geneName.equals(snp.getSNPAnnotations().getFirst().getItsGeneName().trim())) continue;
                        candidateGeneToBeSelected.addSNPInThisGene(snp);
                    }
                }
                catch (Exception e) {
                }
            }
            if (candidateGeneToBeSelected.getSampleNumberHarboringMutationInThisGene() < anticipation) continue;
            candidateGeneToBeSelected.calculateSignificanceRegarlessOfAnticipation();
            candidateGeneBag.addCandidateGene(candidateGeneToBeSelected);
        }
        return candidateGeneBag;
    }
}

