/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.matrix;

import edu.zju.common.CExecutor;
import edu.zju.file.Config;
import edu.zju.matrix.Codon2AA;
import java.util.HashMap;

public class Matrix {
    private HashMap<String, Integer> matrix;
    private Codon2AA codon2AA;

    public Matrix(String matrixName) {
        this.matrix = Config.getMatrix(matrixName);
    }

    private void putScore(String orginAAAndMutatedAA, int score) {
        this.matrix.put(orginAAAndMutatedAA, score);
    }

    public int getScore(String originAA, String mutatedAA) {
        int minimumScore = 100;
        if (originAA.length() != mutatedAA.length()) {
            return -2;
        }
        for (int i = 0; i < originAA.length(); ++i) {
            String temp = originAA.substring(i, i + 1) + mutatedAA.substring(i, i + 1);
            if (!this.matrix.keySet().contains(temp)) {
                return 2;
            }
            if (minimumScore <= this.matrix.get(temp)) continue;
            minimumScore = this.matrix.get(temp);
        }
        return minimumScore;
    }

    public static boolean isMatrixName(String matrixName) {
        if (Config.getMatrix(matrixName) == null) {
            CExecutor.stopProgram("Don't find " + matrixName + " in config file");
            return false;
        }
        return true;
    }
}

