/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.options;

import edu.zju.common.CExecutor;
import edu.zju.file.CommonOutputFile;
import edu.zju.file.Config;
import edu.zju.file.FileFactory;
import edu.zju.parameter.ParameterList;
import edu.zju.parameter.ParameterLoader;
import java.io.File;
import java.util.LinkedList;

public class Init {
    private static String projectString;
    private static String projectName;
    private static String projectDirectory;
    private static String workingDirectory;
    private static String callerScriptDirectory;
    private static String dataDirectory;
    private static String parameterFilePath;
    private static String referenceDirectory;
    private static String temporaryFolder;
    private static String resultArchiveFolder;
    private LinkedList<String> GlobalParaList;

    public Init(String project) {
        projectString = project;
        this.initiateFilePath(project);
    }

    private void parseProjectPath(String project) {
        File p = new File(project);
        if (p.isDirectory()) {
            CExecutor.stopProgram("Project : \t" + project + " has been created before\n");
        } else if (p.isFile()) {
            CExecutor.stopProgram("Project : \t" + project + " should not be a file\n");
        } else if (p.isHidden()) {
            CExecutor.stopProgram("Project : \t" + project + " should not be hidden\n");
        }
    }

    public static String getParameterFilePath() {
        if (parameterFilePath == null) {
            CExecutor.stopProgram("Do not find project, please specify a project following '-p' option");
        }
        return parameterFilePath;
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getProjectString() {
        return projectString;
    }

    public static String getProjectDirectory() {
        if (projectDirectory == null) {
            CExecutor.stopProgram("Can't find project directory path");
        }
        return projectDirectory;
    }

    public void createProjectDirectory() {
        String projectDirectory = Init.getProjectDirectory();
        this.parseProjectPath(projectDirectory);
        File file = new File(projectDirectory);
        file.mkdirs();
        new File(workingDirectory).mkdirs();
        new File(callerScriptDirectory).mkdirs();
        new File(dataDirectory).mkdirs();
        new File(referenceDirectory).mkdirs();
        new File(temporaryFolder).mkdirs();
        new File(resultArchiveFolder).mkdirs();
        this.initParameterFile(parameterFilePath);
    }

    private void initiateFilePath(String project) {
        File p = new File(project);
        String projectDirectory = p.getAbsolutePath();
        this.setProjectDirectory(projectDirectory);
        workingDirectory = projectDirectory + CExecutor.getFileSeparator() + "Working";
        callerScriptDirectory = projectDirectory + CExecutor.getFileSeparator() + "Script";
        dataDirectory = projectDirectory + CExecutor.getFileSeparator() + "Data";
        parameterFilePath = projectDirectory + CExecutor.getFileSeparator() + "PROJECT.ini";
        referenceDirectory = projectDirectory + CExecutor.getFileSeparator() + "Ref";
        temporaryFolder = workingDirectory + CExecutor.getFileSeparator() + Config.getItem("IntermediateFile");
        resultArchiveFolder = workingDirectory + CExecutor.getFileSeparator() + "Archive";
        CExecutor.println("Project: " + projectName + "\nDirectory: " + projectDirectory);
    }

    private void setProjectDirectory(String path) {
        projectDirectory = path;
        projectName = path.split(CExecutor.getFileSeparator())[path.split(CExecutor.getFileSeparator()).length - 1];
    }

    public String getWorkingDirectory() {
        return workingDirectory;
    }

    private void initParameterFile(String path) {
        CommonOutputFile parameterFile = FileFactory.getOutputFile(path);
        ParameterLoader parameterLoader = new ParameterLoader();
        ParameterList parameterList = new ParameterList();
        LinkedList<String> globalParameter = parameterList.getGlobalParaList();
        for (String item : globalParameter) {
            if (item.startsWith("PROJECT")) {
                parameterFile.write("PROJECT :" + projectName + item.split(":")[1] + '\n');
                continue;
            }
            parameterFile.write(item + "\n");
        }
        parameterFile.write("\n[SAMPLE_LIST]\n\n");
        LinkedList<String> sampleBasicParater = parameterList.getSampleBasicParaList();
        for (String item : sampleBasicParater) {
            parameterFile.write(item + '\n');
        }
        parameterFile.closeOutput();
    }

    public static void setProjectName(String name) {
        projectName = name;
    }

    public static String getWorkingDirectroy() {
        return workingDirectory;
    }

    public static String getResultArchiveFolderDirectory() {
        return resultArchiveFolder;
    }

    public static String getRefDirectory() {
        return referenceDirectory;
    }

    public static String getScriptDirectory() {
        return callerScriptDirectory;
    }

    public static String getDataDirectory() {
        return dataDirectory;
    }

    public static String getTemporaryFolderPath() {
        return temporaryFolder;
    }
}

