/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.options;

import edu.zju.common.CExecutor;
import edu.zju.gips.GIPS;
import edu.zju.gips.ResultOutputer;
import edu.zju.options.HelpOption;
import edu.zju.options.Init;
import edu.zju.options.TESTProject;
import edu.zju.parameter.GIPSJob;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.ParameterLoader;
import java.io.IOException;

public class Main {
    private static String gipsHeader = "==============================================================================\n        Gene Identification via Phenotype Sequencing  (Version 1.3.5)\n     Copyright(c) 2014-2015, Zhongxu Zhu, Xin Chen. All Rights Reserved.\n==============================================================================\n";

    public static void main(String[] args) throws IOException, Exception {
        CExecutor.getRunningTime();
        boolean toolType = false;
        GIPSJob job = new GIPSJob();
        ParameterLoader ploader = new ParameterLoader();
        block18: for (int i = 0; i < args.length; ++i) {
            switch (args[i++]) {
                case "-T": {
                    GlobalParameter.setToolType(args[i]);
                    job.setJobType(args[i]);
                    continue block18;
                }
                case "-init": {
                    Init init = new Init(args[i]);
                    init.createProjectDirectory();
                    job.setJobType("init");
                    continue block18;
                }
                case "-p": {
                    Init init = new Init(args[i]);
                    continue block18;
                }
                case "-update": {
                    job.setJobNeedUpdate();
                    --i;
                    continue block18;
                }
                case "-Test": {
                    TESTProject testp = new TESTProject();
                    testp.initiateTestProject(CExecutor.getTerminalDirectoy());
                    job.setJobType("Test");
                    continue block18;
                }
                case "-h": {
                    new HelpOption().showHelp();
                    CExecutor.stopProgram("");
                }
                case "-H": {
                    new HelpOption().showHelp();
                    CExecutor.stopProgram("");
                }
                default: {
                    CExecutor.stopProgram("Do not find option " + args[i - 1]);
                }
            }
        }
        System.out.println(gipsHeader);
        job.setGlobalParameter(ploader.loadGlobalParameter(Init.getParameterFilePath()));
        job.setSampleParameterBag(ploader.loadSampleSpecificParameter(Init.getParameterFilePath()));
        job.jobCheck();
        GIPS gips = new GIPS(job);
        job = gips.gipsRun();
        ResultOutputer ro = new ResultOutputer(job);
        ro.outputResult();
        CExecutor.println("******** ******** ******** ********");
    }
}

