/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.common.NumeralHandler;
import edu.zju.file.CommonInputFile;
import edu.zju.file.FileFactory;
import edu.zju.file.SAM;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.options.Init;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.ParameterList;
import edu.zju.parameter.SampleParameterBag;
import edu.zju.variant.SampleVariant;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SampleParameter {
    private String sampleName;
    private double specifiedBackgroundMutationRate;
    private double specifyHomoVDS;
    private double specifyHeteroVDS;
    private double estimatedBackgroundMuationFreqency;
    private double estimatedHomoVCS = 0.0;
    private double estimatedHeteroVCS = 0.0;
    private double estimatedHomoVDS = 0.0;
    private double estimatedHeterVDS = 0.0;
    private CommonInputFile vcfFile;
    private CommonInputFile sequenceReadsFile;
    private int remaindSNPNumber;
    private String sampleIntermediateDateFilePath;
    private String callerScript;
    private String matrix;
    private int artificialSNPNumber;
    private int snpDensity = 0;
    private int maxAAsimilarityScore;
    private SampleVariant sampleVariant;
    private String controlFilePath;
    private double functionalFIR = 0.0;
    private double studyFIR = 0.0;
    private HashMap<String, HashSet<Integer>> studyPosition2Filter;
    private boolean isSpecifyBVF = false;
    private boolean isSpecifyHomoVariantDetectionSensitivity = false;
    private boolean isSpecifyHeteroVariantDetectionSensitivity = false;
    private String script_md5;
    private String vcf_md5;
    private String sam_md5;

    public SampleParameter(GlobalParameter globalParameter, HashMap<String, String> map) {
        this.matrix = globalParameter.getMatrix();
        this.callerScript = globalParameter.getCallerScriptPath();
        if (this.callerScript != null) {
            this.script_md5 = new CommonInputFile(this.callerScript).getFileMD5();
        }
        this.artificialSNPNumber = globalParameter.getArtificialSNPNumber();
        this.controlFilePath = globalParameter.getControlFilePath();
        this.snpDensity = globalParameter.getSNPDensity();
        this.maxAAsimilarityScore = globalParameter.getMaxAASimilarityScore();
        ParameterList pl = new ParameterList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String item = entry.getKey().trim();
            String info = entry.getValue().trim();
            pl.isInSampleSpecificItemList(item);
            switch (item) {
                case "SAMPLE_NAME": {
                    this.sampleName = info;
                    break;
                }
                case "SAMPLE.VCF": {
                    if (!info.contains(CExecutor.getFileSeparator())) {
                        info = Init.getDataDirectory() + CExecutor.getFileSeparator() + info;
                    }
                    this.setVCFFile(FileFactory.getInputFile(info, "VCF"));
                    break;
                }
                case "READS_ALIGNMENT.SAM": {
                    if (!info.contains(CExecutor.getFileSeparator())) {
                        info = Init.getDataDirectory() + CExecutor.getFileSeparator() + info;
                    }
                    this.sequenceReadsFile = FileFactory.getInputFile(info, "SAM");
                    break;
                }
                case "SPECIFY_HOMO_VDS": {
                    this.specifyHomoVDS = Double.parseDouble(info);
                    this.isSpecifyHomoVariantDetectionSensitivity = true;
                    break;
                }
                case "SPECIFY_HETERO_VDS": {
                    this.specifyHeteroVDS = Double.parseDouble(info);
                    this.isSpecifyHeteroVariantDetectionSensitivity = true;
                    break;
                }
                case "VAR_CALL_SCRIPT": {
                    if (!info.contains(CExecutor.getFileSeparator())) {
                        info = Init.getScriptDirectory() + CExecutor.getFileSeparator() + info;
                    }
                    this.callerScript = info;
                    this.script_md5 = new CommonInputFile(this.callerScript).getFileMD5();
                    break;
                }
                case "SCORE_MATRIX": {
                    this.matrix = info;
                    break;
                }
                case "CONTROL": {
                    this.controlFilePath = info;
                    break;
                }
                case "NUM_SIM_SNPS": {
                    if (info == null || info.isEmpty()) break;
                    this.artificialSNPNumber = Integer.parseInt(entry.getValue());
                    break;
                }
                case "MAX_VAR_DENSITY": {
                    if (info == null || info.isEmpty()) break;
                    this.snpDensity = Integer.parseInt(entry.getValue());
                    break;
                }
                case "SPECIFY_BVF": {
                    this.specifiedBackgroundMutationRate = Double.parseDouble(info);
                    this.isSpecifyBVF = true;
                    break;
                }
                case "ESTIMATED_HOMO_VDS": {
                    this.estimatedHomoVDS = Double.parseDouble(info);
                    break;
                }
                case "ESTIMATED_HETERO_VDS": {
                    this.estimatedHeterVDS = Double.parseDouble(info);
                    break;
                }
                case "ESTIMATED_HOMO_VCS": {
                    this.estimatedHomoVCS = Double.parseDouble(info);
                    break;
                }
                case "ESTIMATED_HETERO_VCS": {
                    this.estimatedHeteroVCS = Double.parseDouble(info);
                    break;
                }
                case "ESTIMATED_BVF": {
                    this.estimatedBackgroundMuationFreqency = Double.parseDouble(info);
                    break;
                }
                case "VCF_MD5": {
                    this.vcf_md5 = info;
                    break;
                }
                case "SAM_MD5": {
                    this.sam_md5 = info;
                    break;
                }
                case "SCRIPT_MD5": {
                    this.script_md5 = info;
                    break;
                }
                case "MAX_AA_SCORE": {
                    if (info == null || info.isEmpty()) break;
                    this.maxAAsimilarityScore = Integer.parseInt(entry.getValue());
                }
            }
        }
        this.sampleIntermediateDateFilePath = SampleParameterBag.getIntermediateFilePath() + System.getProperty("file.separator") + this.getName();
        new File(this.sampleIntermediateDateFilePath).mkdir();
    }

    private void setSampleName(String name) {
        this.sampleName = name;
    }

    private void setSequenceReadsFile(String path) {
        this.sequenceReadsFile = new SAM(path);
    }

    public void setEstimatedBackgroundMutationRate(double rate) {
        this.estimatedBackgroundMuationFreqency = rate;
        CExecutor.println(CExecutor.getRunningTime() + this.getName() + " background variant frequency (BVF) " + NumeralHandler.setScale(rate));
    }

    public void setEstimatedHomoVCS(double sensitivity) {
        CExecutor.println(this.getName() + " homozygous   variant calling sensitivity (VCS): " + sensitivity);
        this.estimatedHomoVCS = sensitivity;
    }

    public void setEstimatedHeteroVCS(double sensitivity) {
        CExecutor.println(this.getName() + " heterozygous variant calling sensitivity (VCS): " + sensitivity + '\n');
        this.estimatedHeteroVCS = sensitivity;
    }

    public double getHomoVCSEstimated() {
        return NumeralHandler.setScale(this.estimatedHomoVCS);
    }

    public double getHeteroVCSEstimated() {
        return NumeralHandler.setScale(this.estimatedHeteroVCS);
    }

    public double getFalseIgnoracneRate() {
        return NumeralHandler.setScale(1.0 - (1.0 - this.studyFIR) * (1.0 - this.functionalFIR));
    }

    public double getHomoVariantDetectionSensitivity() {
        if (this.specifyHomoVDS != 0.0) {
            return NumeralHandler.setScale(this.specifyHomoVDS);
        }
        return NumeralHandler.setScale(this.getHomoVCSEstimated() * (1.0 - this.studyFIR) * (1.0 - this.functionalFIR));
    }

    public double getHeteroVariantDetectionSensitivity() {
        if (this.specifyHeteroVDS != 0.0) {
            return NumeralHandler.setScale(this.specifyHeteroVDS);
        }
        return NumeralHandler.setScale(this.getHeteroVCSEstimated() * (1.0 - this.studyFIR) * (1.0 - this.functionalFIR));
    }

    public double getHomoVariantDetectionSensitivityEstimated() {
        return NumeralHandler.setScale(this.getHomoVCSEstimated() * (1.0 - this.studyFIR) * (1.0 - this.functionalFIR));
    }

    public double getHeteroVariantDetectionSensitivityEstimated() {
        return NumeralHandler.setScale(this.getHeteroVCSEstimated() * (1.0 - this.studyFIR) * (1.0 - this.functionalFIR));
    }

    public double getBackgroundMutationFrequencyNoConsiderSpeficyOrEstimate() {
        if (this.specifiedBackgroundMutationRate != 0.0) {
            return NumeralHandler.setScale(this.specifiedBackgroundMutationRate);
        }
        if (this.estimatedBackgroundMuationFreqency != 0.0) {
            return NumeralHandler.setScale(this.estimatedBackgroundMuationFreqency);
        }
        return 0.0;
    }

    public String getName() {
        return this.sampleName;
    }

    public CommonInputFile getSequenceReadsFile() {
        return this.sequenceReadsFile;
    }

    int getRemainedSNPNumber() {
        return this.remaindSNPNumber;
    }

    private void setVCFFile(CommonInputFile file) {
        this.vcfFile = file;
    }

    public CommonInputFile getVCFFile() {
        return this.vcfFile;
    }

    public String getSampleIntermediateFilePath() {
        return this.sampleIntermediateDateFilePath;
    }

    public int getArtificialSNPNumber() {
        return this.artificialSNPNumber;
    }

    public void setSampleVariant(SampleVariant sampleVariant1) {
        this.sampleVariant = sampleVariant1;
        this.remaindSNPNumber = sampleVariant1.getSNPCounts();
    }

    public SampleVariant getSampleVariant() {
        if (this.sampleVariant == null) {
            this.sampleVariant = new SampleVariant(this.getName());
        }
        return this.sampleVariant;
    }

    public String getMatrix() {
        return this.matrix;
    }

    public CommonInputFile getControlFile() {
        if (this.controlFilePath == null || this.controlFilePath.trim().isEmpty()) {
            return null;
        }
        return FileFactory.getInputFile(this.controlFilePath, "VariantControl");
    }

    public void setFunctionalFIR(double fir) {
        this.functionalFIR = fir;
    }

    public void setStudyFIR(double fir) {
        this.studyFIR = fir;
    }

    public void addStudyPositionToFilter(String chr, int pos) {
        if (this.studyPosition2Filter == null) {
            this.studyPosition2Filter = new HashMap();
        }
        HashSet<Object> chrPosSet = new HashSet();
        if (!this.studyPosition2Filter.containsKey(chr)) {
            this.studyPosition2Filter.put(chr, chrPosSet);
        }
        chrPosSet = this.studyPosition2Filter.get(chr);
        chrPosSet.add(pos);
        this.studyPosition2Filter.put(chr, chrPosSet);
    }

    public void addStudyPositionToFilter(HashMap<String, HashSet<Integer>> map) {
        if (this.studyPosition2Filter == null) {
            this.studyPosition2Filter = new HashMap();
        }
        HashSet<Object> chrPosSet = new HashSet();
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String chr : map.keySet()) {
            if (!this.studyPosition2Filter.containsKey(chr)) {
                this.studyPosition2Filter.put(chr, chrPosSet);
            }
            chrPosSet = this.studyPosition2Filter.get(chr);
            chrPosSet.addAll((Collection)map.get(chr));
            this.studyPosition2Filter.put(chr, chrPosSet);
        }
    }

    void estimateStudyFir(GenomeEffectiveRegion genomeEffectiveRegion) {
        int positionSum = 0;
        try {
            for (String chr : this.studyPosition2Filter.keySet()) {
                HashSet<Integer> posSet = this.studyPosition2Filter.get(chr);
                for (int pos : posSet) {
                    if (!genomeEffectiveRegion.isInEffectiveRegion(chr, pos)) continue;
                    ++positionSum;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.studyPosition2Filter = null;
        this.studyFIR = (double)positionSum / (double)genomeEffectiveRegion.getLengt();
    }

    public String getCallerScript() {
        return this.callerScript;
    }

    public String getSampleFilterStrategy2String() {
        StringBuffer string = new StringBuffer();
        String filters = GlobalParameter.getFilersString();
        string.append(" Filters: " + filters);
        if (filters.contains("E")) {
            string.append("\n# Effective region: " + GlobalParameter.getEffectiveRegionString());
        }
        if (filters.contains("B")) {
            string.append("\n# Score matrix: " + this.matrix);
        }
        if (this.controlFilePath != null) {
            string.append("\n# Control:" + this.controlFilePath);
        }
        return string.toString();
    }

    public double getFalseIgnoranceRateOfFunction() {
        return NumeralHandler.setScale(this.functionalFIR);
    }

    public double getFalseIgnoranceRateOfStudy() {
        return NumeralHandler.setScale(this.studyFIR);
    }

    public int getSNPDensity() {
        return this.snpDensity;
    }

    public double getBackgroundMutationRateEstimated() {
        return NumeralHandler.setScale(this.estimatedBackgroundMuationFreqency);
    }

    public boolean isPassSpecify() {
        return this.isSpecifyBVF && this.isSpecifyHeteroVariantDetectionSensitivity && this.isSpecifyHomoVariantDetectionSensitivity;
    }

    public boolean isSpecified() {
        return this.isSpecifyBVF || this.isSpecifyHeteroVariantDetectionSensitivity || this.isSpecifyHomoVariantDetectionSensitivity;
    }

    String getVCFMd5() {
        if (this.vcf_md5 == null) {
            if (this.vcfFile == null) {
                return "no md5";
            }
            this.vcf_md5 = this.vcfFile.getFileMD5();
        }
        return this.vcf_md5;
    }

    String getSAMMd5() {
        if (this.sam_md5 == null) {
            if (this.sequenceReadsFile == null) {
                return "no md5";
            }
            this.sam_md5 = this.sequenceReadsFile.getFileMD5();
        }
        return this.sam_md5;
    }

    String getScriptMd5() {
        if (this.script_md5 == null) {
            if (this.callerScript == null) {
                return "no md5";
            }
            this.script_md5 = new CommonInputFile(this.callerScript).getFileMD5();
        }
        return this.script_md5;
    }

    public int getMaxAASimilarityScore() {
        return this.maxAAsimilarityScore;
    }
}

