/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.file.CommonInputFile;
import edu.zju.genome.artificial.ArtificialSNPGenerator;
import edu.zju.genome.artificial.ArtificialSequenceReadsFileGenerator;
import edu.zju.genome.artificial.SampleArtificialGenome;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.parameter.SampleParameter;
import edu.zju.snpCaller.SNPCaller;
import edu.zju.variant.SampleVariant;

public class VariantCallingSensitivityDectectorParameter {
    private int mode = 0;
    private GenomeEffectiveRegion genomeEffectiveRegion;
    private SampleVariant sampleVariant;
    private CommonInputFile sequenceReadsFile;
    private CommonInputFile artificialSNPPositionFile;
    private int artificialSNPNumber;
    private SampleArtificialGenome sampleArtificialGenome;
    private String callerScript;

    public VariantCallingSensitivityDectectorParameter(SampleParameter sampleParameter) {
        this.renewSequenceReadsFile(sampleParameter.getSequenceReadsFile());
        this.setArtificialSNPNumber(sampleParameter.getArtificialSNPNumber());
        this.setCallerScript(sampleParameter.getCallerScript());
    }

    public VariantCallingSensitivityDectectorParameter(int artificialSNPNumber) {
        this.setArtificialSNPNumber(artificialSNPNumber);
    }

    public VariantCallingSensitivityDectectorParameter() {
    }

    private void setArtificialSNPNumber(int number) {
        this.artificialSNPNumber = number;
    }

    public int getArtificialSNPNumber() {
        return this.artificialSNPNumber;
    }

    public void setGenotypeMode(int mode) {
        this.mode = mode;
    }

    private int getGenotypeMode() {
        return this.mode;
    }

    public void setGenomeEffectiveRegion(GenomeEffectiveRegion genomeEffectiveRegion1) {
        this.genomeEffectiveRegion = genomeEffectiveRegion1;
    }

    private GenomeEffectiveRegion getGenomeEffectiveRegion() {
        return this.genomeEffectiveRegion;
    }

    private SampleVariant getSampleVariant() {
        return this.sampleVariant;
    }

    private CommonInputFile getSequenceReadsFile() {
        return this.sequenceReadsFile;
    }

    void setArtificialSNPPositionFile(CommonInputFile file) {
        this.artificialSNPPositionFile = file;
    }

    public CommonInputFile getArtificialSNPPositionFile() {
        return this.artificialSNPPositionFile;
    }

    private SampleArtificialGenome getSampleArtificialGenome() {
        SampleArtificialGenome sampleArtificialGenome = null;
        ArtificialSNPGenerator artificialSNPGenerator = new ArtificialSNPGenerator(this.getGenomeEffectiveRegion(), this.getSampleVariant(), this.getGenotypeMode(), this.getArtificialSNPNumber());
        CExecutor.println(CExecutor.getRunningTime() + "----- ----- ----- ----- ----- ----- ----- ----- -----\n" + CExecutor.getRunningTime() + this.getSampleVariant().getName() + " number of SNPs to simulate: " + this.getArtificialSNPNumber());
        sampleArtificialGenome = artificialSNPGenerator.generate();
        this.setArtificialSNPPositionFile(artificialSNPGenerator.getArtificialSNPPositionFile());
        this.sampleArtificialGenome = sampleArtificialGenome;
        return sampleArtificialGenome;
    }

    public SNPCaller getSNPCaller() {
        ArtificialSequenceReadsFileGenerator artificialSequenceReadsFileGenerator = new ArtificialSequenceReadsFileGenerator(this.getSequenceReadsFile(), this.getSampleArtificialGenome());
        SNPCaller snpc = new SNPCaller(artificialSequenceReadsFileGenerator.generate(), this.sampleVariant.getName(), this.getCallerScriptFilePath());
        return snpc;
    }

    public void renewSampleVariant(SampleVariant sampleVariant) {
        this.sampleVariant = sampleVariant;
    }

    public void renewSequenceReadsFile(CommonInputFile file) {
        this.sequenceReadsFile = file;
    }

    public SampleArtificialGenome getSampleArtificialGenomeForDetecting() {
        return this.sampleArtificialGenome;
    }

    private void setCallerScript(String script) {
        this.callerScript = script;
    }

    public String getCallerScriptFilePath() {
        return this.callerScript;
    }
}

