/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.snpAnnotationTools;

import edu.zju.common.CExecutor;
import edu.zju.common.FileHandler;
import edu.zju.common.LineHandler;
import edu.zju.common.ZipUtil;
import edu.zju.file.CommonInputFile;
import edu.zju.file.Config;
import edu.zju.file.FileFactory;
import edu.zju.file.FileFolder;
import edu.zju.matrix.AA2Symbol;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.SampleParameterBag;
import edu.zju.snpAnnotationTools.SNPAnnotationTool;
import edu.zju.snpAnnotationTools.SNPEffEFF;
import edu.zju.variant.ClinSigSNP;
import edu.zju.variant.SNP;
import edu.zju.variant.SNPAnnotation;
import edu.zju.variant.SampleSNP;
import edu.zju.variant.SampleVariant;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class SNPEff
extends SNPAnnotationTool {
    protected String sampleName;
    protected String annotationToolName = "SNP effect predictor: snpEff";
    protected String snpEffPath = GlobalParameter.getSNPEffPath();
    protected String genomeVersion;
    private HashSet<String> highRisk = new HashSet<String>(){
        {
            this.add("SPLICE_SITE_ACCEPTOR");
            this.add("SPLICE_SITE_DONOR");
            this.add("START_LOST");
            this.add("EXON_DELETED");
            this.add("FRAME_SHIFT");
            this.add("STOP_GAINED");
            this.add("RARE_AMINO_ACID");
            this.add("CODON_INSERTION");
            this.add("CODON_DELETION");
            this.add("chromosome");
            this.add("exon_loss_variant");
            this.add("frameshift_variant");
            this.add("rare_amino_acid_variant");
            this.add("splice_acceptor_variant");
            this.add("splice_donor_variant");
            this.add("start_lost");
            this.add("stop_gained");
            this.add("stop_lost");
        }
    };
    private HashSet<String> pastEff = new HashSet<String>(){
        {
            this.add("UTR_5_PRIME");
            this.add("UTR_3_PRIME");
            this.add("REGULATION");
            this.add("UPSTREAM");
            this.add("DOWNSTREAM");
            this.add("GENE");
            this.add("TRANSCRIPT");
            this.add("EXON");
            this.add("INTRON_CONSERVED");
            this.add("INTRON");
            this.add("INTRAGENIC");
            this.add("INTERGENIC_CONSERVED");
            this.add("NONE");
            this.add("CHROMOSOME");
            this.add("CUSTOM");
            this.add("CDS");
            this.add("downstream_gene_variant");
            this.add("upstream_gene_variant");
            this.add("intron_variant");
            this.add("intergenic_region");
            this.add("5_prime_UTR_variant");
            this.add("splice_region_variant");
            this.add("intron_variant");
            this.add("5_prime_UTR_premature_start_codon_gain_variant");
            this.add("3_prime_UTR_variant");
            this.add("intragenic_variant");
            this.add("sequence_feature");
        }
    };
    protected String effectField;

    @Override
    public SampleVariant getSampleAnnotatedVariant(String sampleName, CommonInputFile file) {
        this.sampleName = sampleName;
        SampleVariant sampleVariant = new SampleVariant(sampleName);
        CommonInputFile vcfAnnotatedFile = null;
        vcfAnnotatedFile = this.annotateVCFFile(sampleName, file);
        sampleVariant.setVCFFile(vcfAnnotatedFile);
        String line = null;
        LineHandler lineHandler = new LineHandler();
        while ((line = vcfAnnotatedFile.readLine()) != null) {
            String eff;
            if (line.trim().isEmpty() || line.toCharArray()[0] == '#') continue;
            SNP snp = !sampleName.equals(Config.getItem("CLIN_VAR_NAME")) ? new SampleSNP(line, sampleName) : new ClinSigSNP(line, sampleName);
            if (line.contains("EFF=")) {
                eff = lineHandler.regexMatch(line, "EFF=(.*\\))");
                snp.setSNPRawInfoBeforeAnnotate(line.replace("EFF=" + eff, ""));
                snp.setAnnotationFieldInfo(eff);
                snp = this.annotate1SNPByEff(snp);
            } else if (line.contains("ANN=")) {
                String ann = lineHandler.regexMatch(line, "ANN=(.*\\|)");
                snp.setSNPRawInfoBeforeAnnotate(line.replace("ANN=" + ann, ""));
                snp.setAnnotationFieldInfo(ann);
                snp = this.annotate1SNPByAnn(snp);
            } else {
                eff = lineHandler.regexMatch(line, "EFF=(.*\\))");
                snp.setSNPRawInfoBeforeAnnotate(line.replace("EFF=" + eff, ""));
                snp.setAnnotationFieldInfo(eff);
                snp = this.annotate1SNPByEff(snp);
            }
            sampleVariant.addSNP(snp);
        }
        return sampleVariant;
    }

    @Override
    protected CommonInputFile annotateVCFFile(String sampleName, CommonInputFile file) {
        String line;
        while ((line = file.readLine()) != null) {
            if (line.trim().isEmpty() || line.toCharArray()[0] == '#' || !line.contains("EFF=") && !line.contains("ANN=")) continue;
            file.closeInput();
            return file;
        }
        String targetPath = SampleParameterBag.getIntermediateFilePath() + System.getProperty("file.separator") + sampleName + System.getProperty("file.separator") + sampleName + ".eff.vcf";
        targetPath = this.annotateSampleVcfFile(file.getFilePath(), targetPath);
        return FileFactory.getInputFile(targetPath, "VCF");
    }

    protected String annotateSampleVcfFile(String filePath, String targetPath) {
        return null;
    }

    private SNP annotate1SNPByEff(SNP snp) {
        LineHandler lineHandler = new LineHandler();
        String effInfo = snp.getAnnotationFieldInfo();
        if (effInfo == null) {
            SNPAnnotation temp = new SNPAnnotation();
            temp.setPassBigDifferenceFilter();
            snp.addSNPAnnotation(temp);
            return snp;
        }
        for (int i = 0; i < effInfo.split(",").length; ++i) {
            SNPAnnotation snpAnnotation = new SNPAnnotation();
            String effectInfo = effInfo.split(",")[i];
            String geneName = effectInfo.split("\\|")[5];
            snpAnnotation.setItsGeneName(geneName);
            String effect = effectInfo.split("\\(")[0];
            snpAnnotation.setEffect(effect);
            if (this.pastEff.contains(effect)) {
                snpAnnotation.setPassBigDifferenceFilter();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            if (this.highRisk.contains(effect)) {
                snpAnnotation.setHighRisk();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            String codonChange = effectInfo.split("\\|")[3];
            String originAA = null;
            String mutationAA = null;
            String middle = lineHandler.regexMatch(codonChange, "(\\d+)");
            if (middle == null) {
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            String[] temp = codonChange.split(middle);
            if (temp.length == 1) {
                originAA = mutationAA = codonChange.split(middle)[0];
            } else {
                originAA = temp[0];
                mutationAA = temp[1];
            }
            if (originAA != null && mutationAA != null) {
                snpAnnotation.setAA_Symbol_Change(originAA.toUpperCase(), mutationAA.toUpperCase());
            }
            snp.addSNPAnnotation(snpAnnotation);
        }
        return snp;
    }

    private SNP annotate1SNPByAnn(SNP snp) {
        LineHandler lineHandler = new LineHandler();
        String annInfo = snp.getAnnotationFieldInfo();
        if (annInfo == null) {
            SNPAnnotation temp = new SNPAnnotation();
            temp.setPassBigDifferenceFilter();
            snp.addSNPAnnotation(temp);
            return snp;
        }
        AA2Symbol a2Symbol = new AA2Symbol();
        for (int i = 0; i < annInfo.split(",").length; ++i) {
            int j;
            SNPAnnotation snpAnnotation = new SNPAnnotation();
            String annField = annInfo.split(",")[i];
            String effect = annField.split("\\|")[1];
            snpAnnotation.setEffect(effect);
            String geneName = null;
            try {
                geneName = annField.split("\\|")[3];
            }
            catch (Exception e) {
                snpAnnotation.setItsGeneName("");
                snpAnnotation.setPassBigDifferenceFilter();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            snpAnnotation.setItsGeneName(geneName);
            boolean is = true;
            for (j = 0; j < effect.split("&").length; ++j) {
                if (this.pastEff.contains(effect.split("&")[j].trim())) continue;
                is = false;
            }
            if (is) {
                snpAnnotation.setPassBigDifferenceFilter();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            is = false;
            for (j = 0; j < effect.split("&").length; ++j) {
                if (!this.highRisk.contains(effect.split("&")[j].trim())) continue;
                snpAnnotation.setHighRisk();
                snp.addSNPAnnotation(snpAnnotation);
                is = true;
                break;
            }
            if (is) continue;
            String codonChange = null;
            try {
                codonChange = annField.split("\\|")[10];
            }
            catch (Exception e) {
                snpAnnotation.setPassBigDifferenceFilter();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            if (codonChange.contains("del") || codonChange.contains("ins") || codonChange.contains("dup") || codonChange.contains("?")) {
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            String originAA = null;
            String mutationAA = null;
            codonChange = codonChange.replace("p.", "");
            String middle = lineHandler.regexMatch(codonChange, "(\\d+)");
            String[] temp = null;
            try {
                temp = codonChange.split(middle);
            }
            catch (Exception e) {
                snpAnnotation.setPassBigDifferenceFilter();
                snp.addSNPAnnotation(snpAnnotation);
                continue;
            }
            if (temp.length == 1) {
                originAA = mutationAA = codonChange.split(middle)[0];
            } else {
                originAA = temp[0];
                mutationAA = temp[1];
            }
            if (originAA != null && mutationAA != null) {
                originAA = a2Symbol.getSymbol(originAA);
                mutationAA = a2Symbol.getSymbol(mutationAA);
                snpAnnotation.setAA_Symbol_Change(originAA.toUpperCase(), mutationAA.toUpperCase());
            }
            snp.addSNPAnnotation(snpAnnotation);
        }
        snp.clearAnnotationFieldInfo();
        return snp;
    }

    protected String getSNPEffData_dir() {
        String snpEffDataPath;
        String snpEffConfigFilePath = this.snpEffPath + System.getProperty("file.separator") + "snpEff.config";
        File file = new File(snpEffConfigFilePath);
        if (!file.isFile()) {
            CExecutor.stopProgram("Do not find snpEff.config in " + this.snpEffPath);
        }
        FileHandler fileHandler = new FileHandler();
        fileHandler.readFile(snpEffConfigFilePath);
        String line = null;
        try {
            while ((line = fileHandler.br.readLine()) != null && !line.trim().startsWith("data_dir") && !line.trim().startsWith("data.dir")) {
            }
            fileHandler.br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (line == null) {
            CExecutor.stopProgram("Do not find data.dir (after version4 )or data_dir (before version4) field in snpEff.config file");
        }
        if (!(snpEffDataPath = line.split("=")[1].trim()).startsWith(CExecutor.getFileSeparator()) && !snpEffDataPath.startsWith("~")) {
            snpEffDataPath = this.snpEffPath + CExecutor.getFileSeparator() + snpEffDataPath;
        }
        return snpEffDataPath;
    }

    protected void addGIPSTestInfoIntoSnpEffConfig() {
        String snpEffConfigPath = GlobalParameter.getSNPEffPath() + System.getProperty("file.separator") + "snpEff.config";
        File file = new File(snpEffConfigPath);
        BufferedReader br = null;
        Writer bw = null;
        boolean isNeedToAppendInfo = true;
        try {
            br = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("Test.genome")) continue;
                    isNeedToAppendInfo = false;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (isNeedToAppendInfo) {
            try {
                bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(snpEffConfigPath), true)));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                bw.write("\n# GIPS Test Genome\nTest.genome : Test\n");
                ((BufferedWriter)bw).flush();
                ((BufferedWriter)bw).close();
                this.buildTestGenomeDatabase();
            }
            catch (IOException ex) {
                Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected void buildTestGenomeDatabase() {
        boolean b;
        String testFolderPath;
        File testFolder;
        boolean b2;
        String snpEffFolderPath = GlobalParameter.getSNPEffPath();
        String snpEffDataFolderPath = snpEffFolderPath + System.getProperty("file.separator") + "data";
        FileFolder snpEffFolder = new FileFolder(snpEffFolderPath);
        File snpEffDataFolder = new File(snpEffDataFolderPath);
        if (!snpEffDataFolder.isDirectory() && !(b2 = snpEffDataFolder.mkdir())) {
            CExecutor.stopProgram("Fail to creat 'data' folder in " + snpEffFolderPath + "\n Please 'mkdir " + snpEffDataFolderPath + '\'');
        }
        if (!(testFolder = new File(testFolderPath = this.getSNPEffData_dir() + System.getProperty("file.separator") + GlobalParameter.getGenomeVersion())).isDirectory() && !(b = testFolder.mkdirs())) {
            CExecutor.stopProgram("Fail to creat 'data' folder in " + testFolderPath + "\n Please 'mkdir " + testFolderPath + '\'');
        }
        int temp = 0;
        String sourceFilePathInPackage = null;
        sourceFilePathInPackage = Config.getItem("Test.Genes.Gff");
        InputStream is = this.getClass().getResourceAsStream(sourceFilePathInPackage);
        File binFile = new File(testFolderPath + System.getProperty("file.separator") + "genes.gff");
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(binFile);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            while ((temp = is.read()) != -1) {
                ((OutputStream)os).write(temp);
            }
            os.flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        CExecutor executor = new CExecutor();
        executor.execute("cd " + this.snpEffPath + "\n java -jar snpEff.jar build -gff3 -v Test\n");
    }

    protected void unzipGenomeToDataFile(String path) {
        try {
            String snpEffDataPath = this.getSNPEffData_dir();
            if (!new File(snpEffDataPath).isDirectory()) {
                new File(snpEffDataPath).mkdirs();
            }
            new ZipUtil().unzipFiles(new File(path), new File(snpEffDataPath).getParentFile().getAbsolutePath());
        }
        catch (ZipException ex) {
            CExecutor.stopProgram("Failt unzip " + path);
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            CExecutor.stopProgram("Failt unzip " + path);
            Logger.getLogger(SNPEffEFF.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected boolean compareTwoFiles(String vcfPath, String snpEffFilePath) {
        String line;
        int number = 0;
        CommonInputFile file = FileFactory.getInputFile(vcfPath, "VCF");
        while ((line = file.readLine()) != null) {
            if (line.startsWith("#")) continue;
            ++number;
        }
        file.closeInput();
        file = FileFactory.getInputFile(snpEffFilePath, "VCF");
        while ((line = file.readLine()) != null) {
            if (line.startsWith("#")) continue;
            --number;
        }
        file.closeInput();
        return number >= -2 && number <= 2;
    }
}

