/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.snpCaller;

import edu.zju.common.CExecutor;
import edu.zju.file.CommonInputFile;
import edu.zju.genome.artificial.SampleArtificialGenome;
import edu.zju.parameter.VariantCallingSensitivityDectectorParameter;
import edu.zju.snpCaller.SNPCaller;

public class VariantCallingSensitivityDetector {
    private VariantCallingSensitivityDectectorParameter genotypingSensitivityDectectorParameter;
    private int artificialSNPNumber;
    private CommonInputFile vcfFile;
    private String callerScript;

    public VariantCallingSensitivityDetector(VariantCallingSensitivityDectectorParameter genotypingSensitivityDectectorParameter) {
        this.setGenotypingSensitivityDectectorParameter(genotypingSensitivityDectectorParameter);
        this.setArtificialSNPNumber(genotypingSensitivityDectectorParameter.getArtificialSNPNumber());
        this.setCallerScript(genotypingSensitivityDectectorParameter.getCallerScriptFilePath());
    }

    private void setGenotypingSensitivityDectectorParameter(VariantCallingSensitivityDectectorParameter genotypingSensitivityDectectorParameter1) {
        this.genotypingSensitivityDectectorParameter = genotypingSensitivityDectectorParameter1;
    }

    protected VariantCallingSensitivityDectectorParameter getGenotypingSensitivityDectectorParameter() {
        return this.genotypingSensitivityDectectorParameter;
    }

    public void genotyping(int mode) {
        if (mode != 0) {
            SNPCaller snpCaller = this.genotypingSensitivityDectectorParameter.getSNPCaller();
            CExecutor.println(CExecutor.getRunningTime() + "Detecting variant calling sensitivity");
            this.vcfFile = snpCaller.genotype();
        }
    }

    private void setArtificialSNPNumber(int number) {
        this.artificialSNPNumber = number;
    }

    protected int getArtificialSNPNumber() {
        return this.artificialSNPNumber;
    }

    public double getHomoVariantCallingSensitivty() {
        String line;
        CommonInputFile vcfFile = this.vcfFile;
        int snpNumber = 0;
        while ((line = vcfFile.readLine()) != null) {
            int snpVCFPos = 0;
            if (line.toCharArray()[0] == '#') continue;
            String snpVCFChr = line.split("\t")[0].trim().toString();
            try {
                snpVCFPos = Integer.valueOf(line.split("\t")[1].trim().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                CExecutor.stopProgram("\n########################\nCan't read " + this.vcfFile.getFilePath() + "\n\t\tIs a VCF format file?");
            }
            if (!line.split("\t")[9].contains("1/1")) continue;
            String variantType = "1/1";
            SampleArtificialGenome temp = this.genotypingSensitivityDectectorParameter.getSampleArtificialGenomeForDetecting();
            if (!temp.isArtificialSNP(snpVCFChr, snpVCFPos, variantType)) continue;
            ++snpNumber;
        }
        vcfFile.closeInput();
        return (double)snpNumber / (double)this.getArtificialSNPNumber();
    }

    public double getHeteroVariantCallingSensitivty() {
        String line;
        CommonInputFile vcfFile = this.vcfFile;
        int snpNumber = 0;
        while ((line = vcfFile.readLine()) != null) {
            if (line.toCharArray()[0] == '#') continue;
            String snpVCFChr = line.split("\t")[0].trim().toString();
            int snpVCFPos = Integer.valueOf(line.split("\t")[1].trim().toString());
            if (!line.split("\t")[9].contains("0/1")) continue;
            String variantType = "0/1";
            SampleArtificialGenome temp = this.genotypingSensitivityDectectorParameter.getSampleArtificialGenomeForDetecting();
            if (!temp.isArtificialSNP(snpVCFChr, snpVCFPos, variantType)) continue;
            ++snpNumber;
        }
        vcfFile.closeInput();
        return (double)snpNumber / (double)this.getArtificialSNPNumber();
    }

    private void setCallerScript(String script) {
        this.callerScript = script;
    }

    private String getCallerScriptFile() {
        return this.callerScript;
    }
}

