/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.variant;

import edu.zju.common.CExecutor;
import edu.zju.common.LineHandler;
import edu.zju.variant.SNPAnnotation;
import java.util.LinkedList;
import java.util.TreeSet;

public abstract class SNP {
    private String chr;
    private int position;
    private String ref;
    private String alt;
    private String genotype = "-1";
    private String id;
    private LinkedList<SNPAnnotation> snpAnnotations;
    private String sampleName;
    private String snpRawInfoBeforeAnnotateInVcf;
    private String annotationFieldInfo;
    private boolean inWindow = false;
    private String depth = "0";
    private String quality = "0";

    public SNP(String snpInfo, String sampleName) {
        this.setSampleName(sampleName);
        this.setSNP(snpInfo);
        this.snpAnnotations = new LinkedList();
    }

    private void setSNP(String snpInfo) {
        LineHandler lineHandler = new LineHandler();
        lineHandler.splitByTab(snpInfo);
        String chr = lineHandler.linesplit[0].trim().toString();
        if (chr.isEmpty()) {
            this.setChr(null);
            return;
        }
        this.setChr(chr);
        try {
            this.setPosition(Integer.parseInt(lineHandler.linesplit[1]));
        }
        catch (NumberFormatException e) {
            CExecutor.stopProgram(lineHandler.linesplit[1] + " is not a position in " + this.getSampleName() + "\n" + snpInfo);
            this.setPosition(0);
        }
        this.setId(lineHandler.linesplit[2]);
        this.setRef(lineHandler.linesplit[3]);
        this.setAlt(lineHandler.linesplit[4]);
        try {
            this.setDepth(lineHandler.regexMatch(lineHandler.linesplit[7], "DP=(\\d*)\\;"));
            String genotype = this.getGTInformation(snpInfo);
            this.setGenotype(genotype);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
    }

    private void setChr(String chr) {
        this.chr = chr;
    }

    private void setPosition(int position) {
        this.position = position;
    }

    private void setRef(String ref) {
        this.ref = ref;
    }

    private void setAlt(String alt) {
        this.alt = alt;
    }

    private void setGenotype(String genotype) {
        this.genotype = genotype;
    }

    public String getChr() {
        return this.chr;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRef() {
        return this.ref;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public void addSNPAnnotation(SNPAnnotation snpAnnotation) {
        this.snpAnnotations.add(snpAnnotation);
    }

    public LinkedList<SNPAnnotation> getSNPAnnotations() {
        return this.snpAnnotations;
    }

    private void setSampleName(String name) {
        this.sampleName = name;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public String getSNPInfoInVcf() {
        return this.snpRawInfoBeforeAnnotateInVcf;
    }

    public void setSNPRawInfoBeforeAnnotate(String rawInfo) {
        this.snpRawInfoBeforeAnnotateInVcf = rawInfo;
    }

    public void setAnnotationFieldInfo(String info) {
        this.annotationFieldInfo = info;
    }

    public String getAnnotationFieldInfo() {
        return this.annotationFieldInfo;
    }

    public boolean isInWindow() {
        return this.inWindow;
    }

    public void setInWindow() {
        this.inWindow = true;
    }

    private void setDepth(String dp) {
        this.depth = dp;
    }

    public String getDepth() {
        if (this.depth == null || this.depth.equals("0")) {
            return " ";
        }
        return this.depth;
    }

    private void setQuality(String qual) {
        this.quality = qual;
    }

    public String getSNPQuality() {
        return this.quality;
    }

    protected abstract String getGTInformation(String var1);

    public String getAnnotationInfo() {
        TreeSet<String> tree = new TreeSet<String>();
        String info = new String();
        for (SNPAnnotation annotation : this.snpAnnotations) {
            if (annotation.getEffect() == null) continue;
            tree.add(annotation.getEffect() + annotation.getCodonChangeInfo());
        }
        for (String effect : tree) {
            info = info + ',' + effect;
        }
        if (info.isEmpty()) {
            return "";
        }
        info = info.substring(1, info.length());
        return info;
    }

    public boolean isIndel() {
        return this.ref.length() != this.alt.length();
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void clearAnnotationFieldInfo() {
        this.annotationFieldInfo = null;
    }

    public void clearRawSNPInfoBeforeAnnotate() {
        this.snpRawInfoBeforeAnnotateInVcf = null;
    }
}

