//
//  ViewController.m
//  Chapter2-1
//
//  Created by TangQiao on 5/2/14.
//  Copyright (c) 2014 TangQiao. All rights reserved.
//

#import "ViewController.h"
#import <objc/runtime.h>

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // 创建一个名为 TangQiaoCustomView 的类，它是UIView的子类
    Class newClass = objc_allocateClassPair([UIView class], "TangQiaoCustomView", 0);
    // 为该类增加一个名为 report 的方法
    class_addMethod(newClass, @selector(report), (IMP)ReportFunction, "v@:");
    // 注册该类
    objc_registerClassPair(newClass);
    
    // 创建一个 TangQiaoCustomView类的实例
    id instanceOfNewClass = [[newClass alloc] init];
    // 调用 report 方法
    [instanceOfNewClass performSelector:@selector(report)];
}

void ReportFunction(id self, SEL _cmd)
{
    NSLog(@"This object is %p.", self);
    NSLog(@"Class is %@, and super is %@.", [self class], [self superclass]);
    
    Class currentClass = [self class];
    for (int i = 1; i < 5; i++)
    {
        NSLog(@"Following the isa pointer %d times gives %p", i, currentClass);
        currentClass = object_getClass(currentClass);
    }
    
    NSLog(@"NSObject's class is %p", [NSObject class]);
    NSLog(@"NSObject's meta class is %p", object_getClass([NSObject class]));
}

@end
