#!/usr/bin/python
# -*- coding: utf-8 -*-

# *  Copyright (C) 2016 TDW

import xbmc, xbmcgui, xbmcplugin, xbmcaddon, os, urllib, urllib2, time, codecs, httplib, uscode
import themoviedb
import settings

PLUGIN_NAME   = 'tvfeed'
siteUrl = 'tvfeed.in'
httpSiteUrl = 'https://' + siteUrl
handle = int(sys.argv[1])
addon = xbmcaddon.Addon(id='plugin.video.tvshow.tdw')
__settings__ = xbmcaddon.Addon(id='plugin.video.tvshow.tdw')
xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')# movies

icon  = os.path.join( addon.getAddonInfo('path'), 'icon.png')

dbDir = addon.getAddonInfo('path')
LstDir = addon.getAddonInfo('path')

L_studio=['LostFilm', 'iTunes', 'Amedia', 'Пифагор', 'Кубик в кубе', 'Jaskier', 'NewStudio', 'IdeaFilm', 'Gears Media', 'AlexFilm', 'HDRezka', 'TVShows', 'OMSKBIRD', 'Good People', 'Profix Media', 'Mallorn Studio', 'Lucky Production', 'HELLYWOOD', 'Generalfilm', 'New-Team', 'TUMBLER Studio', 'Novamedia', 'Baibako', 'Sunshine', 'ColdFilm', 'Kerob', 'Octopus', 'AniDub', 'AniLibria', 'AniMedia', 'SHIZA project', 'KANSAI', 'AniFilm', 'AniPlague', 'Hamsterstudio', 'ViruseProject', 'VGM Studio']

def CRC32(buf):
		import binascii
		try:buf = (binascii.crc32(buf) & 0xFFFFFFFF)
		except:
			buf=repr(buf)
			buf = (binascii.crc32(buf) & 0xFFFFFFFF)
		return str("%08X" % buf)

Lthread=[]
LtID=''
def update_Lt(d, id):
	global Lthread, LtID
	if d == 'reset':
		Lthread=[]
		LtID = id
	elif LtID == id:
		Lthread.append(d)

from threading import Thread
class MyThread(Thread):
	def __init__(self, param):
		Thread.__init__(self)
		self.param = param
	
	def run(self):
		i=self.param['i']
		try:
			exec ("import "+i[:-3]+"; skp="+i[:-3]+".Tracker()")
			L = skp.Search(self.param['info'])
		except: 
			L=[]
		update_Lt(L, self.param['id'])

def create_thread(param):
		my_thread = MyThread(param)
		my_thread.start()


def add_ch(info, Lt):
	deb_print('=== add_ch ===')
	SID = 'lst'+str(CRC32(info['originaltitle']))
	try:
		D=eval(settings.get(SID))
		L=D['list']
	except:
		D={}
		L=[]
	upd=False
	for i in Lt:
		if i not in L: 
			L.append(i)#{'item': i, 'tm': time.time()}
			upd=True
	if upd:
		D['list'] = L
		D['tm']=time.time()
		settings.set(SID, repr(D))


def get_ch(info):
	SID = 'lst'+str(CRC32(info['originaltitle']))
	try:
		D  = eval(settings.get(SID))
		L  = D['list']
		tm = D['tm']
	except:
		D={}
		L=[]
		tm=0
	return {'tm':tm, 'list':L}

#======================== стандартные функции ==========================
def fs_enc(path):
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	return path.decode('utf-8').encode(sys_enc)

def fs_dec(path):
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	return path.decode(sys_enc).encode('utf-8')

def fs(s):return s.decode('windows-1251').encode('utf-8')
def win(s):return s.decode('utf-8').encode('windows-1251')
def ru(x):return unicode(x,'utf8', 'ignore')
def xt(x):return xbmc.translatePath(x)
def rt(x):#('&#39;','’'), ('&#145;','‘')
	L=[('&amp;',"&"),('&#133;','…'),('&#38;','&'),('&#34;','"'), ('&#39;','"'), ('&#145;','"'), ('&#146;','"'), ('&#147;','“'), ('&#148;','”'), ('&#149;','•'), ('&#150;','–'), ('&#151;','—'), ('&#152;','?'), ('&#153;','™'), ('&#154;','s'), ('&#155;','›'), ('&#156;','?'), ('&#157;',''), ('&#158;','z'), ('&#159;','Y'), ('&#160;',''), ('&#161;','?'), ('&#162;','?'), ('&#163;','?'), ('&#164;','¤'), ('&#165;','?'), ('&#166;','¦'), ('&#167;','§'), ('&#168;','?'), ('&#169;','©'), ('&#170;','?'), ('&#171;','«'), ('&#172;','¬'), ('&#173;',''), ('&#174;','®'), ('&#175;','?'), ('&#176;','°'), ('&#177;','±'), ('&#178;','?'), ('&#179;','?'), ('&#180;','?'), ('&#181;','µ'), ('&#182;','¶'), ('&#183;','·'), ('&#184;','?'), ('&#185;','?'), ('&#186;','?'), ('&#187;','»'), ('&#188;','?'), ('&#189;','?'), ('&#190;','?'), ('&#191;','?'), ('&#192;','A'), ('&#193;','A'), ('&#194;','A'), ('&#195;','A'), ('&#196;','A'), ('&#197;','A'), ('&#198;','?'), ('&#199;','C'), ('&#200;','E'), ('&#201;','E'), ('&#202;','E'), ('&#203;','E'), ('&#204;','I'), ('&#205;','I'), ('&#206;','I'), ('&#207;','I'), ('&#208;','?'), ('&#209;','N'), ('&#210;','O'), ('&#211;','O'), ('&#212;','O'), ('&#213;','O'), ('&#214;','O'), ('&#215;','?'), ('&#216;','O'), ('&#217;','U'), ('&#218;','U'), ('&#219;','U'), ('&#220;','U'), ('&#221;','Y'), ('&#222;','?'), ('&#223;','?'), ('&#224;','a'), ('&#225;','a'), ('&#226;','a'), ('&#227;','a'), ('&#228;','a'), ('&#229;','a'), ('&#230;','?'), ('&#231;','c'), ('&#232;','e'), ('&#233;','e'), ('&#234;','e'), ('&#235;','e'), ('&#236;','i'), ('&#237;','i'), ('&#238;','i'), ('&#239;','i'), ('&#240;','?'), ('&#241;','n'), ('&#242;','o'), ('&#243;','o'), ('&#244;','o'), ('&#245;','o'), ('&#246;','o'), ('&#247;','?'), ('&#248;','o'), ('&#249;','u'), ('&#250;','u'), ('&#251;','u'), ('&#252;','u'), ('&#253;','y'), ('&#254;','?'), ('&#255;','y'), ('&laquo;','"'), ('&raquo;','"'), ('&nbsp;',' ')]
	for i in L:
		try:x=x.replace(i[0], i[1])
		except: pass
	try: x=uscode.decode(x)
	except: pass
	return x

def lower_old(s):
	try:s=s.decode('utf-8')
	except: pass
	#try:s=s.decode('windows-1251')
	#except: pass
	try:s=s.lower()
	except: pass
	try:s=s.encode('utf-8')
	except: pass
	return s

def lower(t):
	t=t.lower()
	RUS={"А":"а", "Б":"б", "В":"в", "Г":"г", "Д":"д", "Е":"е", "Ё":"ё", "Ж":"ж", "З":"з", "И":"и", "Й":"й", "К":"к", "Л":"л", "М":"м", "Н":"н", "О":"о", "П":"п", "Р":"р", "С":"с", "Т":"т", "У":"у", "Ф":"ф", "Х":"х", "Ц":"ц", "Ч":"ч", "Ш":"ш", "Щ":"щ", "Ъ":"ъ", "Ы":"ы", "Ь":"ь", "Э":"э", "Ю":"ю", "Я":"я"}
	for i in range (65,90):
		t=t.replace(chr(i),chr(i+32))
	for i in RUS.keys():
		t=t.replace(i,RUS[i])
	return t

def mid(s, n):
	try:s=s.decode('utf-8')
	except: pass
	try:s=s.decode('windows-1251')
	except: pass
	s=s.center(n)
	try:s=s.encode('utf-8')
	except: pass
	return s

def mids(s, n):
	l="                                              "
	s=l[:n-len(s)]+s+l[:n-len(s)]
	return s

def FC(s, color="FFFFFF00"):
	s="[COLOR "+color+"]"+s+"[/COLOR]"
	return s

def mfindal(http, ss, es):
	L=[]
	while http.find(es)>0:
		s=http.find(ss)
		e=http.find(es)
		i=http[s:e]
		L.append(i)
		http=http[e+2:]
	return L

def mfind(t,s,e):
	r=t[t.find(s)+len(s):]
	r2=r[:r.find(e)]
	return r2

def debug(s):
	fl = open(ru(os.path.join( addon.getAddonInfo('path'),"test.txt")), "wb")
	fl.write(s)
	fl.close()

def deb_print(s):
	if __settings__.getSetting("DebMod")=='true': print s

def inputbox():
	skbd = xbmc.Keyboard()
	skbd.setHeading('Поиск:')
	skbd.doModal()
	if skbd.isConfirmed():
		SearchStr = skbd.getText()
		return SearchStr
	else:
		return ""

def showMessage(heading, message, times = 3000):
	xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")'%(heading, message, times, icon))

#============================== основная часть ============================

def GET(url,Referer = 'https://tvfeed.in', XML = False):
	print url
	try:
		req = urllib2.Request(url)
		req.add_header('User-Agent', 'KODI')#'Opera/10.60 (X11; openSUSE 11.3/Linux i686; U; ru) Presto/2.6.30 Version/10.60'
		req.add_header('Accept', '*/*')
		req.add_header('Accept-Language', 'ru,en;q=0.9')
		req.add_header('Referer', Referer)
		if XML: req.add_header('X-Requested-With', 'XMLHttpRequest')
		response = urllib2.urlopen(req)
		link=response.read()
		response.close()
		return link
	except:
		print 'ERR: недоступно'
		return ''


def get_params(params=''):
	param=[]
	if params=='': params=sys.argv[2]
	if len(params)>=2:
		print params
		cleanedparams=params.replace('?','')
		if (params[len(params)-1]=='/'):
			params=params[0:len(params)-2]
		pairsofparams=cleanedparams.split('&')
		param={}
		for i in range(len(pairsofparams)):
			splitparams={}
			splitparams=pairsofparams[i].split('=')
			if (len(splitparams))==2:
				param[splitparams[0]]=splitparams[1]
	return param



import sqlite3 as db
db_name = os.path.join( dbDir, "info.db" )
c = db.connect(database=db_name)
cu = c.cursor()
def add_to_db(n, item):
		deb_print ('KP add_to_db '+n)
		item=item.replace("'","XXCC").replace('"',"XXDD")
		err=0
		tor_id="n"+n.replace('-','')
		print tor_id
		litm=str(len(item))
		try:
			cu.execute("CREATE TABLE "+tor_id+" (db_item VARCHAR("+litm+"), i VARCHAR(1));")
			c.commit()
			deb_print ('KP add_to_db CREATE TABLE '+tor_id)
		except: 
			err=1
			print "Ошибка БД"+ n
		if err==0:
			cu.execute('INSERT INTO '+tor_id+' (db_item, i) VALUES ("'+item+'", "1");')
			c.commit()
			deb_print ('KP add_to_db INSERT INTO '+tor_id)
			#c.close()

def get_inf_db(n):
		deb_print ('KP get_inf_db '+n)
		tor_id="n"+n.replace('-','')
		cu.execute(str('SELECT db_item FROM '+tor_id+';'))
		c.commit()
		deb_print ('KP get_inf_db SELECT '+tor_id)
		Linfo = cu.fetchall()
		info=Linfo[0][0].replace("XXCC","'").replace("XXDD",'"')
		deb_print ('KP get_inf_db return_info OK')
		return info

def rem_inf_db(n):
		deb_print ('KP rem_inf_db '+n)
		tor_id="n"+n.replace('-','')
		try:
			cu.execute("DROP TABLE "+tor_id+";")
			c.commit()
			deb_print ('KP rem_inf_db DROP TABLE '+n)
		except: pass


def update_info(id):
	rem_inf_db(id)
	xbmc.executebuiltin('Container.Refresh')


def get_labels(info):
	Linf=['genre', 'year', 'rating', 'cast', 'director', 'plot', 'title', 'originaltitle', 'studio']
	Labels={}
	for inf in Linf:
		try:Labels[inf] = info[inf]
		except: pass
	try:Labels['duration'] = str(int(info['duration'])*60)
	except: pass
	return Labels


def AddItem(Title = "", mode = "", id='0', info={}, total=100, icon=icon):
			if info!={}:
				try:    cover = 'https://image.tmdb.org/t/p/w300'+info["cover"]
				except: cover = icon
				try:    fanart = 'https://image.tmdb.org/t/p/w1280'+info["fanart"]
				except: fanart = cover
			else:
				cover = icon
				fanart = icon
				info={'id':id}
			
			if mode=="OpenTorrent" and __settings__.getSetting("DebMod")=='true':
					if 'magnet:' in id: cover = os.path.join( addon.getAddonInfo('path'), 'U.png')
					else:				cover = os.path.join( addon.getAddonInfo('path'), 'T.png')
			
			listitem = xbmcgui.ListItem(Title, iconImage=cover, thumbnailImage=cover)
			listitem.setInfo(type = "Video", infoLabels = get_labels(info))
			try: listitem.setArt({ 'poster': cover, 'fanart' : fanart, 'thumb': cover, 'icon': cover})
			except: pass
			listitem.setProperty('fanart_image', fanart)
			
			purl = sys.argv[0] + '?mode='+mode+'&id='+str(id)+'&info='+repr(info)
			
			if mode=="OpenTorrent":
				infoLabels = get_labels(info)
				infoLabels["cover"]=cover
				infoLabels["fanart"]=fanart
				le=['','ace', 't2http', 'yatp', 'torrenter', 'elementum', 'xbmctorrent', 'ace_proxy', 'quasar', 'torrserver']
				tengine = le[int(__settings__.getSetting("TAMengine"))]
				purl='plugin://plugin.video.tam/?mode=open&url='+urllib.quote_plus(id)+ '&info='+urllib.quote_plus(repr(infoLabels))+ '&engine='+tengine#+ '&purl='+urllib.quote_plus(pu)
				sign = info['sign']
				season=info['season']
				sid=info['id']
				listitem.addContextMenuItems([('[B]Предпочитать[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=SET&id='+str(sid)+ '&sign='+str(sign)+ '&season='+str(season)+'")'),])
			if mode=="Episodes" or mode=="Episodes2":
				try:Fav=eval(__settings__.getSetting("Favorites"))
				except: Fav=[]
				if id in Fav:	listitem.addContextMenuItems([
					('[B]Сохранить сериал[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Save&id='+str(id)+'")'),
					('[B]Отслеживать в ТС[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=TC2&id='+str(id)+'")'),
					('[B]Похожие[/B]',          'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Similar&id='+str(id)+'")'),
					('[B]Персоны[/B]',          'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Persons&id='+str(id)+'")'),
					('[B]Удалить из избранного[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=REM&id='+str(id)+'")')
					])
				else: 			listitem.addContextMenuItems([
					('[B]Сохранить сериал[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Save&id='+str(id)+'")'),
					('[B]Отслеживать в ТС[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=TC2&id='+str(id)+'")'),
					('[B]Похожие[/B]',          'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Similar&id='+str(id)+'")'),
					('[B]Персоны[/B]',          'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Persons&id='+str(id)+'")'),
					('[B]В избранное[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=ADD&id='+str(id)+'")')
					])
			if mode=="Serials":
				listitem.addContextMenuItems([('[B]Обновить список сериалов[/B]', 'Container.Update("plugin://plugin.video.tvfeed/?mode=Update")')])
			if mode=="Play":
				listitem.setProperty('IsPlayable', 'true')
				#purl = sys.argv[0] + '?mode=Autoplay&id='+id
				xbmcplugin.addDirectoryItem(handle, purl, listitem, False, total)
			else:
				xbmcplugin.addDirectoryItem(handle, purl, listitem, True, total)

def AddEpisode(Title = "", mode = "", SID='', info={}, total=100):
			id=info['id']
			ep=info['episode']
			try:    cover =  'https://image.tmdb.org/t/p/w300'+info["cover"]
			except: cover =  ''
			try:    fanart = 'https://image.tmdb.org/t/p/w300'+info["thumb"]
			except: fanart = icon
			
			if cover == '' : cover=fanart
			
			listitem = xbmcgui.ListItem(Title, iconImage=cover, thumbnailImage=cover)
			listitem.setInfo(type = "Video", infoLabels = info)
			try: listitem.setArt({ 'poster': cover, 'fanart' : cover, 'thumb': cover, 'icon': cover})
			except: pass
			listitem.setProperty('fanart_image', fanart)
			purl = sys.argv[0] + '?mode='+mode+'&id='+str(SID)+'&ind='+str(ep)+'&info='+repr(info)
			#if url !="": purl = purl +'&url='+str(SID)
			
			try:type=info["type"]
			except:type=''
			#if __settings__.getSetting("Autoplay")=='true': 
			listitem.setProperty('IsPlayable', 'true')
			listitem.addContextMenuItems([('[B]Выбрать качество[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Season&id='+str(SID)+'&info='+repr(info)+'")'),('[B]Найти эпизод[/B]', 'Container.Update("plugin://plugin.video.tvshow.tdw/?mode=Ep_list&id='+str(SID)+'&ind='+str(ep)+'&info='+repr(info)+'")')])
			xbmcplugin.addDirectoryItem(handle, purl, listitem, False, total)
			#else:
			#		purl = sys.argv[0] + '?mode=Season&id='+str(SID)+'&info='+repr(info)
			#		xbmcplugin.addDirectoryItem(handle, purl, listitem, True, total)

def get_info(ID):
	ID=str(ID)
	try:
			info=eval(xt(get_inf_db(ID)))
			deb_print ('KP get_info ОК')
			return info
	except:
			try:
				info = themoviedb.get_info(ID)
				deb_print(info)
			except: 
				return {"title": ID, "originaltitle":ID, "rating":0, "cover":icon, "type":'', "id":ID}
			try:
				deb_print("ADD: " + ID)
				add_to_db(ID, repr(info))
			except:
				deb_print ("ERR: " + ID)
			deb_print ('return info')
			return info

def mont2num(dt):
	L1=[' января ',' февраля ',' марта ',' апреля ',' мая ',' июня ',' июля ',' августа ',' сентября ',' октября ',' ноября ',' декабря ']
	L2=['.01.','.02.','.03.','.04.','.05.','.06.','.07.','.08.','.09.','.10.','.11.','.12.']
	for i in range (0,12):
		dt=dt.replace(L1[i], L2[i])
	return dt

#=============================  Menu  ==============================
def Root():
	AddItem("Поиск", "Search")
	#AddItem("Все сериалы", "Serials")
	AddItem("Лучшие", "Top")
	AddItem("Популярные", "Popular")
	AddItem("Новинки", "New")
	AddItem("Жанры", "Genres")
	#AddItem("Язык", "Countrys")
	AddItem("Год", "Years")
	AddItem("В эфире", "On_air")
	AddItem("Подборки", "Collection")
	AddItem("Избранное", "Favorites")
	
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

def Search():
	q=inputbox()
	if q=='': return
	L=themoviedb.search(q)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Serials():
	L=eval(get_inf_db('tvfeed'))
	n=0
	for id in L:
		n+=1
		#if n>30: return
		info=get_info(id)
		AddItem(info['title'], "Episodes", id, '', len(L))

def Similar(id):
	L=themoviedb.similar(id)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Genres():
	L=themoviedb.get_genre_list()
	for info in L:
		#print info
		AddItem(lower(info['name']), "Genre", info['id'], {}, len(L))

def Genre(gid):
	L=themoviedb.get_genre(gid)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Collection():
	L=themoviedb.collection_list()
	for info in L:
		print info
		AddItem(info['title'], "Collect", info['id'])

def Collect(cid):
	L=themoviedb.collection(cid)
	for info in L:
		#if not (info['plot']=='' and info['title']==info['originaltitle']):
			id = info['id']
			AddItem(info['title'], "Episodes", id, info, len(L))

def On_air():
	L=themoviedb.on_the_air()
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def New():
	L=themoviedb.new()
	for info in L:
		if not (info['plot']=='' and info['title']==info['originaltitle']):
			id = info['id']
			AddItem(info['title'], "Episodes", id, info, len(L))

def Top():
	L=themoviedb.top()
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Popular():
	L=themoviedb.popular()
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Years():
	L=range(1980, 2022)
	L.reverse()
	for i in L:
		AddItem(str(i), "Year", i)

def Year(y):
	L=themoviedb.year(y)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Country(c):
	L=themoviedb.country(c)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))

def Countrys():
	L=[['Английский', 'en'],['Французский', 'fr'],['Немецкий', 'de'],['Итальянский', 'it'],['Японский', 'ja'],['Португальский', 'pt'],['Русский', 'ru'],['Испанский', 'es'],['Шведский', 'sv']]
	for i in L:
		AddItem(i[0], "Country", i[1])

def Persons(id):
	L=themoviedb.person_list(id)
	for i in L:
		AddItem(i['title'], "Person", i['id'], i)

def Person(id):
	L=themoviedb.person(id)
	for info in L:
		id = info['id']
		AddItem(info['title'], "Episodes", id, info, len(L))


def Episodes(id, ret=False):
	Ls=themoviedb.seasons(id)
	Lr=[]
	for s_info in Ls:
		season=s_info['season']
		if season > 0:
			if ret==False: AddItem('[COLOR FF22FF22] '+str(season)+' сезон[/COLOR]', "Season", id, s_info, len(Ls))
			else: Lr.append(s_info)
			Le=themoviedb.episodes(id, season)
			for info in Le:
					deb_print(info)
					title=str(info['season'])+'x'+str(info['episode'])+"  "+info['title']
					try:
						premiered = int(info['premiered'].replace('-',''))
						crdate = int(time.strftime('%Y%m%d'))
						if premiered>crdate: title = '[COLOR AA606060]'+title+'[/COLOR]'
					except: pass
					
					if ret==False: AddEpisode(title, "Play", id, info, len(Le))
	return Lr

def Episodes2(id, s):
	Ls=themoviedb.seasons(id)
	Lr=[]
	for s_info in Ls:
		season=s_info['season']
		if season == s:
			Le=themoviedb.episodes(id, season)
			for info in Le:
					deb_print(info)
					title=str(info['season'])+'x'+str(info['episode'])+"  "+info['title']
					try:
						premiered = int(info['premiered'].replace('-',''))
						crdate = int(time.strftime('%Y%m%d'))
						if premiered>crdate: title = '[COLOR FFFF2020]'+title+'[/COLOR]'
					except: pass
					
					AddEpisode(title, "Play", id, info, len(Le))

def Seasons(id):
	Ls=themoviedb.seasons(id)
	if len(Ls)==1: return Episodes(id)
	if len(Ls)==2: 
		if Ls[0]['season']==0: return Episodes(id)
	Lr=[]
	for s_info in Ls:
		season=s_info['season']
		if season > 0:
			AddItem('[COLOR FF22FF22] '+str(season)+' сезон[/COLOR]', "Episodes2", id, s_info, len(Ls))



def Season(id, info, additm=True):
	season=info['season']
	inf=themoviedb.get_info(id)
	sel=get_select(id, season)
	L=find_season(id, season)
	L2=[]
	
	for n in range(7):
		if 0<n<5:
			n_std = int(__settings__.getSetting('Studio'+str(n)))
			studio=L_studio[n_std]
		else:
			studio=''
		
		for i in L:
			sign = get_sign(i)
			enable=False
			i_std=i['studio']
			if studio=='':
				if n==0:
					if sign == sel:	enable=True
					else: 			enable=False
				elif n==5:
					if i_std!='': 	enable=True
					else: 			enable=False
				else:				enable=True
			else:
				if i_std=='': i_std='?'
				if i_std == studio: enable=True
			
			if enable:
				if __settings__.getSetting("DebMod")=='true': 
					#if '0' not in i['quality']: q2 = get_label2(i['url'])
					#else: q2=''
					title=sign + i['quality']+" "+mid(i['size'],10)+" "+i['season']+" "+i['studio']+" [COLOR FFC0C0C0]"+rt(i['title'])+"[/COLOR]"
				else: 
					title=i['quality']+" "+mids(i['season'], 8)+" "+mid(i['size'],10)+" "+mids(i['sids'], 6)+" "+i['studio']+" | "+rt(i['title'])
				if n==0: title='[COLOR EFFF7711]'+title+'[/COLOR]'
				if 0<n<5:title='[COLOR EF22FF22]'+title+'[/COLOR]'
				if i not in L2:
					inf['sign'] = sign
					inf['season']= season
					inf['id']= id
					if additm: AddItem(title, "OpenTorrent", i['url'], inf)
					L2.append(i)
	return L2


#===================================================================

def Play(id, info):
	
	pDialog = xbmcgui.DialogProgressBG()
	
	print '===PLAY==='
	s=info['season']
	sz=str(s)
	if len (sz)<2: sz='0'+sz
	print sz
	
	e=info['episode']
	ep=str(e)
	if len (ep)<2: ep='0'+ep
	print ep
	
	
	lpu=get_last_played(id, s)
	if lpu!='': 
		stream = find_stream(lpu, sz, e)
		url=lpu
		tor_title = ''
	else: stream = ''
	
	
	try:pDialog.create('S'+sz+'E'+ep, 'Поиск серии ...')
	except: pass
	
	if stream == '':
		L=Season(id, info, False)
		n=0
		L3=[]
		L4=[]
		for t in L:
			n+=1
			url=t['url']
			pDialog.update(n*100/len(L), message=url.replace('http://127.0.0.1:8095/proxy/',''))
			tor_title=t['studio']+" | "+rt(t['title'])
			
			L2 = get_torrent_directory(url)
			if len(L2) >= e and '-' not in t['season']: L3.append(url)
			deb_print ('==== s'+sz+'e'+ep+' ====')
			for i in L2:
				L4.append(i)
				deb_print (i['label'].lower())
				#pDialog.update(n*100/len(L), message=i['label'])
				if 's'+sz in i['label'].lower() or 's'+str(s)+'e' in i['label'].lower():
					if find_episode(e, i['label']):
						stream = i['file']
						sign = get_sign(t)
						if get_select(id, s) !=sign: set_select(id, s, sign)
						if get_last_played(id, s) !=sign: set_last_played(id, s, url)
						deb_print (stream)
						deb_print ('==============')
					if stream !='': break
			
			if stream !='': break
	
	if stream =='' and s==1:
		for i in L4:
				if find_episode(e, i['label']): stream = i['file']
				if stream !='': break
	
	
	if stream =='' and __settings__.getSetting("index") == 'true' and L3!=[]:
		url = L3[0]
		L2 = get_torrent_directory(url)
		stream = L2[e-1]['file']
	
	
	print 'STREAM:'+stream
	pDialog.update(100, message=stream)
	pDialog.close()
	if stream =='': return
	
	tam_history(url, get_info(id))# в историю
	
	item = xbmcgui.ListItem(path=stream)
	xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
	
	if __settings__.getSetting("NoAD")=='true':
		deb_print('==NoAD=1=')
		ADL=__settings__.getSetting("ADList").split(',')
		AD=False
		deb_print(tor_title)
		for ad in ADL:
			deb_print(ad)
			if ad.strip() in tor_title: AD=True
		if AD == False: return
		
		deb_print('==NoAD=2=')
		Player=xbmc.Player()
		for t in range(25):
			deb_print('==NoAD== '+str(t))
			xbmc.sleep(1000)
			if xbmc.Player().isPlaying():
				deb_print('==NoAD isPlaying==')
				break
		
		deb_print('==NoAD PlFile==')
		for t in range(25):
			xbmc.sleep(1000)
			try: PlFile=Player.getPlayingFile()
			except: PlFile=''
			try: PlTime=Player.getTime()
			except: PlTime=0
			deb_print('PlFile '+PlFile)
			if PlFile!='' and PlTime>0:
				xbmc.sleep(1000)
				deb_print('==NoAD seekTime==')
				Player.seekTime(35)
				break


def find_stream(url, sz, e):
		stream = ''
		L2 = get_torrent_directory(url)
		for i in L2:
			if 's'+sz in i['label'].lower() or 's'+str(s)+'e' in i['label'].lower():
				if find_episode(e, i['label']):
					stream = i['file']
				if stream !='': break
		return stream

def Ep_list(id, info):
	pDialog = xbmcgui.DialogProgressBG()
	
	print '===Ep_list==='
	s=info['season']
	sz=str(s)
	if len (sz)<2: sz='0'+sz
	print sz
	
	e=info['episode']
	ep=str(e)
	if len (ep)<2: ep='0'+ep
	print ep
	
	try:pDialog.create('S'+sz+'E'+ep, 'Поиск серии ...')
	except: pass
	
	stream = ''
	L=Season(id, info, False)
	n=0
	deb_print ('==== s'+sz+'e'+ep+' ====')
	for t in L:
		n+=1
		url=t['url']
		tor_title=t['studio']+" | "+rt(t['title'])
		pDialog.update(n*100/len(L), message=url.replace('http://127.0.0.1:8095/proxy/',''))
		L2 = get_torrent_directory(url)
		for i in L2:
			if 's'+sz in i['label'].lower() or s==1:
				if find_episode(e, i['label']):
					stream = i['file']
					deb_print (i['label'].lower())
					item = xbmcgui.ListItem(i['label'])
					item.setInfo(type = "Video", infoLabels = {'title':i['label']})
					item.setProperty('IsPlayable', 'true')
					xbmcplugin.addDirectoryItem(handle, stream, item, False)
					if stream !='': break
		deb_print ('==============')
	
	print 'STREAM:'+stream
	pDialog.update(100, message=stream)
	pDialog.close()

def Play_tam(stream):
	item = xbmcgui.ListItem(path=stream)
	xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)


def find_episode(e, t):
	ep=str(e)
	if len (ep)<2: ep='0'+ep
	if 'e'+ep in t.lower():  return True
	if 'e.'+ep in t.lower(): return True
	
	if 'e.'+str(e)+' ' in t.lower(): return True
	if 'e'+str(e)+' '  in t.lower(): return True
	if 'e.'+str(e)+'.' in t.lower(): return True
	if 'e'+str(e)+'.'  in t.lower(): return True
	
	tmp=t.lower().replace('.',' ').replace('_',' ').replace('/',' ')
	for s in range(10):
		tmp=tmp.replace('s0'+str(s),' ')
	for s in range(10,99):
		tmp=tmp.replace('s'+str(s),' ')
	if ' '+ep+' ' in tmp: return True
	
	return False

def Save(id):
	info = get_info(id)
	info['cover'] = 'https://image.tmdb.org/t/p/w300'+info['cover']
	info['fanart'] = 'https://image.tmdb.org/t/p/w1280'+info['fanart']
	sel = xbmcgui.Dialog()
	Lu=Episodes(id, True)
	Lt=[]
	for i in Lu:
		Lt.append(str(i['season'])+' сезон')
	rs = sel.select("Сезон:", Lt)
	if rs<0: return
	
	s_info=Lu[rs]
	print s_info
	
	season=s_info['season']
	Lt=[]
	Lu=[]
	L=find_season(id, season)
	for i2 in L:
		title=i2['quality']+" "+i2['season']+" "+i2['studio']
		img=''
		Lt.append(title)
		Lu.append(i2['url'])
		
	r = sel.select("Релизы:", Lt)
	if r>-1:
		url=Lu[r]
		#uri='plugin://plugin.video.torrent.checker/?mode=save_episodes_api&url='+urllib.quote_plus(url)+'&name='+urllib.quote_plus(info['originaltitle'])+ '&info=' + urllib.quote_plus(repr(info))
		pu = sys.argv[0] + '?mode=Episodes&id='+str(id)+'&info='+repr(info)
		uri='plugin://plugin.video.tam/?mode=save_series&url='+urllib.quote_plus(url)+'&name='+urllib.quote_plus(info['originaltitle'])+ '&info=' + urllib.quote_plus(repr(info))+'&purl='+urllib.quote_plus(pu)
		xbmc.executebuiltin('RunPlugin("'+uri+'")')

def TC2(id):
	info = get_info(id)
	info['cover'] = 'https://image.tmdb.org/t/p/w300'+info['cover']
	info['fanart'] = 'https://image.tmdb.org/t/p/w1280'+info['fanart']
	sel = xbmcgui.Dialog()
	Lu=Episodes(id, True)
	s_info=Lu[-1]
	print s_info
	season=s_info['season']
	sel_sign=get_select(id, season)
	
	Lt=[]
	Lu=[]
	L=find_season(id, season)
	for i2 in L:
		sign=get_sign(i2)
		title=i2['quality']+" "+i2['season']+" "+i2['studio']+" "+i2['size']
		if sign==sel_sign: title='[COLOR EFFF7711]'+title+'[/COLOR]'
		Lt.append(title)
		Lu.append(i2)
		
	r = sel.select("Релизы:", Lt)
	if r>-1:
		t_info=Lu[r]
		sign=get_sign(t_info)
		tvs_name = info['originaltitle']
		tvf_url = 'plugin://plugin.video.tvshow.tdw/?mode=TC&id='+str(id)+'&sign='+str(sign)+'&season='+str(season)+'&name='+urllib.quote_plus(tvs_name)
		uri='plugin://plugin.video.torrent.checker/?mode=add&url='+urllib.quote_plus(tvf_url)+'&name='+urllib.quote_plus(tvs_name)+'&manual=0'
		xbmc.executebuiltin('RunPlugin("'+uri+'")')

def TC(id, sign, season, name):
	sz=str(season)
	if len (sz)<2: sz='0'+sz
	print sz
	sys.path.append(os.path.join(xbmc.translatePath("special://home/"),"addons","plugin.video.torrent.checker"))
	import updatetc
	LD=updatetc.file_list(name)
	L=find_season(id, season)
	L2=[]
	for t_info in L:
		n_sign=get_sign(t_info)
		if n_sign==sign: 
			L2.append(t_info)
	
	for t in L2:
		url = t['url']
		L3 = get_torrent_directory(url)
		for i in L3:
			stream = i['file']
			#print stream
			#print get_params(stream)
			#nm = i['label'].lower()+'.strm'
			for e in range(99):
				ep=str(e)
				if len (ep)<2: ep='0'+ep
				if find_episode(e, i['label']):
					nm = name+'.s'+sz+'e'+ep+'.strm'
					uri = urllib.unquote_plus(get_params(stream)["url"])
					ind = int(get_params(stream)["ind"])
					if nm not in LD: updatetc.save_strm(name, nm, uri, ind)
					break


def get_torrent_directory(url, info={'history':False}):
	try:lc = eval(__settings__.getSetting("Lr"))
	except: lc = {'id':0}
	try: lc_id = lc['id']
	except: lc_id = 0
	if lc_id == url and __settings__.getSetting("NoCache")=='false' and info=={'history':False}: 
		print '=Cahe='
		Ldata=lc['data']
		if Ldata!=[]: return Ldata
	
	try:
		info["cover"]  = 'https://image.tmdb.org/t/p/w300' +info["cover"]
		info["fanart"] = 'https://image.tmdb.org/t/p/w1280'+info["fanart"]
	except: pass
	
	Lext=['.avi', '.mkv', '.ts', '.mov', '.mp4', '.mpg', '.mpeg']
	le=['','ace', 't2http', 'yatp', 'torrenter', 'elementum', 'xbmctorrent', 'ace_proxy', 'quasar', 'torrserver', 'torrserver_tam']
	tengine = le[int(__settings__.getSetting("TAMengine"))] 
	purl='plugin://plugin.video.tam/?mode=open&url='+urllib.quote_plus(url)+ '&engine='+tengine+ '&info='+urllib.quote_plus(repr(info))
	response = eval(xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "Files.GetDirectory", "params": {"directory": "'+purl+'"},"id": 1}'))
	#print 'get_torrent_directory'
	try:files=response["result"]["files"]
	except: files=[]
	Lr=[]
	for i in files:
		label=i['label'].lower()
		add = False
		for ext in Lext:
			if ext in label: add=True
		if add: Lr.append(i)
	__settings__.setSetting("Lr", repr({'id':url, 'data':Lr}))
	return Lr

def tam_history(url, info):
	try:    cover = 'https://image.tmdb.org/t/p/w300'+info["cover"]
	except: cover = icon
	try:    fanart = 'https://image.tmdb.org/t/p/w1280'+info["fanart"]
	except: fanart = cover
	info["cover"]=cover
	info["fanart"]=fanart
	purl='plugin://plugin.video.tam/?mode=history&url='+urllib.quote_plus(url)+ '&info='+urllib.quote_plus(repr(info))
	xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "Files.GetDirectory", "params": {"directory": "'+purl+'"},"id": 1}')


def find_season(id, S=1):
	deb_print('==find_season==')
	L=Quality(id, False)
	if L==[]: L=Quality(id, False, True)
	L2=[]
	L.sort()
	for i in L:
		try:
			deb_print('----i---')
			deb_print(i['season'])
			if '-' in i['season']:
				#deb_print(' - in i')
				s1=int(i['season'].split('-')[0])
				s2=int(i['season'].split('-')[1])
				SL=range(s1,s2+1)
			else:
				#deb_print(' - not in i')
				try:    SL = [int(i['season']),]
				except: SL = []
			deb_print(SL)
			if S in SL:
				L2.append(i)
		except:
			deb_print('== ERR i ==')
	
	if len(L2)<5 and S==1:
		for i in L:
			if i['season']=='XX' and '[' in i['title']: L2.append(i)
	
	if L2==[] and S==1: L2=L
	
	return L2


def get_select(id, season):
	id = 'sig'+str(id)
	try: return eval(get_inf_db(id))[str(season)]
	except: return ''

def set_select(id, season, sign):
	id = 'sig'+str(id)
	try: inf = eval(get_inf_db(id))
	except: inf = {}
	inf[str(season)]=sign
	rem_inf_db(id)
	add_to_db(id, repr(inf))

def get_last_played(id, season):
	id = 'lp'+str(id)
	try: return eval(get_inf_db(id))[str(season)]
	except: return ''

def set_last_played(id, season, url):
	id = 'lp'+str(id)
	try: inf = eval(get_inf_db(id))
	except: inf = {}
	inf[str(season)]=url
	rem_inf_db(id)
	add_to_db(id, repr(inf))


def filtr(D):
	try:
		BL=['Трейлер', "Тизер", 'трейлер', "тизер", 'ТРЕЙЛЕР', "ТИЗЕР"]
		if __settings__.getSetting("F_Qual") != "0":BL.extend([' TS','TeleSyn','TeleCin','TELECIN',' CAM',' CamRip','screen','Screen', 'звук из кинотеатра'])
		#if __settings__.getSetting("F_Qual11")== 'false': BL.append("KOSHARA")
		if __settings__.getSetting("BlackList") != "":
			for bli in __settings__.getSetting("BlackList").split(","):
				BL.append(bli.strip())
		WL=[]
		if __settings__.getSetting("F_Qual1") == 'true': WL.append("dvdrip")
		if __settings__.getSetting("F_Qual2") == 'true': WL.append("webrip")
		if __settings__.getSetting("F_Qual3") == 'true': WL.append("web-dl")
		if __settings__.getSetting("F_Qual4") == 'true': WL.append("bdrip")
		if __settings__.getSetting("F_Qual5") == 'true': WL.append("hdrip")
		if __settings__.getSetting("F_Qual6") == 'true': WL.append("tvrip")
		if __settings__.getSetting("F_Qual7") == 'true': WL.append("hdtv")
		if __settings__.getSetting("F_Qual8") == 'true': WL.append("blu-ray")
		if __settings__.getSetting("F_Qual9") == 'true': WL.append("720p")
		if __settings__.getSetting("F_Qual10")== 'true': WL.append("1080p")
		
		if __settings__.getSetting("F_Qual") == '0': WL=[]

		#size1 = int(__settings__.getSetting("F_Size1"))
		#size2 = int(__settings__.getSetting("F_Size2"))
		#if size2 == 0: size2 = 999
		
		b=0
		q=0
		z=0
		Title = D['title']
		try:Title=Title+' '+D['quality']
		except:pass
		
		try:Title=Title.encode('utf-8')
		except: Title=xt(Title)
		
		for i in BL:
			if Title.find(i)>0:b+=1
		
		if b==0:
			for i in BL:
				if lower(Title).find(lower(i))>0:b+=1
		
		
		if __settings__.getSetting("F_Qual") == "0":
			q=1
		else:
			for i in WL:
				if Title.lower().find(i)>0:q+=1
			
		'''
		if 'ГБ' in xt(D['size']) or 'GB' in xt(D['size']):
				szs=xt(D['size']).replace('ГБ','').replace('GB','').replace('|','').strip()
				sz=float(szs)
				if sz>size1 and sz<size2 : z=1
		else: z=0
		'''
		
		print Title
		if b <> 0: print 'Попал в Черный список'
		if q == 0: print 'Низкое Качество'
		#if z == 0: print 'Не тот Размер'
		
		if b == 0 and q > 0 :#and z > 0
			#print 'Файл найден'
			return True
		else: 
			return False
	except:
		return False

def year_in_title(L, t):
	for i in L:
		if str(i) in t: return True
	return False

def Quality(id, additm=True, rus=False):
	try:lc = eval(__settings__.getSetting("LLL"))
	except: lc = {'id':0}
	try: lc_id = lc['id']
	except: lc_id = 0
	if lc_id == id and __settings__.getSetting("NoCache")=='false': 
		print '=Cahe='
		Ldata=lc['data']
		if Ldata!=[]: return Ldata
	info=themoviedb.get_info(id)
	if __settings__.getSetting("SYear")=='true': years = themoviedb.get_years(id)
	else: years = []
	
	L2=[]
	Lz=[]
	
	if rus: 
		if info['originaltitle']==info['title']: return []
		info['originaltitle']=info['title']
	L = sercher(info)
	for D in L:
		if filtr(D):
			print '------ item -------'
			url = D['url']
			deb_print(url)
			if 'http' in url or 'magnet' in url:
				try:    title=utt(D['title'].encode('utf-8'))
				except: title=utt(D['title'])
				ru_title=utt(xt(info['title']))
				en_title=utt(info['originaltitle'])
				tor_title=utt(title).replace('('+en_title+')', ' '+en_title+' ')
				
				deb_print (lower(tor_title))
				deb_print (lower(ru_title))
				deb_print (lower(en_title))
				
				year=str(info['year'])
				if len(year)>4: year=year[:4]
				print year
				#try:year2=str(int(info['year'])+1)
				#except:year2=year
				if __settings__.getSetting("SYear")=='true': SYear = False
				else: SYear = True
				
				#if info['originaltitle']==info['title']: 
				#ftitle = utt(get_title(D['title']))#lower().replace("«",'').replace("»",'').replace('"', '').replace("'", '').replace("`", '').strip()
				en_title = en_title+' '
				print en_title+" ^ "+tor_title
				if en_title in tor_title and BlackList(D['title']):
					if ru_title in tor_title or __settings__.getSetting("RuTitle")=='false':# or ftitle == lower(ru_title).strip()
						if year_in_title(years, tor_title) or __settings__.getSetting("SYear")=='false':#year in tor_title
							deb_print ('Название соответствует')
							size = D['size']
							if 'MB' in size and '.' in size: size=size[:size.find('.')]
							size = size.replace('GB','').replace('MB','').strip()
							if size not in Lz or __settings__.getSetting("CutSize") == 'false':
								Lz.append(size)
								Z=D['size']
								if 'GB' in Z and Z.find('.') == 2: Z=Z[:3]+Z[4:]
								season = get_season(tor_title)
								studio = get_studio(tor_title)
								label  = get_label (tor_title)
								title=xt(mid(Z, 10))+" | "+xt(mids(D['sids'], 6))+" | "+rt(title)
								
								title=label+" "+season+" "+studio+" "+title
								if additm: AddItem(title, "OpenTorrent", url, info)
								D['studio']=studio
								D['quality']=label
								D['season']=season
								L2.append(D)
			deb_print('---- end ----')
	__settings__.setSetting("LLL", repr({'id':id, 'data':L2}))
	return L2

def sercher(info):
	ch=get_ch(info)
	Lc=ch['list']
	if time.time()-ch['tm']<60: return Lc
	offlist=[]
	if __settings__.getSetting("Serv1")=='false':  offlist.append('rutor')
	if __settings__.getSetting("Serv2")=='false':  offlist.append('fasttor')
	if __settings__.getSetting("Serv3")=='false':  offlist.append('freebfg')
	if __settings__.getSetting("Serv4")=='false':  offlist.append('bitru')
	if __settings__.getSetting("Serv5")=='false':  offlist.append('fileek')
	#if __settings__.getSetting("Serv6")=='false':  offlist.append('hdreactor')
	if __settings__.getSetting("Serv7")=='false':  offlist.append('videolenta')
	if __settings__.getSetting("Serv8")=='false':  offlist.append('torrentby')
	if __settings__.getSetting("Serv9")=='false':  offlist.append('megapeer')
	#if __settings__.getSetting("Serv10")=='false': offlist.append('krasfs')
	if __settings__.getSetting("Serv11")=='false': offlist.append('findmagnet')
	if __settings__.getSetting("Serv12")=='false': offlist.append('kinozal')
	if __settings__.getSetting("Serv13")=='false': offlist.append('yohoho')
	
	sys.path.append(os.path.join(addon.getAddonInfo('path'),"src"))
	ld=os.listdir(os.path.join(addon.getAddonInfo('path'),"src"))
	L=[]
	
	if __settings__.getSetting("Multimod")=='true': # -------------- многопоточный режим
		pDialog = xbmcgui.DialogProgressBG()
		pDialog.create(info['originaltitle'], '...')
		try: tr_count = int(__settings__.getSetting("TrCount"))+2
		except: tr_count = 4
		
		tid = time.time()
		update_Lt('reset', tid)
		total_threads=0
		xbmc.sleep(100)
		n=0
		for i in ld:
			n+=1
			
			off = True
			for sr in offlist:
				if sr in i: off = False
			
			if i[-3:]=='.py' and off: 
				pDialog.update(n*100/len(ld), message=i[:-3])
				create_thread({'i': i, 'info':info, 'id':tid})
				total_threads+=1
				xbmc.sleep(100)
				print 'total_threads '+str(total_threads)
				print 'life_threads  '+str(total_threads- len(Lthread))
				for t in range(20):
					if total_threads - len(Lthread) <= tr_count: break
					xbmc.sleep(100)
					print '= limit trad ='
					
		print 'total_threads '+str(total_threads)
		
		try: tr_time = (int(__settings__.getSetting("TrTime"))+1)*5
		except: tr_time = 25
		
		for t in range(tr_time):
				pDialog.update(t*100/tr_time, message=str(len(Lthread))+' / '+str(total_threads))
				print 'step '+str(t)
				print str(len(Lthread))+' to '+str(total_threads)
				if len(Lthread) == total_threads: break
				xbmc.sleep(1000)
		
		for Lst in Lthread:
				for st in Lst:
					L.append(st)
		
		pDialog.update(100, message='')
		pDialog.close()
		
		
	
	else: # ------------------------ однопоточный режим
		for i in ld:
			off = True
			for sr in offlist:
				if sr in i: off = False
			
			if i[-3:]=='.py' and off: 
				try:
					exec ("import "+i[:-3]+"; skp="+i[:-3]+".Tracker()")
					Lst = skp.Search(info)
				except: Lst=[]
				
				for st in Lst:
					L.append(st)
	
	add_ch(info, L)
	
	for t in Lc:
		if t not in L: L.append(t)
	
	return L


def utt(t):
	try: t=lower(rt(t).replace("«",'').replace("»",'').replace('"', '').replace("'", '').replace("`", ''))
	except: pass
	return t

def BlackList(t):
	L=[' DLC', ' PC', 'Repack', ' PSP', ' MP3']
	for i in L:
		if i in t: return False
	return True

def get_sign(i):
	q=i['quality']
	s=i['season']
	if 'magnet:' in i['url']: u='M'
	else:					  u='T'
	t=lower(i['title'])
	t=t.replace('360','lo').replace('480','md').replace('720','hi').replace('1080','hd')
	for n in range(9):
		t=t.replace(str(n),'')
	t=t.replace('   ',' ').replace('  ',' ').replace('  ',' ')
	t=t.replace('-','').replace(':','').replace('/','').replace('()','').replace('сезон','').replace('серия','').replace('|','')
	t=t.replace('   ',' ').replace('  ',' ').replace('  ',' ')
	t=t.replace('[x из ]','').replace('[х из ]','').replace('( из )','').replace('[ из ]','')
	t=t.replace('   ',' ').replace('  ',' ').replace('  ',' ')
	t=t.replace(' avc','')
	t=t.replace('webdlrip','web').replace('webrip','web').replace('webdl','web')
	
	sign=CRC32(t+u)
	deb_print(sign+' : '+u+' '+t)
	return sign

def get_season(t):
	s=['[s','s', 'x', 'х', 'сезон ', ' сезон', 'сезоны ', ' сезоны']
	L=[]
	for i in range(99):
		if i>9: si=str(i)
		else:   si='0'+str(i)
		L.append(s[0]+si)
		L.append(s[1]+si)
		L.append(si+s[2])
		L.append(si+s[3])
		L.append(s[4]+si)
		L.append(si+s[5])
		
	for i in range(10):
		L.append(str(i)+' сезоны')
		L.append('сезоны '+str(i))
		L.append(s[0]+str(i))
	
	for i in range(10):
		L.append(str(i)+' сезон')
		L.append('сезон '+str(i))
		L.append(s[0]+str(i))
		
	for i in range(10):
		si=str(i)
		L.append(s[0]+si)
		L.append(s[1]+si)
		L.append(si+s[2])
		L.append(si+s[3])
		L.append(s[4]+si)
		L.append(si+s[5])
	
	
	
	lt=lower(t)
	k=-1
	k2=-1
	se='XX'
	for se1 in L:
		if se1 in lt: 
			k=lt.find(se1)+len(se1)
			k2=lt.find(se1)-1
			for f in s:
				se1 = se1.replace(f,'')
			if len(se1)<2: se1='0'+se1
			se=se1
			break
	
	try: print lt[k]
	except: k=-1
	try: print lt[k2]
	except: k2=-1

	if k>0 :
		if lt[k]=='-':
			if lt[k+1]=='0': d=1
			else: d=0
			print '----------------------'
			
			print lt[k+1+d:k+3]
			try:ne2=int(lt[k+1+d:k+3])
			except:ne2=-1
			print ne2
			
			if ne2<0:
				print lt[k+1]
				try:ne2=int(lt[k+1])
				except:ne2=-1
			
			if ne2>0:
				se2=str(ne2)
				if len(se2)<2: se2='0'+se2
				se = se1+'-'+se2
	
	elif k2>0:
		print '+++++++++++2+++++++++++'
		if lt[k2]=='-':
			if lt[k2-2]=='0': d=1
			else: d=0
			print '----------------------'
			
			print lt[k2-1-d:k2]
			try:ne2=int(lt[k2-1-d:k2])
			except:ne2=-1
			print ne2
			
			if ne2<0:
				print lt[k2-1]
				try:ne2=int(lt[k2-1])
				except:ne2=-1
			
			if ne2>0:
				se2=str(ne2)
				if len(se2)<2: se2='0'+se2
				se = se2+'-'+se1
	
	print se
	print '======='
	return se

def get_label(text):
	text=lower(text)#.lower()
	#print text
	if 'трейлер'  in text: return FC('[ Трейл.]',    'FF999999')
	if ' кпк'     in text: return FC('[   КПК  ]',   'FFF8888F')
	if 'telesyn'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'telecin'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'camrip'   in text: return FC('[    TS    ]', 'FFFF2222')
	if ' ts'      in text: return FC('[    TS    ]', 'FFFF2222')
	if 'dvdscr'   in text: return FC('[    Scr   ]', 'FFFF2222')
	if ' 3d'      in text: return FC('[    3D    ]', 'FC45FF45')
	if '720'      in text: return FC('[  720p  ]',   'FBFFFF55')
	if '1080'     in text: return FC('[ 1080p ]',    'FAFF9535')
	if '2160'     in text: return FC('[ 2160p ]',    'FAF990FF')
	if 'blu-ray'  in text: return FC('[  BRay  ]',   'FF5555FF')
	if 'bdremux'  in text: return FC('[    BD    ]', 'FF5555FF')
	if ' 4k'      in text: return FC('[    4K    ]', 'FF5555FF')
	if 'bdrip'    in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'drip'     in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'hdrip'    in text: return FC('[ HDRip ]',    'FE98FF98')
	if 'webrip'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'WEB'      in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'web-dl'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'hdtv'     in text: return FC('[ HDTV ]',     'FEFFFF88')
	if 'tvrip'    in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'satrip'   in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvb '     in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvdrip'   in text: return FC('[DVDRip]',     'FE88FFFF')
	if 'dvd5'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'xdvd'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-5'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-9'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd9'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	return FC('[   ????  ]', 'FFFFFFFF')

def get_label2(url):
	L = get_torrent_directory(url)
	for i in L:
		text = i['label']
		if '400'      in text: return FC('[  400p  ]',   'FEFF88FF')
		if '720'      in text: return FC('[  720p  ]',   'FBFFFF55')
		if '1080'     in text: return FC('[ 1080p ]',    'FAFF9535')
		if '2160'     in text: return FC('[ 2160p ]',    'FAF990FF')
	return FC('[   ????  ]', 'FFFFFFFF')


def get_title(t):
	n=999
	n1=t.find('/')
	n2=t.find('(')
	n3=t.find('[')
	if n1>0: n=n1
	if n2>0 and n2<n: n=n2
	if n3>0 and n3<n: n=n3
	ttl=t[:n].strip()
	print 'ttl:'+ttl
	if 'сезон' in ttl:
		for s in range(1,9):
			ss = str(s)+' сезон'
			if ss in ttl:
				n4=t.find(ss)
				ttl=ttl[:n4].strip()
				break
	
	return ttl

def get_studio(t):
	for i in L_studio:
		if lower(i) in lower(t):
			return i
	return ''

def SetViewMode(n):
	if n>0:
		xbmc.sleep(300)
		xbmc.executebuiltin("Container.SetViewMode(0)")
		#xbmc.sleep(10)
		for i in range(1,n):
			#xbmc.sleep(10)
			xbmc.executebuiltin("Container.NextViewMode")


def Favorites():
	try:L=eval(__settings__.getSetting("Favorites"))
	except:L=[]
	for id in L:
		info = get_info(id)
		AddItem(info['title'], "Episodes", id, info, len(L))

def add(id):
	try:L=eval(__settings__.getSetting("Favorites"))
	except:L=[]
	if id not in L: L.append(id)
	__settings__.setSetting("Favorites",repr(L))

def rem(id):
	try:L=eval(__settings__.getSetting("Favorites"))
	except:L=[]
	L2=[]
	for i in L:
		if i != id: L2.append(i)
	__settings__.setSetting("Favorites",repr(L2))

try:    mode = urllib.unquote_plus(get_params()["mode"])
except: mode = None
try:    url = urllib.unquote_plus(get_params()["url"])
except: url = None
try:    info = eval(urllib.unquote_plus(get_params()["info"]))
except: info = {}
try:    id = str(get_params()["id"])
except: id = '0'
try:    sign = str(get_params()["sign"])
except: sign = ''
try:    season = int(get_params()["season"])
except: season = 0
try:    ind = int(get_params()["ind"])
except: ind = 0
try:    name = get_params()["name"]
except: name = 'Noname'

if mode == None:
	Root()

if mode == "Season":
	Season(id, info)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	#xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewTorrent")))

if mode == "Search":
	Search()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Favorites":
	Favorites()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "ADD": add(id)
if mode == "REM": rem(id)
if mode == "SET": set_select(id, season, sign)
if mode == "Serials":
	Serials()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Genres":
	Genres()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Genre":
	Genre(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Similar":
	Similar(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Top":
	Top()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Popular":
	Popular()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))


if mode == "On_air":
	On_air()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "New":
	New()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Years":
	Years()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Year":
	Year(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Countrys":
	Countrys()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Country":
	Country(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Persons":
	Persons(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Person":
	Person(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Collect":
	Collect(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Collection":
	Collection()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)


if mode == "Episodes":
	if __settings__.getSetting("EpContent") == 'true': xbmcplugin.setContent(int(sys.argv[1]), 'episodes')
	if __settings__.getSetting("SList") == 'true': Episodes(id)
	else: Seasons(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewEpisode")))

if mode == "Episodes2":
	if __settings__.getSetting("EpContent") == 'true': xbmcplugin.setContent(int(sys.argv[1]), 'episodes')
	season=info['season']
	Episodes2(id, season)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewEpisode")))

if mode == "Quality":
	req=Quality(id)
	if req:
		xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
		xbmcplugin.endOfDirectory(handle)

if mode == "Quality2":
	Quality(url, id, False)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Play":
	Play(id, info)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Ep_list":
	Ep_list(id, info)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Save": Save(id)

if mode == "Update": get_all_serials()

if mode == "update_info": update_info(id)

if mode == "TopLists":
	TopLists()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Save_strm":
	if __settings__.getSetting("NFO2")=='true': save_film_nfo(id)
	save_strm (url, 0, id)

if mode == "check":
	check()

if mode == "Review":
	review(id)

if mode == "Autoplay":
	autoplay(id)

if mode == "TC":
	print '--- TC ---'
	TC(id, sign, season, name)

if mode == "TC2":
	TC2(id)

#print tvfeed.GET_TOKEN()
#add_ch('id', {}, ['',])

c.close()
