# -*- coding: utf-8 -*-
# *  Copyright (C) 2020 TDW

import urllib2, urllib, time, os, settings
api_key='ef17a1e0c9df7d0c6a926a0c94627e93'
api_url='https://api.themoviedb.org/3'
api_lang='ru-RU'

def JSON(j):
	null = None
	false = False
	true = True
	return eval(j.replace('\\/','/'))

def GET(url, Referer = ''):
	D=get_ch(url)
	if time.time()-D['tm']<3600*6 and D['data']!='': return D['data']
	try:
		req = urllib2.Request(url)
		response = urllib2.urlopen(req)
		link=response.read()
		response.close()
		add_ch(link, url)
		return link
	except: 
		if D['data']!='': return D['data']

def deb_print(t):
	print t

def CRC32(buf):
		import binascii
		buf = (binascii.crc32(buf) & 0xFFFFFFFF)
		return str("%08X" % buf)

def add_ch(data, url):
	try:
		SID = 'get_'+str(CRC32(url))
		D={}
		D['data'] = data
		D['tm']=time.time()
		settings.set(SID, repr(D))
	except: pass

def get_ch(url):
	try:
		SID = 'get_'+str(CRC32(url))
		D  = eval(settings.get(SID))
		data = D['data']
		tm = D['tm']
		return {'tm':tm, 'data':data}
	except:
		return {'tm':0, 'data':''}


#=============== API ==================
#sort_by=
#popularity.desc/.asc
#vote_average.desc/.asc
#first_air_date.desc/.asc

#with_genres=18
#include_null_first_air_dates=false
#first_air_date_year=2000
#vote_count.gte=50
#vote_average.gte=6
def discover(param):
	head = api_url+'/discover/tv?api_key='+api_key+'&language='+api_lang
	tail = ''
	for key in param.keys():
		tail = tail+'&'+key+'='+param[key]
	url = head + tail
	print url
	j=GET(url)
	D=JSON(j)
	return D

def search(q):
	q=urllib.quote_plus(q)
	url = api_url+'/search/tv?api_key='+api_key+'&query='+q+'&language='+api_lang
	j=GET(url)
	L=JSON(j)['results']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL


def seasons(id):
	url = api_url+'/tv/'+str(id)+'?api_key='+api_key+'&language='+api_lang
	#deb_print(url)
	j=GET(url)
	#deb_print(j)
	L=JSON(j)['seasons']
	Ls=[]
	try:total = L[-1]['season_number']
	except:total = 0
	for i in L:
		Ls.append({'season':i['season_number'], 'title':i['name'], 'plot':i['overview'], 'cover':i['poster_path'], 'id':i['id'], 'year': i['air_date'], 'total':total})
	return Ls

def episodes(id, sn):
	url = api_url+'/tv/'+str(id)+'/season/'+str(sn)+'?api_key='+api_key+'&language='+api_lang
	#deb_print(url)
	j=GET(url)
	#deb_print(j)
	L=JSON(j)['episodes']
	Le=[]
	for i in L:
		
		Le.append(kodi_info(i))
	return Le

def get_info(id):
	url = api_url+'/tv/'+str(id)+'?api_key='+api_key+'&language='+api_lang
	#deb_print(url)
	j=GET(url)
	#deb_print(j)
	D=JSON(j)
	return kodi_info(D)
#====================================


def kodi_info(mdb_info):
	key_dict = {'title':'name', 'originaltitle': 'original_name', 'rating': 'vote_average', 'plot': 'overview', 'cover': 'poster_path', 'fanart': 'backdrop_path', 'year': 'first_air_date', 'episode':'episode_number', 'season':'season_number', 'thumb':'still_path', 'premiered':'air_date', 'id':'id'}
	info={}
	for key in key_dict.keys():
		try: info[key]=mdb_info[key_dict[key]]
		except: pass
	
	Dg={10759:'Боевик',16:'Мультфильм',35:'Комедия',80:'Криминал',99:'Документальный',18:'Драма',10751:'Семейный',10762:'Детский',9648:'Детектив',10763:'Новости',10764:'Реалити-шоу',10765:'Фантастика / Фэнтези',10766:'Мыльная опера',10767:'Ток-шоу',10768:'Война',37:'Вестерн'}
	
	if 'genre_ids' in mdb_info.keys():
		genre = []
		Lgi = mdb_info['genre_ids']
		for gi in Lgi:
			if gi in Dg.keys(): genre.append(Dg[gi])
		if genre != []: info['genre']=genre
	
	if 'origin_country' in mdb_info.keys():
		country = mdb_info['origin_country']
		info['country']=country
		info['studio']=country
		if 'JP' in country:
			id = mdb_info['id']
			alt_title = get_alt_title(id)
			try:alt_title=alt_title.encode('utf-8')
			except: pass
			if info['originaltitle'] == info['title']: info['title']=alt_title
			info['originaltitle']=alt_title
	
	return info


def get_years(id):
	url = api_url+'/tv/'+str(id)+'?api_key='+api_key
	j=GET(url)
	D=JSON(j)
	fad=int(D['first_air_date'][:4])
	lad=int(D['last_air_date'][:4])
	return range(fad,lad+1)

def get_en_title(id):
	url = api_url+'/tv/'+str(id)+'?api_key='+api_key
	j=GET(url)
	D=JSON(j)
	return D['name']

def get_alt_title(id):
	try:
		import msdb
		return msdb.get_inf_db('alt'+str(id))
	except: pass
	alt_title = ''
	url = api_url+'/tv/'+str(id)+'/alternative_titles?api_key='+api_key
	print url
	j=GET(url)
	print j
	L=JSON(j)['results']
	for i in L:
		if i['iso_3166_1'] == 'JP': 
			alt_title = i['title']
			try: msdb.add_to_db('alt'+str(id), alt_title)
			except: pass
			return alt_title
	
	en_title=get_en_title(id)
	try: msdb.add_to_db('alt'+str(id), en_title)
	except: pass
	
	return en_title

def get_genre_list():
	url = api_url+'/genre/tv/list?api_key='+api_key+'&language='+api_lang
	j=GET(url)
	L=JSON(j)['genres']
	return L

def get_genre(id):
	LL=[]
	for p in range(5):
		param = {'include_null_first_air_dates':'false', 'sort_by':'vote_average.desc', 'vote_count.gte':'150', 'vote_average.gte':'4', 'with_genres':str(id),'page':str(p+1)}
		L=discover(param)['results']
		for i in L:
			LL.append(kodi_info(i))
	return LL

def similar(id):
	url = api_url+'/tv/'+id+'/similar?api_key='+api_key+'&language='+api_lang
	j=GET(url)
	L=JSON(j)['results']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL

def new():
	param = {'include_null_first_air_dates':'false', 'sort_by':'first_air_date.desc', 'vote_count.gte':'10','vote_average.gte':'5'}
	L=discover(param)['results']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL

def top():
	LL=[]
	for p in range(5):
		param = {'include_null_first_air_dates':'false', 'sort_by':'vote_average.desc', 'vote_count.gte':'1000','vote_average.gte':'5','without_genres':'16','page':str(p+1)}
		L=discover(param)['results']
		for i in L:
			LL.append(kodi_info(i))
	return LL

def top_mult():
	LL=[]
	for p in range(5):
		param = {'include_null_first_air_dates':'false', 'sort_by':'popularity.desc', 'vote_count.gte':'100','vote_average.gte':'5','with_genres':'16','include_adult':'false','page':str(p+1)}
		L=discover(param)['results']
		for i in L:
			LL.append(kodi_info(i))
	return LL

def popular():
	LL=[]
	for p in range(5):
		param = {'include_null_first_air_dates':'false', 'sort_by':'popularity.desc', 'vote_count.gte':'80','vote_average.gte':'5','page':str(p+1)}
		L=discover(param)['results']
		for i in L:
			LL.append(kodi_info(i))
	return LL


def on_the_air():
	LL=[]
	for p in range(5):
		url = api_url+'/tv/on_the_air?api_key='+api_key+'&language='+api_lang+'&page='+str(p+1)
		j=GET(url)
		L=JSON(j)['results']
		for i in L:
			LL.append(kodi_info(i))
	return LL


def country(c):
	param = {'include_null_first_air_dates':'false', 'sort_by':'popularity.desc', 'vote_count.gte':'3','vote_average.gte':'4', 'with_original_language':c}
	L=discover(param)['results']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL


def year(y):
	param = {'sort_by':'popularity.desc', 'vote_count.gte':'3','vote_average.gte':'4', 'first_air_date_year':y}#'include_null_first_air_dates':'false', 
	L=discover(param)['results']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL

def person(id):
	url = api_url+'/person/'+id+'/tv_credits?api_key='+api_key+'&language='+api_lang
	j=GET(url)
	L=JSON(j)['cast']
	LL=[]
	for i in L:
		LL.append(kodi_info(i))
	return LL

def person_list(id):
	url = api_url+'/tv/'+str(id)+'/credits?api_key='+api_key+'&language='+api_lang
	j=GET(url)
	L=JSON(j)['cast']
	LL=[]
	for i in L:
		LL.append({'id':i['id'],'title':i['name'],'cover':i['profile_path']})
	return LL

def collection_list():
	L=[
	{'id':'1', 'title': 'Anime', 'param' :{'include_null_first_air_dates':'false', 'sort_by':'vote_average.desc', 'vote_count.gte':'30','vote_average.gte':'4','with_genres':'16','with_original_language':'ja'}},
	{'id':'2', 'title': 'Американские мультфильмы', 'param' :{'include_null_first_air_dates':'false', 'sort_by':'vote_average.desc', 'vote_count.gte':'30','vote_average.gte':'4','with_genres':'16','with_original_language':'en'}},
	{'id':'3', 'title': 'Русские мультфильмы', 'param' :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','with_genres':'16',   'with_original_language':'ru'}},
	{'id':'4', 'title': 'Русские сериалы', 'param'     :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'ru'}},
	{'id':'5', 'title': 'Немецкие сериалы', 'param'    :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'de'}},
	{'id':'6', 'title': 'Испанские сериалы', 'param'   :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'es'}},
	{'id':'7', 'title': 'Турецкие сериалы', 'param'    :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'tr'}},
	{'id':'8', 'title': 'Французские сериалы', 'param' :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'fr'}},
	{'id':'9', 'title': 'Итальянские сериалы', 'param' :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'it'}},
	{'id':'10', 'title': 'Шведские сериалы', 'param'    :{'include_null_first_air_dates':'false', 'sort_by':'popularity.desc','without_genres':'16','with_original_language':'sv'}},
	]
	return L

def collection(id):
	Lc=collection_list()
	param={}
	LL=[]
	for c in Lc:
		if str(c['id'])==str(id): param=c['param']
	
	for p in range(5):
		param['page']=str(p+1)
		L=discover(param)['results']
		for i in L:
				LL.append(kodi_info(i))
	return LL


#id=new()[1]['id']
#print get_info(65930)
#time.sleep(10)