/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.Bits;
import junit.framework.TestCase;

public class _Bits
extends TestCase {
    public void test_makeBitSet() {
        int i;
        _Bits.assertEquals((String)_Bits.label(0), (int)0, (int)Bits.makeBitSet(0).length);
        for (i = 1; i <= 32; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)1, (int)Bits.makeBitSet(i).length);
        }
        for (i = 33; i <= 64; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)2, (int)Bits.makeBitSet(i).length);
        }
        for (i = 65; i < 4000; i += 101) {
            int expect = i >> 5;
            if (expect * 32 < i) {
                ++expect;
            }
            _Bits.assertEquals((String)_Bits.label(i), (int)expect, (int)Bits.makeBitSet(i).length);
        }
    }

    public void test_getMax() {
        for (int i = 0; i < 4000; i += 59) {
            int expect = i >> 5;
            if (expect * 32 < i) {
                ++expect;
            }
            _Bits.assertEquals((String)_Bits.label(i), (int)(expect * 32), (int)Bits.getMax(new int[expect]));
        }
    }

    public void test1_get() {
        int[] bits = Bits.makeBitSet(100);
        for (int i = 0; i < 100; ++i) {
            _Bits.assertFalse((String)_Bits.label(i), (boolean)Bits.get(bits, i));
        }
    }

    public void test2_get() {
        int i;
        int[] bits = Bits.makeBitSet(100);
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 0; i < 100; ++i) {
            _Bits.assertTrue((String)_Bits.label(i), (boolean)Bits.get(bits, i));
        }
    }

    public void test3_get() {
        int i;
        int[] bits = Bits.makeBitSet(100);
        for (i = 0; i < 100; ++i) {
            Bits.set(bits, i, i % 5 == 0);
        }
        for (i = 0; i < 100; ++i) {
            boolean expect = i % 5 == 0;
            _Bits.assertTrue((String)_Bits.label(i), (Bits.get(bits, i) == expect ? 1 : 0) != 0);
        }
    }

    public void test1_set1() {
        int[] bits = Bits.makeBitSet(50);
        bits[1] = -1;
        Bits.set(bits, 0, true);
        Bits.set(bits, 3, true);
        Bits.set(bits, 6, true);
        Bits.set(bits, 3, false);
        Bits.set(bits, 35, false);
        Bits.set(bits, 38, false);
        Bits.set(bits, 42, false);
        Bits.set(bits, 38, true);
        _Bits.assertEquals((String)_Bits.label(1), (int)65, (int)bits[0]);
        _Bits.assertEquals((String)_Bits.label(2), (int)-1033, (int)bits[1]);
    }

    public void test2_set1() {
        int i;
        int[] bits = Bits.makeBitSet(100);
        for (i = 0; i < 100; ++i) {
            if (i % 3 != 0) continue;
            Bits.set(bits, i, true);
        }
        for (i = 0; i < 100; ++i) {
            if (i % 5 != 0) continue;
            Bits.set(bits, i, false);
        }
        for (i = 0; i < 100; ++i) {
            if (i % 7 != 0) continue;
            Bits.set(bits, i, true);
        }
        for (i = 0; i < 100; ++i) {
            boolean expect = i % 7 == 0 || i % 3 == 0 && i % 5 != 0;
            _Bits.assertTrue((String)_Bits.label(i), (Bits.get(bits, i) == expect ? 1 : 0) != 0);
        }
    }

    public void test_set2() {
        int i;
        int[] bits = Bits.makeBitSet(100);
        for (i = 0; i < 100; ++i) {
            if (i % 11 != 0) continue;
            Bits.set(bits, i);
        }
        for (i = 0; i < 100; ++i) {
            boolean expect = i % 11 == 0;
            _Bits.assertTrue((String)_Bits.label(i), (Bits.get(bits, i) == expect ? 1 : 0) != 0);
        }
    }

    public void test_clear() {
        int i;
        int[] bits = Bits.makeBitSet(100);
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 0; i < 100; ++i) {
            if (i % 5 != 0) continue;
            Bits.clear(bits, i);
        }
        for (i = 0; i < 100; ++i) {
            boolean expect = i % 5 != 0;
            _Bits.assertTrue((String)_Bits.label(i), (Bits.get(bits, i) == expect ? 1 : 0) != 0);
        }
    }

    public void test1_isEmpty() {
        for (int i = 0; i < 10; ++i) {
            _Bits.assertTrue((String)_Bits.label(i), (boolean)Bits.isEmpty(new int[i]));
        }
    }

    public void test2_isEmpty() {
        for (int i = 1; i < 1000; i += 11) {
            int[] bits = Bits.makeBitSet(i);
            for (int j = i % 11; j >= 0; --j) {
                int x = i - 1 - j * 13;
                if (x < 0) continue;
                Bits.set(bits, x);
            }
            _Bits.assertFalse((String)_Bits.label(i), (boolean)Bits.isEmpty(bits));
        }
    }

    public void test1_bitCount() {
        for (int i = 0; i < 10; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)0, (int)Bits.bitCount(new int[i]));
        }
    }

    public void test2_bitCount() {
        for (int i = 1; i < 1000; i += 13) {
            int j;
            int[] bits = Bits.makeBitSet(i);
            int count = 0;
            for (j = 0; j < i; j += 20) {
                Bits.set(bits, j);
                ++count;
            }
            for (j = 7; j < i; j += 11) {
                if (Bits.get(bits, j)) continue;
                Bits.set(bits, j);
                ++count;
            }
            for (j = 3; j < i; j += 17) {
                if (Bits.get(bits, j)) continue;
                Bits.set(bits, j);
                ++count;
            }
            _Bits.assertEquals((String)_Bits.label(i), (int)count, (int)Bits.bitCount(bits));
        }
    }

    public void test1_anyInRange() {
        int[] bits = new int[100];
        for (int i = 0; i < 100; i += 11) {
            _Bits.assertFalse((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, 0, i));
        }
    }

    public void test2_anyInRange() {
        int[] bits = new int[100];
        for (int i = 0; i < 100; i += 11) {
            _Bits.assertFalse((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, i, 100));
        }
    }

    public void test3_anyInRange() {
        int[] bits = new int[100];
        for (int i = 0; i < 50; i += 7) {
            _Bits.assertFalse((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, i, 100 - i));
        }
    }

    public void test4_anyInRange() {
        int i;
        int[] bits = new int[100];
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 1; i < 100; i += 11) {
            _Bits.assertTrue((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, 0, i));
        }
    }

    public void test5_anyInRange() {
        int i;
        int[] bits = new int[100];
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 1; i < 100; i += 11) {
            _Bits.assertTrue((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, i, 100));
        }
    }

    public void test6_anyInRange() {
        int i;
        int[] bits = new int[100];
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 0; i < 50; i += 7) {
            _Bits.assertTrue((String)_Bits.label(i), (boolean)Bits.anyInRange(bits, i, 100 - i));
        }
    }

    public void test1_findFirst1() {
        int[] bits = new int[100];
        for (int i = 0; i < 100; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)-1, (int)Bits.findFirst(bits, i));
        }
    }

    public void test2_findFirst1() {
        int i;
        int[] bits = new int[100];
        for (i = 0; i < bits.length; ++i) {
            bits[i] = -1;
        }
        for (i = 0; i < 100; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)i, (int)Bits.findFirst(bits, i));
        }
    }

    public void test3_findFirst1() {
        int[] bits = new int[100];
        for (int i = 25; i < 80; ++i) {
            for (int j = 0; j < bits.length; ++j) {
                bits[j] = 0;
            }
            Bits.set(bits, i - 5);
            Bits.set(bits, i + 5);
            Bits.set(bits, i + 10);
            Bits.set(bits, i + 20);
            _Bits.assertEquals((String)_Bits.label(i), (int)(i + 5), (int)Bits.findFirst(bits, i));
        }
    }

    public void test1_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)-1, (int)Bits.findFirst(0, i));
        }
    }

    public void test2_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)i, (int)Bits.findFirst(-1, i));
        }
    }

    public void test3_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)-1, (int)Bits.findFirst(1 << i >>> 1, i));
        }
    }

    public void test4_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)i, (int)Bits.findFirst(1 << i, i));
        }
    }

    public void test5_findFirst2() {
        for (int i = 0; i < 31; ++i) {
            _Bits.assertEquals((String)_Bits.label(i), (int)(i + 1), (int)Bits.findFirst(1 << i + 1, i));
        }
    }

    public void test6_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            int value = 1 << i;
            value |= value >>> 1;
            _Bits.assertEquals((String)_Bits.label(i), (int)i, (int)Bits.findFirst(value, i));
        }
    }

    private static String label(int n) {
        return "(" + n + ")";
    }
}

