/*
 * Decompiled with CFR 0.152.
 */
package com.sikulix.vnc;

import com.sikulix.vnc.BasicUserPasswdGetter;
import com.sikulix.vnc.ThreadLocalSecurityClient;
import com.sikulix.vnc.VNCClipboard;
import com.sikulix.vnc.VNCFrameBuffer;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.UserPasswdGetter;
import com.tigervnc.vncviewer.CConn;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;

public class VNCClient
extends CConnection
implements FdInStreamBlockCallback,
Closeable {
    static ThreadLocal<UserPasswdGetter> UPG = new ThreadLocal();
    private final TcpSocket sock;
    private boolean shuttingDown = false;
    private PixelFormat serverPF;
    private int currentEncoding;
    private VNCFrameBuffer buffer;
    static LogWriter vlog;
    PixelFormat pixelFormat = null;
    int bufferW = 0;
    int bufferH = 0;

    public static void onDebugging() {
        LogWriter.setLogParams("300");
    }

    public static void offDebugging() {
        LogWriter.setLogParams("30");
    }

    public static VNCClient connect(String address, int port, String password, boolean shareConnection) {
        VNCClient client = new VNCClient(address, port, password, shareConnection);
        while (client.state() != 6) {
            client.processMsg();
        }
        vlog.debug("running");
        return client;
    }

    private VNCClient(String address, int port, String password, boolean shareConnection) {
        this.security = new ThreadLocalSecurityClient(new BasicUserPasswdGetter(password));
        this.currentEncoding = 7;
        this.setShared(shareConnection);
        this.setServerName(address);
        this.setServerPort(port);
        this.sock = new TcpSocket(this.getServerName(), this.getServerPort());
        this.sock.inStream().setBlockCallback(this);
        this.setStreams(this.sock.inStream(), this.sock.outStream());
        this.initialiseProtocol();
    }

    @Override
    public void serverInit() {
        super.serverInit();
        this.pixelFormat = this.serverPF = this.cp.pf();
        this.bufferW = this.cp.width;
        this.bufferH = this.cp.height;
        this.buffer = new VNCFrameBuffer(this.bufferW, this.bufferH, this.pixelFormat);
        this.writer().writeSetEncodings(this.currentEncoding, true);
    }

    @Override
    public void serverCutText(String content, int length) {
        if (length > 0) {
            VNCClipboard.putTextToClipboard(VNCClipboard.PLAIN, VNCClipboard.UTF8, VNCClipboard.CHAR_BUFFER, content);
        }
    }

    @Override
    public void setDesktopSize(int var1, int var2) {
        super.setDesktopSize(var1, var2);
        this.resizeFrameBuffer();
    }

    @Override
    public void clientRedirect(int i, String s, String s1) {
    }

    @Override
    public void setColourMapEntries(int offset, int nbColors, int[] rgb) {
    }

    @Override
    public void bell() {
    }

    @Override
    public PixelFormat getPreferredPF() {
        return null;
    }

    private void resizeFrameBuffer() {
        if (!(this.buffer == null || this.cp.width == 0 && this.cp.height == 0 || this.buffer.width() == this.cp.width && this.buffer.height() == this.cp.height)) {
            this.buffer.resize(this.cp.width, this.cp.height);
        }
    }

    public void refreshFramebuffer() {
        this.refreshFramebuffer(0, 0, this.cp.width, this.cp.height, false);
    }

    public void refreshFramebuffer(int x, int y, int w, int h, boolean incremental) {
        this.writer().writeFramebufferUpdateRequest(new Rect(x, y, w, h), incremental);
    }

    @Override
    public void framebufferUpdateStart() {
        this.refreshFramebuffer(0, 0, this.cp.width, this.cp.height, true);
    }

    @Override
    public void framebufferUpdateEnd() {
    }

    @Override
    public void fillRect(Rect r, int p) {
        this.buffer.fillRect(r.tl.x, r.tl.y, r.width(), r.height(), p);
    }

    @Override
    public void imageRect(Rect r, Object p) {
        this.buffer.imageRect(r.tl.x, r.tl.y, r.width(), r.height(), p);
    }

    @Override
    public void copyRect(Rect r, int sx, int sy) {
        this.buffer.copyRect(r.tl.x, r.tl.y, r.width(), r.height(), sx, sy);
    }

    public void keyDown(int key) throws IOException {
        this.writer().writeKeyEvent(key, true);
    }

    public void keyUp(int key) throws IOException {
        this.writer().writeKeyEvent(key, false);
    }

    public void mouseEvent(int buttonState, int x, int y) throws IOException {
        this.writer().writePointerEvent(new Point(x, y), buttonState);
    }

    @Override
    public void close() {
        this.shuttingDown = true;
        if (this.sock != null) {
            this.sock.shutdown();
        }
        vlog.debug("shutting down");
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public String toString() {
        return "VNCClient: " + this.getServerName() + ":" + this.getServerPort();
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.cp.width, this.cp.height);
    }

    public BufferedImage getFrameBuffer(int x, int y, int w, int h) {
        return this.buffer.getImage(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockCallback() {
        try {
            VNCClient vNCClient = this;
            synchronized (vNCClient) {
                this.wait(1L);
            }
        }
        catch (InterruptedException var4) {
            throw new Exception(var4.getMessage());
        }
    }

    public void processMessages() {
        while (!this.shuttingDown) {
            this.processMsg();
        }
    }

    static {
        CConn.upg = new UserPasswdGetter(){

            @Override
            public boolean getUserPasswd(StringBuffer stringBuffer, StringBuffer stringBuffer1) {
                UserPasswdGetter upg = UPG.get();
                return false;
            }
        };
        vlog = new LogWriter("VNCClient");
    }
}

