/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SSLEngineManager {
    private SSLEngine engine = null;
    private int appBufSize;
    private int pktBufSize;
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private Executor executor;
    private FdInStream in;
    private FdOutStream os;

    public SSLEngineManager(SSLEngine sslEngine, FdInStream is_, FdOutStream os_) throws IOException {
        this.in = is_;
        this.os = os_;
        this.engine = sslEngine;
        this.executor = Executors.newSingleThreadExecutor();
        this.pktBufSize = this.engine.getSession().getPacketBufferSize();
        this.appBufSize = this.engine.getSession().getApplicationBufferSize();
        this.myAppData = ByteBuffer.allocate(Math.max(this.appBufSize, this.os.getBufSize()));
        this.myNetData = ByteBuffer.allocate(this.pktBufSize);
        this.peerAppData = ByteBuffer.allocate(this.appBufSize);
        this.peerNetData = ByteBuffer.allocate(this.pktBufSize);
    }

    public void doHandshake() throws Exception {
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = this.engine.getHandshakeStatus();
        while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (hs) {
                case NEED_UNWRAP: {
                    this.peerNetData.flip();
                    SSLEngineResult res = this.engine.unwrap(this.peerNetData, this.peerAppData);
                    this.peerNetData.compact();
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            int max = Math.min(this.peerNetData.remaining(), this.in.getBufSize());
                            int m = this.in.check(1, max, true);
                            int pos = this.peerNetData.position();
                            this.in.readBytes(this.peerNetData.array(), pos, m);
                            this.peerNetData.position(pos + m);
                            this.peerNetData.flip();
                            this.peerNetData.compact();
                            break;
                        }
                        case OK: {
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeInbound();
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    this.myNetData.clear();
                    SSLEngineResult res = this.engine.wrap(this.myAppData, this.myNetData);
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            this.myAppData.compact();
                            this.myNetData.flip();
                            this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
                            this.os.flush();
                            this.myNetData.clear();
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeOutbound();
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.executeTasks();
                }
            }
            hs = this.engine.getHandshakeStatus();
        }
    }

    private void executeTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            this.executor.execute(task);
        }
    }

    public int read(byte[] data, int dataPtr, int length) throws IOException {
        int bytesRead = 0;
        this.peerNetData.flip();
        SSLEngineResult res = this.engine.unwrap(this.peerNetData, this.peerAppData);
        this.peerNetData.compact();
        switch (res.getStatus()) {
            case OK: {
                bytesRead = Math.min(length, res.bytesProduced());
                this.peerAppData.flip();
                this.peerAppData.get(data, dataPtr, bytesRead);
                this.peerAppData.compact();
                break;
            }
            case BUFFER_UNDERFLOW: {
                int pos = this.peerNetData.position();
                int need = this.peerNetData.remaining();
                int avail = this.in.check(1, this.in.getBufSize(), false);
                if (avail < need) {
                    avail = this.in.check(1, Math.min(need, this.in.getBufSize()), true);
                }
                this.in.readBytes(this.peerNetData.array(), pos, Math.min(need, avail));
                this.peerNetData.position(pos + Math.min(need, avail));
                break;
            }
            case CLOSED: {
                this.engine.closeInbound();
            }
        }
        return bytesRead;
    }

    public int write(byte[] data, int dataPtr, int length) throws IOException {
        int n = 0;
        this.myAppData.put(data, dataPtr, length);
        this.myAppData.flip();
        while (this.myAppData.hasRemaining()) {
            SSLEngineResult res = this.engine.wrap(this.myAppData, this.myNetData);
            n += res.bytesConsumed();
            switch (res.getStatus()) {
                case OK: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.myNetData.flip();
                    this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
                    this.os.flush();
                    this.myNetData.clear();
                    break;
                }
                case CLOSED: {
                    this.engine.closeOutbound();
                }
            }
        }
        this.myAppData.clear();
        this.myNetData.flip();
        this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
        this.os.flush();
        this.myNetData.clear();
        return n;
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }
}

