/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rdr.OutStream;
import java.io.IOException;
import javax.net.ssl.SSLSession;

public class TLSOutStream
extends OutStream {
    static final int defaultBufSize = 16384;
    private SSLEngineManager manager;
    private FdOutStream out;
    private int start;
    private int offset;
    private int bufSize;

    public TLSOutStream(OutStream _out, SSLEngineManager _manager) {
        this.manager = _manager;
        this.out = (FdOutStream)_out;
        SSLSession session = this.manager.getSession();
        this.bufSize = session.getApplicationBufferSize();
        this.b = new byte[this.bufSize];
        this.start = 0;
        this.offset = 0;
        this.ptr = 0;
        this.end = this.start + this.bufSize;
    }

    @Override
    public int length() {
        return this.offset + this.ptr - this.start;
    }

    @Override
    public void flush() {
        int sentUpTo = this.start;
        while (sentUpTo < this.ptr) {
            int n = this.writeTLS(this.b, sentUpTo, this.ptr - sentUpTo);
            sentUpTo += n;
            this.offset += n;
        }
        this.ptr = this.start;
    }

    @Override
    protected int overrun(int itemSize, int nItems) {
        if (itemSize > this.bufSize) {
            throw new Exception("TLSOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (itemSize * nItems > this.end - this.ptr) {
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    protected int writeTLS(byte[] data, int dataPtr, int length) {
        int n = 0;
        try {
            n = this.manager.write(data, dataPtr, length);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }
}

