/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.CMsgWriter;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;

public class CMsgWriterV3
extends CMsgWriter {
    public CMsgWriterV3(ConnParams cp_, OutStream os_) {
        super(cp_, os_);
    }

    @Override
    public synchronized void writeClientInit(boolean shared) {
        this.os.writeU8(shared ? 1 : 0);
        this.endMsg();
    }

    @Override
    public synchronized void startMsg(int type) {
        this.os.writeU8(type);
    }

    @Override
    public synchronized void endMsg() {
        this.os.flush();
    }

    public synchronized void writeSetDesktopSize(int width, int height, ScreenSet layout) {
        if (!this.cp.supportsSetDesktopSize) {
            throw new Exception("Server does not support SetDesktopSize");
        }
        this.startMsg(251);
        this.os.pad(1);
        this.os.writeU16(width);
        this.os.writeU16(height);
        this.os.writeU8(layout.num_screens());
        this.os.pad(1);
        for (Screen refScreen : layout.screens) {
            this.os.writeU32(refScreen.id);
            this.os.writeU16(refScreen.dimensions.tl.x);
            this.os.writeU16(refScreen.dimensions.tl.y);
            this.os.writeU16(refScreen.dimensions.width());
            this.os.writeU16(refScreen.dimensions.height());
            this.os.writeU32(refScreen.flags);
        }
        this.endMsg();
    }

    public synchronized void writeFence(int flags, int len, byte[] data) {
        if (!this.cp.supportsFence) {
            throw new Exception("Server does not support fences");
        }
        if (len > 64) {
            throw new Exception("Too large fence payload");
        }
        if ((flags & 0x7FFFFFF8) != 0) {
            throw new Exception("Unknown fence flags");
        }
        this.startMsg(248);
        this.os.pad(3);
        this.os.writeU32(flags);
        this.os.writeU8(len);
        this.os.writeBytes(data, 0, len);
        this.endMsg();
    }

    public synchronized void writeEnableContinuousUpdates(boolean enable, int x, int y, int w, int h) {
        if (!this.cp.supportsContinuousUpdates) {
            throw new Exception("Server does not support continuous updates");
        }
        this.startMsg(150);
        this.os.writeU8(enable ? 1 : 0);
        this.os.writeU16(x);
        this.os.writeU16(y);
        this.os.writeU16(w);
        this.os.writeU16(h);
        this.endMsg();
    }
}

