/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.VoidParameter;
import java.applet.Applet;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Configuration {
    static LogWriter vlog = new LogWriter("Configuration");
    private static Configuration global_ = null;
    private static Configuration server_ = null;
    private static Configuration viewer_ = null;
    private String name;
    public VoidParameter head;
    public Configuration _next;

    public static Configuration global() {
        if (global_ == null) {
            global_ = new Configuration("Global");
        }
        return global_;
    }

    public static Configuration server() {
        if (server_ == null) {
            server_ = new Configuration("Server");
        }
        return server_;
    }

    public static Configuration viewer() {
        if (viewer_ == null) {
            viewer_ = new Configuration("Viewer");
        }
        return viewer_;
    }

    public static void enableServerParams() {
        Configuration.global().appendConfiguration(Configuration.server());
    }

    public static void enableViewerParams() {
        Configuration.global().appendConfiguration(Configuration.viewer());
    }

    public void appendConfiguration(Configuration conf) {
        conf._next = this._next;
        this._next = conf;
    }

    public Configuration(String name_, Configuration attachToGroup) {
        this.name = name_;
        this.head = null;
        this._next = null;
        if (attachToGroup != null) {
            this._next = attachToGroup._next;
            attachToGroup._next = this;
        }
    }

    public Configuration(String name_) {
        this(name_, null);
    }

    public final String getName() {
        return this.name;
    }

    public Configuration assign(Configuration src) {
        VoidParameter current = this.head;
        while (current != null) {
            VoidParameter srcParam = src.get(current.getName());
            if (srcParam != null) {
                current.immutable = false;
                String value = srcParam.getValueStr();
                vlog.debug("operator=(" + current.getName() + ", " + value + ")");
                current.setParam(value);
            }
            current = current._next;
        }
        if (this._next != null) {
            this._next = src;
        }
        return this;
    }

    public boolean set(String n, String v, boolean immutable) {
        return this.set(n, n.length(), v, immutable);
    }

    public boolean set(String n, String v) {
        return this.set(n, n.length(), v, false);
    }

    public boolean set(String name, int len, String val, boolean immutable) {
        VoidParameter current = this.head;
        while (current != null) {
            if (current.getName().length() == len && current.getName().equalsIgnoreCase(name.substring(0, len))) {
                boolean b = current.setParam(val);
                current.setHasBeenSet();
                if (b && immutable) {
                    current.setImmutable();
                }
                return b;
            }
            current = current._next;
        }
        return this._next != null ? this._next.set(name, len, val, immutable) : false;
    }

    boolean set(String config, boolean immutable) {
        int equal;
        boolean hyphen = false;
        if (config.charAt(0) == '-') {
            hyphen = true;
            if ((config = config.substring(1)).charAt(0) == '-') {
                config = config.substring(1);
            }
        }
        if ((equal = config.indexOf(61)) > -1) {
            return this.set(config, equal, config.substring(equal + 1), immutable);
        }
        if (hyphen) {
            VoidParameter current = this.head;
            while (current != null) {
                if (current.getName().equalsIgnoreCase(config)) {
                    boolean b = current.setParam();
                    current.setHasBeenSet();
                    if (b && immutable) {
                        current.setImmutable();
                    }
                    return b;
                }
                current = current._next;
            }
        }
        return this._next != null ? this._next.set(config, immutable) : false;
    }

    boolean set(String config) {
        return this.set(config, false);
    }

    public static boolean setParam(String param, String value, boolean immutable) {
        return Configuration.global().set(param, value, immutable);
    }

    public static boolean setParam(String param, String value) {
        return Configuration.setParam(param, value, false);
    }

    public static boolean setParam(String config, boolean immutable) {
        return Configuration.global().set(config, immutable);
    }

    public static boolean setParam(String config) {
        return Configuration.setParam(config, false);
    }

    public static boolean setParam(String name, int len, String val, boolean immutable) {
        return Configuration.global().set(name, len, val, immutable);
    }

    public VoidParameter get(String param) {
        VoidParameter current = this.head;
        while (current != null) {
            if (current.getName().equalsIgnoreCase(param)) {
                return current;
            }
            current = current._next;
        }
        return this._next != null ? this._next.get(param) : null;
    }

    public static VoidParameter getParam(String param) {
        return Configuration.global().get(param);
    }

    public static void listParams(int width, int nameWidth) {
        Configuration.global().list(width, nameWidth);
    }

    public static void listParams() {
        Configuration.listParams(79, 10);
    }

    public void list(int width, int nameWidth) {
        VoidParameter current = this.head;
        System.err.format("%s Parameters:%n", this.name);
        while (current != null) {
            String def_str = current.getDefaultStr();
            String desc = current.getDescription().trim();
            String format = "  %-" + nameWidth + "s -";
            System.err.format(format, current.getName());
            int column = current.getName().length();
            if (column < nameWidth) {
                column = nameWidth;
            }
            column += 4;
            while (true) {
                int s;
                int wordLen;
                if (column + (wordLen = (s = desc.indexOf(32)) > -1 ? s : desc.length()) + 1 > width) {
                    format = "%n%" + (nameWidth + 4) + "s";
                    System.err.format(format, "");
                    column = nameWidth + 4;
                }
                format = " %" + wordLen + "s";
                System.err.format(format, desc.substring(0, wordLen));
                column += wordLen + 1;
                if (s == -1) break;
                desc = desc.substring(wordLen + 1);
            }
            if (def_str != null) {
                if (column + def_str.length() + 11 > width) {
                    System.err.format("%n%" + (nameWidth + 4) + "s", "");
                }
                System.err.format(" (default=%s)%n", def_str);
                def_str = null;
            } else {
                System.err.format("%n", new Object[0]);
            }
            current = current._next;
        }
        if (this._next != null) {
            this._next.list(width, nameWidth);
        }
    }

    public void list() {
        this.list(79, 10);
    }

    public void readAppletParams(Applet applet) {
        VoidParameter current = this.head;
        while (current != null) {
            String str = applet.getParameter(current.getName());
            if (str != null) {
                current.setParam(str);
            }
            current = current._next;
        }
    }

    public static void load(String filename) {
        if (filename == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(filename));
        }
        catch (AccessControlException e) {
            vlog.error("Cannot access system properties:" + e.getMessage());
            return;
        }
        catch (Exception e) {
            vlog.error("Error opening config file:" + e.getMessage());
            return;
        }
        for (String name : props.stringPropertyNames()) {
            if (name.startsWith("[")) continue;
            if (name.equals("host")) {
                Configuration.setParam("Server", props.getProperty(name));
                continue;
            }
            if (name.equals("disableclipboard")) {
                Configuration.setParam("RecvClipboard", props.getProperty(name));
                Configuration.setParam("SendClipboard", props.getProperty(name));
                continue;
            }
            if (name.equals("localcursor")) {
                Configuration.setParam("UseLocalCursor", props.getProperty(name));
                continue;
            }
            if (Configuration.setParam(name, props.getProperty(name))) continue;
            vlog.debug("Cannot set parameter: " + name);
        }
    }

    public static void save(String filename) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(filename, "UTF-8");
        }
        catch (Exception e) {
            vlog.error("Error opening config file:" + e.getMessage());
            return;
        }
        pw.println("# TigerVNC viewer configuration");
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM d k:m:s z yyyy");
        Date date = new Date();
        pw.println("# " + dateFormat.format(date));
        VoidParameter current = Configuration.global().head;
        while (current != null) {
            String name = current.getName();
            String value = current.getValueStr();
            if (!name.equals("Server") && !name.equals("Port") && value != null && value != current.getDefaultStr()) {
                pw.println(name + "=" + current.getValueStr());
            }
            current = current._next;
        }
        pw.flush();
        pw.close();
    }

    public static enum ConfigurationObject {
        ConfGlobal,
        ConfServer,
        ConfViewer;

    }
}

