/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import java.util.ArrayList;
import java.util.Iterator;

public class ScreenSet {
    public ArrayList<Screen> screens = new ArrayList();
    static LogWriter vlog = new LogWriter("ScreenSet");

    public final int num_screens() {
        return this.screens.size();
    }

    public final void add_screen(Screen screen) {
        this.screens.add(screen);
    }

    public final void remove_screen(int id) {
        Iterator<Screen> iter = this.screens.iterator();
        while (iter.hasNext()) {
            Screen refScreen = iter.next();
            if (refScreen.id != id) continue;
            iter.remove();
        }
    }

    public final boolean validate(int fb_width, int fb_height) {
        ArrayList<Integer> seen_ids = new ArrayList<Integer>();
        Rect fb_rect = new Rect();
        if (this.screens.isEmpty()) {
            return false;
        }
        if (this.num_screens() > 255) {
            return false;
        }
        fb_rect.setXYWH(0, 0, fb_width, fb_height);
        for (Screen refScreen : this.screens) {
            if (refScreen.dimensions.is_empty()) {
                return false;
            }
            if (!refScreen.dimensions.enclosed_by(fb_rect)) {
                return false;
            }
            seen_ids.add(refScreen.id);
        }
        return true;
    }

    public final void debug_print() {
        for (Screen refScreen : this.screens) {
            vlog.error("    " + refScreen.id + " (0x" + refScreen.id + "): " + refScreen.dimensions.width() + "x" + refScreen.dimensions.height() + "+" + refScreen.dimensions.tl.x + "+" + refScreen.dimensions.tl.y + " (flags 0x" + refScreen.flags + ")");
        }
    }
}

