/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.StringParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Security {
    public static final int secTypeInvalid = 0;
    public static final int secTypeNone = 1;
    public static final int secTypeVncAuth = 2;
    public static final int secTypeRA2 = 5;
    public static final int secTypeRA2ne = 6;
    public static final int secTypeSSPI = 7;
    public static final int secTypeSSPIne = 8;
    public static final int secTypeTight = 16;
    public static final int secTypeUltra = 17;
    public static final int secTypeTLS = 18;
    public static final int secTypeVeNCrypt = 19;
    public static final int secTypePlain = 256;
    public static final int secTypeTLSNone = 257;
    public static final int secTypeTLSVnc = 258;
    public static final int secTypeTLSPlain = 259;
    public static final int secTypeX509None = 260;
    public static final int secTypeX509Vnc = 261;
    public static final int secTypeX509Plain = 262;
    public static final int secTypeIdent = 265;
    public static final int secTypeTLSIdent = 266;
    public static final int secTypeX509Ident = 267;
    public static final int secResultOK = 0;
    public static final int secResultFailed = 1;
    public static final int secResultTooMany = 2;
    public static List<Integer> enabledSecTypes = new ArrayList<Integer>();
    static LogWriter vlog = new LogWriter("Security");

    public Security(StringParameter secTypes) {
        String secTypesStr = secTypes.getData();
        enabledSecTypes = Security.parseSecTypes(secTypesStr);
        secTypesStr = null;
    }

    public static final List<Integer> GetEnabledSecTypes() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int refType : enabledSecTypes) {
            if (refType < 256) continue;
            result.add(19);
            break;
        }
        for (int refType : enabledSecTypes) {
            if (refType >= 256) continue;
            result.add(refType);
        }
        return result;
    }

    public static final List<Integer> GetEnabledExtSecTypes() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int refType : enabledSecTypes) {
            if (refType == 19) continue;
            result.add(refType);
        }
        return result;
    }

    public static final void EnableSecType(int secType) {
        Iterator<Integer> i = enabledSecTypes.iterator();
        while (i.hasNext()) {
            if (i.next() != secType) continue;
            return;
        }
        enabledSecTypes.add(secType);
    }

    public boolean IsSupported(int secType) {
        Iterator<Integer> i = enabledSecTypes.iterator();
        while (i.hasNext()) {
            if (i.next() != secType) continue;
            return true;
        }
        return secType == 19;
    }

    public static void DisableSecType(int secType) {
        enabledSecTypes.remove((Object)secType);
    }

    public static int secTypeNum(String name) {
        if (name.equalsIgnoreCase("None")) {
            return 1;
        }
        if (name.equalsIgnoreCase("VncAuth")) {
            return 2;
        }
        if (name.equalsIgnoreCase("Tight")) {
            return 16;
        }
        if (name.equalsIgnoreCase("RA2")) {
            return 5;
        }
        if (name.equalsIgnoreCase("RA2ne")) {
            return 6;
        }
        if (name.equalsIgnoreCase("SSPI")) {
            return 7;
        }
        if (name.equalsIgnoreCase("SSPIne")) {
            return 8;
        }
        if (name.equalsIgnoreCase("VeNCrypt")) {
            return 19;
        }
        if (name.equalsIgnoreCase("Plain")) {
            return 256;
        }
        if (name.equalsIgnoreCase("Ident")) {
            return 265;
        }
        if (name.equalsIgnoreCase("TLSNone")) {
            return 257;
        }
        if (name.equalsIgnoreCase("TLSVnc")) {
            return 258;
        }
        if (name.equalsIgnoreCase("TLSPlain")) {
            return 259;
        }
        if (name.equalsIgnoreCase("TLSIdent")) {
            return 266;
        }
        if (name.equalsIgnoreCase("X509None")) {
            return 260;
        }
        if (name.equalsIgnoreCase("X509Vnc")) {
            return 261;
        }
        if (name.equalsIgnoreCase("X509Plain")) {
            return 262;
        }
        if (name.equalsIgnoreCase("X509Ident")) {
            return 267;
        }
        return 0;
    }

    public static String secTypeName(int num) {
        switch (num) {
            case 1: {
                return "None";
            }
            case 2: {
                return "VncAuth";
            }
            case 16: {
                return "Tight";
            }
            case 5: {
                return "RA2";
            }
            case 6: {
                return "RA2ne";
            }
            case 7: {
                return "SSPI";
            }
            case 8: {
                return "SSPIne";
            }
            case 19: {
                return "VeNCrypt";
            }
            case 256: {
                return "Plain";
            }
            case 265: {
                return "Ident";
            }
            case 257: {
                return "TLSNone";
            }
            case 258: {
                return "TLSVnc";
            }
            case 259: {
                return "TLSPlain";
            }
            case 266: {
                return "TLSIdent";
            }
            case 260: {
                return "X509None";
            }
            case 261: {
                return "X509Vnc";
            }
            case 262: {
                return "X509Plain";
            }
            case 267: {
                return "X509Ident";
            }
        }
        return "[unknown secType]";
    }

    public static final List<Integer> parseSecTypes(String types_) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] types = types_.split(",");
        for (int i = 0; i < types.length; ++i) {
            int typeNum = Security.secTypeNum(types[i]);
            if (typeNum == 0) continue;
            result.add(typeNum);
        }
        return result;
    }

    public final void SetSecTypes(List<Integer> secTypes) {
        enabledSecTypes = secTypes;
    }
}

