/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.ZlibInStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Rect;

public class ZRLEDecoder
extends Decoder {
    CMsgReader reader;
    ZlibInStream zis;

    public ZRLEDecoder(CMsgReader reader_) {
        this.reader = reader_;
        this.zis = new ZlibInStream();
    }

    @Override
    public void readRect(Rect r, CMsgHandler handler) {
        InStream is = this.reader.getInStream();
        int[] buf = this.reader.getImageBuf(16384);
        int bpp = handler.cp.pf().bpp;
        int bytesPerPixel = bpp > 24 ? 3 : bpp / 8;
        boolean bigEndian = handler.cp.pf().bigEndian;
        int length = is.readU32();
        this.zis.setUnderlying(is, length);
        Rect t = new Rect();
        t.tl.y = r.tl.y;
        while (t.tl.y < r.br.y) {
            t.br.y = Math.min(r.br.y, t.tl.y + 64);
            t.tl.x = r.tl.x;
            while (t.tl.x < r.br.x) {
                t.br.x = Math.min(r.br.x, t.tl.x + 64);
                int mode = this.zis.readU8();
                boolean rle = (mode & 0x80) != 0;
                int palSize = mode & 0x7F;
                int[] palette = new int[128];
                this.zis.readPixels(palette, palSize, bytesPerPixel, bigEndian);
                if (palSize == 1) {
                    int pix = palette[0];
                    handler.fillRect(t, pix);
                } else {
                    int len;
                    int end;
                    int ptr;
                    int b;
                    if (!rle) {
                        if (palSize == 0) {
                            this.zis.readPixels(buf, t.area(), bytesPerPixel, bigEndian);
                        } else {
                            int bppp = palSize > 16 ? 8 : (palSize > 4 ? 4 : (palSize > 2 ? 2 : 1));
                            int ptr2 = 0;
                            for (int i = 0; i < t.height(); ++i) {
                                int eol = ptr2 + t.width();
                                b = 0;
                                int nbits = 0;
                                while (ptr2 < eol) {
                                    if (nbits == 0) {
                                        b = this.zis.readU8();
                                        nbits = 8;
                                    }
                                    int index = b >> (nbits -= bppp) & (1 << bppp) - 1 & 0x7F;
                                    buf[ptr2++] = palette[index];
                                }
                            }
                        }
                    } else if (palSize == 0) {
                        ptr = 0;
                        end = ptr + t.area();
                        while (ptr < end) {
                            int pix = this.zis.readPixel(bytesPerPixel, bigEndian);
                            len = 1;
                            do {
                                b = this.zis.readU8();
                                len += b;
                            } while (b == 255);
                            if (len > end - ptr) {
                                throw new Exception("ZRLEDecoder: assertion (len <= end - ptr) failed");
                            }
                            while (len-- > 0) {
                                buf[ptr++] = pix;
                            }
                        }
                    } else {
                        ptr = 0;
                        end = ptr + t.area();
                        while (ptr < end) {
                            int index = this.zis.readU8();
                            len = 1;
                            if ((index & 0x80) != 0) {
                                do {
                                    b = this.zis.readU8();
                                    len += b;
                                } while (b == 255);
                                if (len > end - ptr) {
                                    throw new Exception("ZRLEDecoder: assertion (len <= end - ptr) failed");
                                }
                            }
                            int pix = palette[index &= 0x7F];
                            while (len-- > 0) {
                                buf[ptr++] = pix;
                            }
                        }
                    }
                    handler.imageRect(t, buf);
                }
                t.tl.x += 64;
            }
            t.tl.y += 64;
        }
        this.zis.reset();
    }
}

