/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;

class ClipboardDialog
extends Dialog {
    CConn cc;
    JTextArea textArea;
    JButton clearButton;
    JButton sendButton;
    JButton cancelButton;
    static LogWriter vlog = new LogWriter("ClipboardDialog");

    public ClipboardDialog(CConn cc_) {
        super(false);
        this.setTitle("VNC Clipboard Viewer");
        this.setPreferredSize(new Dimension(640, 480));
        this.addWindowFocusListener(new WindowAdapter(){

            public void WindowGainedFocus(WindowEvent e) {
                ClipboardDialog.this.clientCutText();
            }
        });
        this.cc = cc_;
        this.textArea = new JTextArea();
        this.textArea.setTransferHandler(new VncTransferHandler());
        this.textArea.setFocusable(false);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)sp, "Center");
        JPanel pb = new JPanel();
        this.clearButton = new JButton("Clear");
        pb.add(this.clearButton);
        this.sendButton = new JButton("Send to VNC server");
        pb.add(this.sendButton);
        this.cancelButton = new JButton("Cancel");
        pb.add(this.cancelButton);
        this.getContentPane().add("South", pb);
        this.addListeners(this);
        this.pack();
    }

    public void serverCutText(String str, int len) {
        this.textArea.setText(str);
        this.textArea.copy();
    }

    public void clientCutText() {
        int hc = this.textArea.getText().hashCode();
        this.textArea.paste();
        this.textArea.setCaretPosition(0);
        String text = this.textArea.getText();
        if (this.cc.viewer.sendClipboard.getValue() && hc != text.hashCode()) {
            this.cc.writeClientCutText(text, text.length());
        }
    }

    public void setSendingEnabled(boolean b) {
        this.sendButton.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s instanceof JButton && (JButton)s == this.clearButton) {
            this.serverCutText(new String(""), 0);
        } else if (s instanceof JButton && (JButton)s == this.sendButton) {
            String text = this.textArea.getText();
            this.cc.writeClientCutText(text, text.length());
            this.endDialog();
        } else if (s instanceof JButton && (JButton)s == this.cancelButton) {
            this.endDialog();
        }
    }

    private class VncTransferHandler
    extends TransferHandler {
        private LogWriter vlog = new LogWriter("VncTransferHandler");

        private VncTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent c, Clipboard clip, int a) throws IllegalStateException {
            if (!(c instanceof JTextComponent)) {
                return;
            }
            StringSelection selection = new StringSelection(((JTextComponent)c).getText());
            clip.setContents(selection, null);
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                try {
                    DataFlavor VncFlavor = null;
                    for (DataFlavor f : t.getTransferDataFlavors()) {
                        if (!f.isFlavorTextType() || !f.isRepresentationClassInputStream()) continue;
                        VncFlavor = f;
                    }
                    if (VncFlavor == null) {
                        return false;
                    }
                    Reader reader = VncFlavor.getReaderForText(t);
                    CharBuffer cbuf = CharBuffer.allocate(VncViewer.maxCutText.getValue());
                    cbuf.limit(reader.read(cbuf.array(), 0, cbuf.length()));
                    reader.close();
                    if (c instanceof JTextComponent) {
                        ((JTextComponent)c).setText(cbuf.toString());
                    }
                    return true;
                }
                catch (OutOfMemoryError oome) {
                    this.vlog.error("ERROR: Too much data on local clipboard!");
                }
                catch (UnsupportedFlavorException ufe) {
                    this.vlog.info(ufe.toString());
                }
                catch (IOException ioe) {
                    this.vlog.info(ioe.toString());
                }
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (DataFlavor f : flavors) {
                if (!f.isFlavorTextType() || !f.isRepresentationClassReader()) continue;
                return true;
            }
            return false;
        }
    }
}

