/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.Dialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class PasswdDialog
extends Dialog
implements UserInfo,
UIKeyboardInteractive {
    JLabel userLabel;
    JTextField userEntry;
    JLabel passwdLabel;
    JPasswordField passwdEntry;
    static LogWriter vlog = new LogWriter("PasswdDialog");

    public PasswdDialog(String title, boolean userDisabled, boolean passwdDisabled) {
        super(true);
        this.setResizable(false);
        this.setTitle(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PasswdDialog.this.endDialog();
            }
        });
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.userLabel = new JLabel("Username:");
        this.userLabel.setEnabled(!userDisabled);
        p1.add((Component)this.userLabel, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.userEntry = new JTextField(30);
        this.userEntry.setEnabled(!userDisabled);
        p1.add((Component)this.userEntry, new GridBagConstraints(1, 0, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.passwdLabel = new JLabel("Password:");
        this.passwdLabel.setEnabled(!passwdDisabled);
        p1.add((Component)this.passwdLabel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.passwdEntry = new JPasswordField(30);
        this.passwdEntry.setEnabled(!passwdDisabled);
        p1.add((Component)this.passwdEntry, new GridBagConstraints(1, 1, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(p1);
        this.addListeners(this);
        this.pack();
        if (this.userEntry.isEnabled()) {
            this.userEntry.requestFocus();
        } else {
            this.passwdEntry.requestFocus();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        Object s = event.getSource();
        if (s instanceof JTextField && (JTextField)s == this.userEntry) {
            if (event.getKeyCode() == 10) {
                this.endDialog();
            }
        } else if (s instanceof JPasswordField && (JPasswordField)s == this.passwdEntry && event.getKeyCode() == 10) {
            this.endDialog();
        }
    }

    @Override
    public String getPassword() {
        return new String(this.passwdEntry.getPassword());
    }

    @Override
    public String getPassphrase() {
        return null;
    }

    @Override
    public boolean promptPassphrase(String message) {
        return false;
    }

    @Override
    public boolean promptPassword(String message) {
        this.setTitle(message);
        this.showDialog();
        if (this.userEntry.isEnabled()) {
            if (this.userEntry.getText().equals("")) {
                return false;
            }
            if (!this.passwdEntry.isEnabled()) {
                return true;
            }
        }
        return this.passwdEntry.isEnabled() && !this.passwdEntry.getText().equals("");
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "Message", -1);
    }

    @Override
    public boolean promptYesNo(String str) {
        Object[] options = new Object[]{"YES", "NO"};
        int ret = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
        return ret == 0;
    }

    @Override
    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        vlog.info("OK");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new JLabel(instruction), new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JTextField[] texts = new JTextField[prompt.length];
        for (int i = 0; i < prompt.length; ++i) {
            panel.add((Component)new JLabel(prompt[i]), new GridBagConstraints(0, i + 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
            panel.add((Component)texts[i], new GridBagConstraints(1, i + 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        if (JOptionPane.showConfirmDialog(null, panel, destination + ": " + name, 2, 3) == 0) {
            String[] response = new String[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                response[i] = texts[i].getText();
            }
            return response;
        }
        return null;
    }
}

