/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.VoidParameter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    private static Preferences root = Preferences.userRoot().node("TigerVNC");
    static LogWriter vlog = new LogWriter("UserPreferences");

    public static void set(String nName, String key, String val) {
        Preferences node = root.node(nName);
        node.put(key, val);
    }

    public static void set(String nName, String key, int val) {
        Preferences node = root.node(nName);
        node.putInt(key, val);
    }

    public static void set(String nName, String key, boolean val) {
        Preferences node = root.node(nName);
        node.putBoolean(key, val);
    }

    public static String get(String nName, String key) {
        Preferences node = root.node(nName);
        VoidParameter p = Configuration.getParam(key);
        if (p != null) {
            return node.get(key, p.getDefaultStr());
        }
        return node.get(key, null);
    }

    public static boolean getBool(String nName, String key, boolean defval) {
        Preferences node = root.node(nName);
        VoidParameter p = Configuration.getParam(key);
        if (p != null && p.isBool()) {
            return node.getBoolean(key, p.getDefaultStr() == "1");
        }
        return node.getBoolean(key, defval);
    }

    public static boolean getBool(String nName, String key) {
        return UserPreferences.getBool(nName, key, false);
    }

    public static int getInt(String nName, String key) {
        Preferences node = root.node(nName);
        VoidParameter p = Configuration.getParam(key);
        if (p != null && !p.isBool()) {
            return node.getInt(key, Integer.parseInt(p.getDefaultStr()));
        }
        return -1;
    }

    public static void save() {
        try {
            root.sync();
            String[] keys = root.keys();
            for (int i = 0; i < keys.length; ++i) {
                vlog.debug(keys[i] + " = " + root.get(keys[i], null));
            }
        }
        catch (BackingStoreException e) {
            vlog.error(e.getMessage());
        }
    }

    public static void save(String nName) {
        try {
            Preferences node = root.node(nName);
            node.sync();
            String[] keys = root.keys();
            for (int i = 0; i < keys.length; ++i) {
                vlog.debug(keys[i] + " = " + node.get(keys[i], null));
            }
        }
        catch (BackingStoreException e) {
            vlog.error(e.getMessage());
        }
    }

    public static void clear() {
        try {
            root.clear();
            String[] children = root.childrenNames();
            for (int i = 0; i < children.length; ++i) {
                Preferences node = root.node(children[i]);
                node.removeNode();
            }
            root.sync();
        }
        catch (BackingStoreException e) {
            vlog.error(e.getMessage());
        }
    }

    public static void clear(String nName) {
        try {
            Preferences node = root.node(nName);
            node.clear();
            node.sync();
        }
        catch (BackingStoreException e) {
            vlog.error(e.getMessage());
        }
    }

    public static void load(String nName) {
        try {
            Preferences node = root.node(nName);
            String[] keys = node.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                VoidParameter p = Configuration.getParam(key);
                if (p == null) continue;
                String valueStr = node.get(key, null);
                if (valueStr == null) {
                    valueStr = p.getDefaultStr();
                }
                Configuration.setParam(key, valueStr);
            }
        }
        catch (BackingStoreException e) {
            vlog.error(e.getMessage());
        }
    }
}

