/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.x11;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.x11.KeyMap;
import com.tulskiy.keymaster.x11.X11;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X11Provider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(X11Provider.class);
    private Pointer display;
    private NativeLong window;
    private boolean listening;
    private Thread thread;
    private boolean reset;
    private ErrorHandler errorHandler;
    private final Object lock = new Object();
    private Queue<X11HotKey> registerQueue = new LinkedList<X11HotKey>();
    private List<X11HotKey> hotKeys = new ArrayList<X11HotKey>();

    @Override
    public void init() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Starting X11 global hotkey provider");
                X11Provider.this.display = X11.Lib.XOpenDisplay(null);
                X11Provider.this.errorHandler = new ErrorHandler();
                X11.Lib.XSetErrorHandler(X11Provider.this.errorHandler);
                X11Provider.this.window = X11.Lib.XDefaultRootWindow(X11Provider.this.display);
                X11Provider.this.listening = true;
                X11.XEvent event = new X11.XEvent();
                while (X11Provider.this.listening) {
                    block6: while (X11.Lib.XPending(X11Provider.this.display) > 0) {
                        X11.Lib.XNextEvent(X11Provider.this.display, event);
                        if (event.type != 2) continue;
                        X11.XKeyEvent xkey = (X11.XKeyEvent)event.readField("xkey");
                        for (X11HotKey hotKey : X11Provider.this.hotKeys) {
                            int state = xkey.state & 0x4D;
                            if (hotKey.code != (byte)xkey.keycode || hotKey.modifiers != state) continue;
                            LOGGER.info("Received event for hotkey: " + hotKey);
                            X11Provider.this.fireEvent(hotKey);
                            continue block6;
                        }
                    }
                    Object object = X11Provider.this.lock;
                    synchronized (object) {
                        if (X11Provider.this.reset) {
                            LOGGER.info("Reset hotkeys");
                            X11Provider.this.resetAll();
                            X11Provider.this.reset = false;
                            X11Provider.this.lock.notify();
                        }
                        while (!X11Provider.this.registerQueue.isEmpty()) {
                            X11HotKey hotKey = (X11HotKey)X11Provider.this.registerQueue.poll();
                            LOGGER.info("Registering hotkey: " + hotKey);
                            if (hotKey.isMedia()) {
                                X11Provider.this.registerMedia(hotKey);
                            } else {
                                X11Provider.this.register(hotKey);
                            }
                            X11Provider.this.hotKeys.add(hotKey);
                        }
                        try {
                            X11Provider.this.lock.wait(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                LOGGER.info("Thread - stop listening");
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void register(X11HotKey hotKey) {
        byte code = KeyMap.getCode(hotKey.keyStroke, this.display);
        if (code == 0) {
            LOGGER.warn("Could not find mapping for " + hotKey.keyStroke);
            return;
        }
        int modifiers = KeyMap.getModifiers(hotKey.keyStroke);
        hotKey.code = code;
        hotKey.modifiers = modifiers;
        for (int i = 0; i < 16; ++i) {
            int flags = this.correctModifiers(modifiers, i);
            X11.Lib.XGrabKey(this.display, code, flags, this.window, 1, 1, 1);
        }
    }

    private void registerMedia(X11HotKey hotKey) {
        byte keyCode = KeyMap.getMediaCode(hotKey.mediaKey, this.display);
        hotKey.modifiers = 0;
        hotKey.code = keyCode;
        X11.Lib.XGrabKey(this.display, keyCode, 0, this.window, 1, 1, 1);
    }

    private void resetAll() {
        for (X11HotKey hotKey : this.hotKeys) {
            if (!hotKey.isMedia()) {
                int modifiers = hotKey.modifiers;
                for (int i = 0; i < 16; ++i) {
                    int flags = this.correctModifiers(modifiers, i);
                    X11.Lib.XUngrabKey(this.display, hotKey.code, flags, this.window);
                }
                continue;
            }
            X11.Lib.XUngrabKey(this.display, hotKey.code, 0, this.window);
        }
        this.hotKeys.clear();
    }

    private int correctModifiers(int modifiers, int flags) {
        int ret = modifiers;
        if ((flags & 1) != 0) {
            ret |= 2;
        }
        if ((flags & 2) != 0) {
            ret |= 0x10;
        }
        if ((flags & 4) != 0) {
            ret |= 0x20;
        }
        if ((flags & 8) != 0) {
            ret |= 0x80;
        }
        return ret;
    }

    @Override
    public void stop() {
        if (this.thread != null) {
            this.listening = false;
            try {
                this.thread.join();
                X11.Lib.XCloseDisplay(this.display);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(keyCode, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MediaKey mediaKey, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(mediaKey, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class X11HotKey
    extends HotKey {
        byte code;
        int modifiers;

        X11HotKey(KeyStroke keyStroke, HotKeyListener listener) {
            super(keyStroke, listener);
        }

        X11HotKey(MediaKey mediaKey, HotKeyListener listener) {
            super(mediaKey, listener);
        }
    }

    class ErrorHandler
    implements X11.XErrorHandler {
        ErrorHandler() {
        }

        @Override
        public int apply(Pointer display, X11.XErrorEvent errorEvent) {
            byte[] buf = new byte[1024];
            X11.Lib.XGetErrorText(display, errorEvent.error_code, buf, buf.length);
            int len = 0;
            while (buf[len] != 0) {
                ++len;
            }
            LOGGER.warn("Error: " + new String(buf, 0, len));
            return 0;
        }
    }
}

