/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Robot;
import org.sikuli.android.ADBDevice;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;

public class ADBRobot
implements IRobot {
    private int mouse_X1 = -1;
    private int mouse_Y1 = -1;
    private int mouse_X2 = -1;
    private int mouse_Y2 = -1;
    private boolean mouseDown = false;
    private int autodelay = 0;
    private boolean waitForIdle = false;
    static final int MAX_DELAY = 60000;
    private ADBScreen screen;
    private ADBDevice device;

    public ADBRobot(ADBScreen screen, ADBDevice device) {
        this.screen = screen;
        this.device = device;
    }

    private void notSupported(String feature) {
        Debug.error("ADBRobot: %s: not supported yet", feature);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public IScreen getScreen() {
        return this.screen;
    }

    @Override
    public void cleanup() {
        this.notSupported("feature");
    }

    @Override
    public void keyDown(String keys) {
        this.notSupported("keyDown");
    }

    @Override
    public void keyUp(String keys) {
        this.notSupported("keyUp");
    }

    @Override
    public void keyDown(int code) {
        this.notSupported("keyDown");
    }

    @Override
    public void keyUp(int code) {
        this.notSupported("keyUp");
    }

    @Override
    public void keyUp() {
        this.notSupported("keyUp");
    }

    @Override
    public void pressModifiers(int modifiers) {
        if (modifiers != 0) {
            this.notSupported("pressModifiers");
        }
    }

    @Override
    public void releaseModifiers(int modifiers) {
        if (modifiers != 0) {
            this.notSupported("releaseModifiers");
        }
    }

    @Override
    public void typeChar(char character, IRobot.KeyMode mode) {
        if (this.device == null) {
            return;
        }
        this.device.typeChar(character);
    }

    @Override
    public void typeKey(int key) {
        this.notSupported("typeKey");
    }

    @Override
    public void typeStarts() {
        if (this.device == null) {
            return;
        }
        while (!this.device.typeStarts()) {
            RunTime.pause(1);
        }
    }

    @Override
    public void typeEnds() {
        if (this.device == null) {
            return;
        }
        this.device.typeEnds();
    }

    @Override
    public void mouseMove(int x, int y) {
        if (!this.mouseDown) {
            this.mouse_X1 = x;
            this.mouse_Y1 = y;
        } else {
            this.mouse_X2 = x;
            this.mouse_Y2 = y;
        }
    }

    @Override
    public void mouseDown(int buttons) {
        this.clickStarts();
    }

    @Override
    public int mouseUp(int buttons) {
        this.clickEnds();
        return 0;
    }

    @Override
    public void mouseReset() {
        this.mouseDown = false;
    }

    @Override
    public void clickStarts() {
        this.mouseDown = true;
        this.mouse_X2 = this.mouse_X1;
        this.mouse_Y2 = this.mouse_Y1;
    }

    @Override
    public void clickEnds() {
        if (this.device == null) {
            return;
        }
        if (this.mouseDown) {
            this.mouseDown = false;
            if (this.mouse_X1 == this.mouse_X2 && this.mouse_Y1 == this.mouse_Y2) {
                this.device.tap(this.mouse_X1, this.mouse_Y1);
            } else {
                this.device.swipe(this.mouse_X1, this.mouse_Y1, this.mouse_X2, this.mouse_Y2);
            }
        }
    }

    @Override
    public void smoothMove(Location dest) {
        this.mouseMove(dest.x, dest.y);
    }

    @Override
    public void smoothMove(Location src, Location dest, long ms) {
        this.notSupported("smoothMove");
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        this.notSupported("mouseWheel");
    }

    @Override
    public ScreenImage captureScreen(Rectangle screenRect) {
        if (this.device == null) {
            return null;
        }
        return this.device.captureScreen(screenRect);
    }

    @Override
    public Color getColorAt(int x, int y) {
        this.notSupported("getColorAt");
        return null;
    }

    @Override
    public void waitForIdle() {
        try {
            new Robot().waitForIdle();
        }
        catch (AWTException e) {
            Debug.log(-1, "Error-could non instantiate robot: " + e, new Object[0]);
        }
    }

    @Override
    public void delay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        if (ms > 60000) {
            ms = 60000;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Debug.log(-1, "Thread Interrupted: " + e, new Object[0]);
        }
    }

    @Override
    public void setAutoDelay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        if (ms > 60000) {
            ms = 60000;
        }
        this.autodelay = ms;
    }
}

