/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.sikuli.guide.Visual;

public class ShadowRenderer {
    Visual source;
    float shadowOpacity = 0.8f;
    int shadowSize = 10;
    Color shadowColor = Color.black;
    BufferedImage shadowImage = null;
    Dimension sourceActualSize = null;

    public ShadowRenderer(Visual source, int shadowSize) {
        this.source = source;
        this.sourceActualSize = source.getActualSize();
        this.shadowSize = shadowSize;
    }

    BufferedImage createShadowMask(BufferedImage image) {
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = mask.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        g2d.setColor(this.shadowColor);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
        return mask;
    }

    ConvolveOp getBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        for (int i = 0; i < data.length; ++i) {
            data[i] = value;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public BufferedImage createShadowImage() {
        BufferedImage image = new BufferedImage(this.source.getActualWidth() + this.shadowSize * 2, this.source.getActualHeight() + this.shadowSize * 2, 2);
        Graphics2D g2 = image.createGraphics();
        g2.translate(this.shadowSize, this.shadowSize);
        this.source.paintPlain(g2);
        this.shadowImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        this.getBlurOp(this.shadowSize).filter(this.createShadowMask(image), this.shadowImage);
        g2.dispose();
        return this.shadowImage;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.shadowImage == null || this.source.getActualHeight() != this.sourceActualSize.height || this.source.getActualWidth() != this.sourceActualSize.width) {
            this.createShadowImage();
            this.sourceActualSize = this.source.getActualSize();
        }
        g2d.drawImage(this.shadowImage, 0, 0, null, null);
    }
}

