/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;

public class SxArea
extends Visual
implements ComponentListener {
    ArrayList<Region> regions = new ArrayList();
    ArrayList<Visual> landmarks = new ArrayList();
    public static final int BOUNDING = 0;
    public static final int INTERSECTION = 1;
    int relationship = 0;
    int mode = 0;
    public static int VERTICAL = 1;
    public static int HORIZONTAL = 2;

    public SxArea() {
        this.setOpacity(0.0f);
    }

    public void setRelationship(int relationship) {
        this.relationship = relationship;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    void updateBounds() {
        Rectangle rect = null;
        Screen s = new Screen();
        for (Visual comp : this.landmarks) {
            if (rect == null) {
                rect = new Rectangle(comp.getBounds());
                continue;
            }
            if (this.relationship == 0) {
                rect.add(comp.getBounds());
                continue;
            }
            if (this.relationship != 1) continue;
            rect = rect.intersection(comp.getBounds());
        }
        if (rect.width < 0 || rect.height <= 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            if (this.mode == 0) {
                this.setActualLocation(rect.x, rect.y);
                this.setActualSize(rect.getSize());
            } else if (this.mode == VERTICAL) {
                this.setActualLocation(rect.x, 0);
                this.setActualSize(rect.width, s.h);
            } else if (this.mode == HORIZONTAL) {
                this.setActualLocation(0, rect.y);
                this.setActualSize(s.w, rect.height);
            }
        }
        this.updateVisibility();
    }

    public void addLandmark(Visual comp) {
        this.landmarks.add(comp);
        this.updateBounds();
        comp.addComponentListener(this);
    }

    public void addRegion(Region region) {
        if (this.regions.isEmpty()) {
            this.setActualBounds(region.getRect());
        } else {
            Rectangle bounds = this.getBounds();
            bounds.add(region.getRect());
            this.setActualBounds(bounds);
        }
        this.regions.add(region);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
    }

    private void updateVisibility() {
        boolean allHidden = true;
        for (Visual landmark : this.landmarks) {
            allHidden = allHidden && !landmark.isVisible();
        }
        if (allHidden) {
            // empty if block
        }
        this.setVisible(!allHidden);
        if (this.isVisible()) {
            this.addFadeinAnimation();
            this.startAnimation();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateVisibility();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        Rectangle r = this.getBounds();
        this.updateBounds();
        r.add(this.getBounds());
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().repaint(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setVisible(true);
    }
}

