/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JLabel;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxBracket
extends Visual {
    public static final int DIRECTION_EAST = 1;
    public static final int DIRECTION_WEST = 2;
    public static final int DIRECTION_SOUTH = 3;
    public static final int DIRECTION_NORTH = 4;
    int direction;
    public int PADDING_X = 2;
    public int PADDING_Y = 2;
    public int SHADOW_SIZE = 2;
    int thickness = 10;
    int margin = 5;
    JLabel label;
    int length;
    boolean entrance = false;

    public SxBracket() {
        this.init();
    }

    private void init() {
        this.length = 30;
        this.colorFront = Color.RED;
        this.stroke = 3;
    }

    @Override
    public void updateComponent() {
        this.setLocationRelativeToRegion(this.getTarget(), this.layout);
    }

    @Override
    public Visual setLocationRelativeToRegion(Region region, Visual.Layout side) {
        if (side == Visual.Layout.TOP) {
            this.setActualSize(region.w, this.thickness);
            this.setDirection(3);
        } else if (side == Visual.Layout.BOTTOM) {
            this.setActualSize(region.w, this.thickness);
            this.setDirection(4);
        } else if (side == Visual.Layout.LEFT) {
            this.setActualSize(this.thickness, region.h);
            this.setDirection(1);
        } else if (side == Visual.Layout.RIGHT) {
            this.setActualSize(this.thickness, region.h);
            this.setDirection(2);
        }
        this.length = side == Visual.Layout.LEFT || side == Visual.Layout.RIGHT ? region.h : region.w;
        return super.setLocationRelativeToRegion(region, side);
    }

    @Override
    public void startAnimation() {
        if (this.direction == 1) {
            this.setEntranceAnimation(this.createSlidingAnimator(-20, 0));
        } else if (this.direction == 2) {
            this.setEntranceAnimation(this.createSlidingAnimator(20, 0));
        } else if (this.direction == 3) {
            this.setEntranceAnimation(this.createSlidingAnimator(0, -20));
        } else if (this.direction == 4) {
            this.setEntranceAnimation(this.createSlidingAnimator(0, 20));
        }
        super.startAnimation();
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke pen = new BasicStroke(this.stroke);
        g2d.setStroke(pen);
        g2d.setColor(this.colorFront);
        GeneralPath polyline = new GeneralPath();
        polyline.moveTo(0.0f, 0.0f);
        polyline.lineTo(5.0f, 5.0f);
        polyline.lineTo(5.0f, this.length / 2 - 6);
        polyline.lineTo(8.0f, this.length / 2);
        polyline.lineTo(5.0f, this.length / 2 + 6);
        polyline.lineTo(5.0f, this.length - 5);
        polyline.lineTo(0.0f, this.length);
        AffineTransform rat = new AffineTransform();
        if (this.direction == 1) {
            rat.translate(this.thickness, this.length);
            rat.rotate(Math.PI);
        } else if (this.direction == 3) {
            rat.translate(0.0, this.thickness);
            rat.rotate(-1.5707963267948966);
        } else if (this.direction == 4) {
            rat.translate(this.length, 0.0);
            rat.rotate(1.5707963267948966);
        }
        g2d.transform(rat);
        g2d.draw(polyline);
        super.paintComponent(g);
    }
}

