/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import org.sikuli.basics.Debug;
import org.sikuli.guide.Guide;
import org.sikuli.guide.SxCircle;
import org.sikuli.guide.SxClickable;
import org.sikuli.guide.SxSpotlight;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxHotspot
extends SxClickable {
    Font f = new Font("sansserif", 1, 18);
    JLabel label;
    Guide guide;
    SxSpotlight spotlight;
    Visual text;
    JLabel symbol;
    SxCircle circle;

    public SxHotspot(Region region, Visual text, Guide g) {
        super(region);
        this.guide = g;
        this.spotlight = new SxSpotlight(region);
        this.spotlight.setShape(1);
        Rectangle bounds = this.spotlight.getBounds();
        bounds.grow(10, 10);
        this.spotlight.setBounds(bounds);
        this.text = text;
        text.setLocationRelativeToComponent(this, Visual.Layout.RIGHT);
        Font f = new Font("sansserif", 1, 18);
        this.symbol = new JLabel("?");
        this.symbol.setFont(f);
        Dimension size = this.symbol.getPreferredSize();
        this.symbol.setSize(size);
        this.symbol.setForeground(Color.white);
        this.symbol.setLocation(region.x + region.w / 2 - size.width / 2, region.y + region.h / 2 - size.height / 2);
        Rectangle cc = new Rectangle(this.symbol.getBounds());
        cc.grow(7, 0);
        this.circle = new SxCircle(new Region(cc));
        this.circle.setForeground(Color.white);
        this.circle.setShadow(5, 2);
        g.content.add(this.symbol);
        g.addToFront(this.circle);
        g.addToFront(this.spotlight);
        g.addToFront(text);
        text.setVisible(false);
        this.spotlight.setVisible(false);
    }

    @Override
    public void globalMouseEntered() {
        Debug.info("Entered", new Object[0]);
        this.circle.setVisible(false);
        this.symbol.setVisible(false);
        this.spotlight.setVisible(true);
        this.text.setVisible(true);
        this.guide.repaint();
    }

    @Override
    public void globalMouseExited() {
        Debug.info("Exited", new Object[0]);
        this.circle.setVisible(true);
        this.symbol.setVisible(true);
        this.spotlight.setVisible(false);
        this.text.setVisible(false);
        this.guide.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.mouseOver) {
            g2d.setColor(new Color(0, 0, 0, 0));
        } else {
            g2d.setColor(this.normalColor);
        }
    }
}

