/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxSpotlight
extends Visual {
    public static final int RECTANGLE = 0;
    public static final int CIRCLE = 1;
    boolean border = true;
    Color border_color = Color.black;
    int shape = 0;
    Region region;

    public SxSpotlight() {
        this.setShape(0);
    }

    public SxSpotlight(Region region) {
        this.region = region;
        if (region != null) {
            this.setActualBounds(region.getRect());
        }
        this.setShape(0);
    }

    public void setShape(int shape_constant) {
        this.shape = shape_constant;
    }

    @Override
    public void paint(Graphics g) {
        super.paintPlain(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.opacity == 0.0f) {
            return;
        }
        Rectangle r = this.getBounds();
        g2d.setComposite(AlphaComposite.getInstance(1, 1.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.shape == 0) {
            g2d.fillRect(0, 0, r.width - 1, r.height - 1);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f * (1.0f - this.opacity)));
            g2d.fillRect(0, 0, r.width - 1, r.height - 1);
        } else if (this.shape == 1) {
            Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, r.width, r.height);
            g2d.fill(ellipse);
            g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
            int[] ds = new int[]{0, 2, 4, 6};
            float[] bs = new float[]{0.25f, 0.15f, 0.1f};
            for (int i = 0; i < 3; ++i) {
                int d = ds[i];
                float b = bs[i];
                g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
                ellipse = new Ellipse2D.Double(d, d, r.width - 2 * d, r.height - 2 * d);
                g2d.setColor(new Color(0.0f, 0.0f, 0.0f, b));
                g2d.fill(ellipse);
                d = ds[i + 1];
                g2d.setComposite(AlphaComposite.getInstance(1, 1.0f));
                ellipse = new Ellipse2D.Double(d, d, r.width - 2 * d, r.height - 2 * d);
                g2d.setColor(Color.black);
                g2d.fill(ellipse);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.5f * (1.0f - this.opacity)));
                g2d.fill(ellipse);
            }
        }
    }
}

