/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.EventListener;
import org.sikuli.basics.Debug;
import org.sikuli.script.ObserveEvent;
import org.sikuli.util.JLangHelperInterface;
import org.sikuli.util.JRubyHelper;
import org.sikuli.util.JythonHelper;

public class ObserverCallBack
implements EventListener {
    private Object callback = null;
    private ObserveEvent.Type obsType = ObserveEvent.Type.GENERIC;
    private JLangHelperInterface scriptHelper = null;
    private String scriptRunnerType = null;

    public ObserverCallBack() {
    }

    public ObserverCallBack(Object callback, ObserveEvent.Type obsType) {
        this.callback = callback;
        this.obsType = obsType;
        if (callback.getClass().getName().contains("org.python")) {
            this.scriptRunnerType = "jython";
            this.scriptHelper = JythonHelper.get();
        } else if (callback.getClass().getName().contains("org.jruby")) {
            this.scriptRunnerType = "jruby";
            this.scriptHelper = JRubyHelper.get();
        } else {
            Debug.error("ObserverCallBack: %s init: ScriptRunner not available for class %s", new Object[]{obsType, callback.getClass().getName()});
        }
    }

    public ObserveEvent.Type getType() {
        return this.obsType;
    }

    public void appeared(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.APPEAR.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void vanished(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.VANISH.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void changed(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.CHANGE.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void happened(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.GENERIC.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void findfailed(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.FINDFAILED.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void missing(ObserveEvent e) {
        if (this.scriptHelper != null && ObserveEvent.Type.MISSING.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    private void run(ObserveEvent e) {
        boolean success = true;
        Object[] args = new Object[]{this.callback, e};
        if (this.scriptHelper != null && !(success = this.scriptHelper.runObserveCallback(args))) {
            Debug.error("ObserverCallBack: problem with scripting handler: %s\n%s", this.scriptHelper.getClass().getName(), this.callback.getClass().getName());
        }
    }

    public void setType(ObserveEvent.Type givenType) {
        this.obsType = givenType;
    }
}

