/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.net.URL;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;

public class Pattern {
    static RunTime runTime = RunTime.get();
    private Image image = null;
    private float similarity = (float)Settings.MinSimilarity;
    private Location offset = new Location(0, 0);
    private int waitAfter = 0;
    private boolean imagePattern = false;

    public Pattern() {
    }

    public Pattern(Pattern p) {
        this.image = p.getImage();
        this.similarity = p.similarity;
        this.offset.x = p.offset.x;
        this.offset.y = p.offset.y;
        this.imagePattern = this.image.isPattern();
    }

    public Pattern(Image img) {
        this.image = Image.create(img);
        this.image.setIsPattern(false);
        this.imagePattern = true;
    }

    public boolean isImagePattern() {
        return this.imagePattern;
    }

    public Pattern(String imgpath) {
        this.image = Image.create(imgpath);
    }

    public Pattern(URL url) {
        this.image = Image.create(url);
    }

    public Pattern(BufferedImage bimg) {
        this.image = new Image(bimg);
    }

    public Pattern(ScreenImage simg) {
        this.image = new Image(simg.getImage());
    }

    public boolean isValid() {
        return this.image.isValid() || this.imagePattern;
    }

    public Pattern setFilename(String fileName) {
        this.image = Image.create(fileName);
        return this;
    }

    public Pattern setFilename(URL fileURL) {
        this.image = Image.create(fileURL);
        return this;
    }

    public Pattern setFilename(Image img) {
        this.image = img;
        return this;
    }

    public String getFilename() {
        return this.image.getFilename();
    }

    public URL getFileURL() {
        return this.image.getURL();
    }

    public Pattern similar(float sim) {
        this.similarity = sim;
        return this;
    }

    public Pattern exact() {
        this.similarity = 0.99f;
        return this;
    }

    public float getSimilar() {
        return this.similarity;
    }

    public Pattern targetOffset(int dx, int dy) {
        this.offset.x = dx;
        this.offset.y = dy;
        return this;
    }

    public Pattern targetOffset(Location loc) {
        this.offset.x = loc.x;
        this.offset.y = loc.y;
        return this;
    }

    public Location getTargetOffset() {
        return this.offset;
    }

    public BufferedImage getBImage() {
        return this.image.get();
    }

    public Pattern setBImage(BufferedImage bimg) {
        this.image = new Image(bimg);
        return this;
    }

    public Pattern setImage(Image img) {
        this.image = img;
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public void setTimeAfter(int secs) {
        this.waitAfter = secs;
    }

    public int getTimeAfter() {
        return this.waitAfter;
    }

    public String toString() {
        String ret = "P(" + this.image.getName() + (this.isValid() ? "" : " -- not valid!") + ")";
        ret = ret + " S: " + this.similarity;
        if (this.offset.x != 0 || this.offset.y != 0) {
            ret = ret + " T: " + this.offset.x + "," + this.offset.y;
        }
        return ret;
    }
}

