/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.sikuli.basics.Debug;

public class SysJNA {

    @Library(value="user32")
    public static class WinUser32 {
        private static int WinNumLock = 144;
        private static int WinScrollLock = 145;
        private static int WinCapsLock = 20;

        public static boolean isNumLockOn() {
            int state = WinUser32.GetKeyState(WinNumLock);
            return state > 0;
        }

        public static boolean isScrollLockOn() {
            int state = WinUser32.GetKeyState(WinScrollLock);
            return state > 0;
        }

        public static boolean isCapsLockOn() {
            int state = WinUser32.GetKeyState(WinCapsLock);
            return state > 0;
        }

        private static native int GetKeyState(int var0);

        static {
            BridJ.register();
        }
    }

    @Library(value="kernel32")
    public static class WinKernel32 {
        private static native int GetEnvironmentVariableW(Pointer<Character> var0, Pointer<Character> var1, int var2);

        private static native boolean SetEnvironmentVariableW(Pointer<Character> var0, Pointer<Character> var1);

        public static String getEnvironmentVariable(String name) {
            int BUFFER_SIZE = Short.MAX_VALUE;
            Pointer<Character> buffer = Pointer.allocateArray(Character.class, 32767L);
            int result = WinKernel32.GetEnvironmentVariableW(Pointer.pointerToWideCString(name), buffer, Short.MAX_VALUE);
            if (result == 0) {
                Debug.error("WinKernel32: getEnvironmentVariable: does not work for: %s", name);
                return null;
            }
            return buffer.getWideCString();
        }

        public static boolean setEnvironmentVariable(String name, String value) {
            if (!WinKernel32.SetEnvironmentVariableW(Pointer.pointerToWideCString(name), Pointer.pointerToWideCString(value))) {
                Debug.error("WinKernel32: setEnvironmentVariable: does not work for: %s = %s", name, value);
                return false;
            }
            return true;
        }

        static {
            BridJ.register();
        }
    }
}

