/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.vnc;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.ScreenImage;
import org.sikuli.vnc.VNCScreen;

class VNCRobot
implements IRobot {
    public static final int VNC_POINTER_EVENT_BUTTON_1 = 1;
    public static final int VNC_POINTER_EVENT_BUTTON_2 = 2;
    public static final int VNC_POINTER_EVENT_BUTTON_3 = 4;
    public static final int VNC_POINTER_EVENT_BUTTON_4 = 8;
    public static final int VNC_POINTER_EVENT_BUTTON_5 = 16;
    public static final int VNC_POINTER_EVENT_BUTTON_6 = 32;
    public static final int VNC_POINTER_EVENT_BUTTON_7 = 64;
    public static final int VNC_POINTER_EVENT_BUTTON_8 = 128;
    private final VNCScreen screen;
    private int mouseX;
    private int mouseY;
    private int mouseButtons;
    private int autoDelay;
    private Set<Integer> pressedKeys;
    private boolean shiftPressed;

    public VNCRobot(VNCScreen screen) {
        this.screen = screen;
        this.autoDelay = 100;
        this.pressedKeys = new TreeSet<Integer>();
    }

    @Override
    public ScreenImage captureScreen(Rectangle screenRect) {
        return this.screen.capture(screenRect);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public IScreen getScreen() {
        return this.screen;
    }

    @Override
    public void keyDown(String keys) {
        for (int i = 0; i < keys.length(); ++i) {
            this.typeChar(keys.charAt(i), IRobot.KeyMode.PRESS_ONLY);
        }
    }

    @Override
    public void keyUp(String keys) {
        for (int i = 0; i < keys.length(); ++i) {
            this.typeChar(keys.charAt(i), IRobot.KeyMode.RELEASE_ONLY);
        }
    }

    @Override
    public void keyDown(int code) {
        this.typeKey(code, IRobot.KeyMode.PRESS_ONLY);
    }

    @Override
    public void keyUp(int code) {
        this.typeCode(this.keyToXlib(code), IRobot.KeyMode.RELEASE_ONLY);
    }

    @Override
    public void keyUp() {
        for (Integer key : new ArrayList<Integer>(this.pressedKeys)) {
            this.typeCode(key, IRobot.KeyMode.RELEASE_ONLY);
        }
    }

    @Override
    public void pressModifiers(int modifiers) {
        this.typeModifiers(modifiers, IRobot.KeyMode.PRESS_ONLY);
    }

    @Override
    public void releaseModifiers(int modifiers) {
        this.typeModifiers(modifiers, IRobot.KeyMode.RELEASE_ONLY);
    }

    private void typeModifiers(int modifiers, IRobot.KeyMode keyMode) {
        if ((modifiers & 2) != 0) {
            this.typeKey(17, keyMode);
        }
        if ((modifiers & 1) != 0) {
            this.typeKey(16, keyMode);
        }
        if ((modifiers & 8) != 0) {
            this.typeKey(18, keyMode);
        }
        if ((modifiers & 0x20) != 0) {
            this.typeKey(65406, keyMode);
        }
        if ((modifiers & 4) != 0) {
            this.typeKey(157, keyMode);
        }
    }

    @Override
    public void typeStarts() {
    }

    @Override
    public void typeEnds() {
    }

    @Override
    public void typeKey(int key) {
        this.typeKey(key, IRobot.KeyMode.PRESS_RELEASE);
    }

    @Override
    public void typeChar(char character, IRobot.KeyMode mode) {
        if (character >= '\ue000' && character < '\ue050') {
            this.typeKey(Key.toJavaKeyCode(character)[0], mode);
        } else {
            this.typeCode(this.charToXlib(character), mode);
        }
    }

    public void typeKey(int key, IRobot.KeyMode mode) {
        this.typeCode(this.keyToXlib(key), mode);
    }

    private void typeCode(int xlibCode, IRobot.KeyMode mode) {
        boolean addShift = this.requiresShift(xlibCode) && !this.shiftPressed;
        try {
            if (mode == IRobot.KeyMode.PRESS_RELEASE || mode == IRobot.KeyMode.PRESS_ONLY) {
                if (addShift) {
                    this.pressKey(65505);
                }
                this.pressKey(xlibCode);
                if (xlibCode == 65505 || xlibCode == 65506 || xlibCode == 65510) {
                    this.shiftPressed = true;
                }
            }
            if (mode == IRobot.KeyMode.PRESS_RELEASE || mode == IRobot.KeyMode.RELEASE_ONLY) {
                this.releaseKey(xlibCode);
                if (addShift) {
                    this.releaseKey(65505);
                }
                if (xlibCode == 65505 || xlibCode == 65506 || xlibCode == 65510) {
                    this.shiftPressed = false;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pressKey(int key) throws IOException {
        this.screen.getClient().keyDown(key);
        this.pressedKeys.add(key);
    }

    private void releaseKey(int key) throws IOException {
        this.screen.getClient().keyUp(key);
        this.pressedKeys.remove(key);
    }

    private int charToXlib(char c) {
        if (c == '\u007f') {
            return 65535;
        }
        if (c >= ' ' && c <= '\u00ff') {
            return c;
        }
        switch (c) {
            case '\b': {
                return 65288;
            }
            case '\t': {
                return 65289;
            }
            case '\n': {
                return 65290;
            }
            case '\u000b': {
                return 65291;
            }
            case '\r': {
                return 65293;
            }
            case '\u0013': {
                return 65299;
            }
            case '\u0014': {
                return 65300;
            }
            case '\u0015': {
                return 65301;
            }
            case '\u001b': {
                return 65307;
            }
        }
        throw new IllegalArgumentException("Cannot type character " + c);
    }

    private int keyToXlib(int code) {
        switch (code) {
            case 10: {
                return 65293;
            }
            case 8: {
                return 65288;
            }
            case 9: {
                return 65289;
            }
            case 3: {
                return 65385;
            }
            case 12: {
                return 65291;
            }
            case 16: {
                return 65505;
            }
            case 17: {
                return 65507;
            }
            case 18: {
                return 65513;
            }
            case 19: {
                return 65299;
            }
            case 20: {
                return 65509;
            }
            case 27: {
                return 65307;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 65365;
            }
            case 34: {
                return 65366;
            }
            case 35: {
                return 65367;
            }
            case 36: {
                return 65360;
            }
            case 37: {
                return 65361;
            }
            case 38: {
                return 65362;
            }
            case 39: {
                return 65363;
            }
            case 40: {
                return 65364;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 47: {
                return 47;
            }
            case 48: {
                return 48;
            }
            case 49: {
                return 49;
            }
            case 50: {
                return 50;
            }
            case 51: {
                return 51;
            }
            case 52: {
                return 52;
            }
            case 53: {
                return 53;
            }
            case 54: {
                return 54;
            }
            case 55: {
                return 55;
            }
            case 56: {
                return 56;
            }
            case 57: {
                return 57;
            }
            case 59: {
                return 59;
            }
            case 61: {
                return 61;
            }
            case 65: {
                return this.shiftPressed ? 65 : 97;
            }
            case 66: {
                return this.shiftPressed ? 66 : 98;
            }
            case 67: {
                return this.shiftPressed ? 67 : 99;
            }
            case 68: {
                return this.shiftPressed ? 68 : 100;
            }
            case 69: {
                return this.shiftPressed ? 69 : 101;
            }
            case 70: {
                return this.shiftPressed ? 70 : 102;
            }
            case 71: {
                return this.shiftPressed ? 71 : 103;
            }
            case 72: {
                return this.shiftPressed ? 72 : 104;
            }
            case 73: {
                return this.shiftPressed ? 73 : 105;
            }
            case 74: {
                return this.shiftPressed ? 74 : 106;
            }
            case 75: {
                return this.shiftPressed ? 75 : 107;
            }
            case 76: {
                return this.shiftPressed ? 76 : 108;
            }
            case 77: {
                return this.shiftPressed ? 77 : 109;
            }
            case 78: {
                return this.shiftPressed ? 78 : 110;
            }
            case 79: {
                return this.shiftPressed ? 79 : 111;
            }
            case 80: {
                return this.shiftPressed ? 80 : 112;
            }
            case 81: {
                return this.shiftPressed ? 81 : 113;
            }
            case 82: {
                return this.shiftPressed ? 82 : 114;
            }
            case 83: {
                return this.shiftPressed ? 83 : 115;
            }
            case 84: {
                return this.shiftPressed ? 84 : 116;
            }
            case 85: {
                return this.shiftPressed ? 85 : 117;
            }
            case 86: {
                return this.shiftPressed ? 86 : 118;
            }
            case 87: {
                return this.shiftPressed ? 87 : 119;
            }
            case 88: {
                return this.shiftPressed ? 88 : 120;
            }
            case 89: {
                return this.shiftPressed ? 89 : 121;
            }
            case 90: {
                return this.shiftPressed ? 90 : 122;
            }
            case 91: {
                return 91;
            }
            case 92: {
                return 92;
            }
            case 93: {
                return 93;
            }
            case 96: {
                return 65456;
            }
            case 97: {
                return 65457;
            }
            case 98: {
                return 65458;
            }
            case 99: {
                return 65459;
            }
            case 100: {
                return 65460;
            }
            case 101: {
                return 65461;
            }
            case 102: {
                return 65462;
            }
            case 103: {
                return 65463;
            }
            case 104: {
                return 65464;
            }
            case 105: {
                return 65465;
            }
            case 106: {
                return 65450;
            }
            case 107: {
                return 65451;
            }
            case 108: {
                return 65452;
            }
            case 109: {
                return 65453;
            }
            case 110: {
                return 65454;
            }
            case 111: {
                return 65455;
            }
            case 127: {
                return 65439;
            }
            case 144: {
                return 65407;
            }
            case 145: {
                return 65300;
            }
            case 112: {
                return 65470;
            }
            case 113: {
                return 65471;
            }
            case 114: {
                return 65472;
            }
            case 115: {
                return 65473;
            }
            case 116: {
                return 65474;
            }
            case 117: {
                return 65475;
            }
            case 118: {
                return 65476;
            }
            case 119: {
                return 65477;
            }
            case 120: {
                return 65478;
            }
            case 121: {
                return 65479;
            }
            case 122: {
                return 65480;
            }
            case 123: {
                return 65481;
            }
            case 61440: {
                return 65482;
            }
            case 61441: {
                return 65483;
            }
            case 61442: {
                return 65484;
            }
            case 61443: {
                return 65485;
            }
            case 61444: {
                return 65486;
            }
            case 61445: {
                return 65487;
            }
            case 61446: {
                return 65488;
            }
            case 61447: {
                return 65489;
            }
            case 61448: {
                return 65490;
            }
            case 61449: {
                return 65491;
            }
            case 61450: {
                return 65492;
            }
            case 61451: {
                return 65493;
            }
            case 154: {
                return 65377;
            }
            case 155: {
                return 65379;
            }
            case 156: {
                return 65386;
            }
            case 157: {
                return 65511;
            }
            case 224: {
                return 65431;
            }
            case 225: {
                return 65433;
            }
            case 226: {
                return 65430;
            }
            case 227: {
                return 65432;
            }
            case 128: {
                return 65104;
            }
            case 129: {
                return 65105;
            }
            case 130: {
                return 65106;
            }
            case 131: {
                return 65107;
            }
            case 132: {
                return 65108;
            }
            case 133: {
                return 65109;
            }
            case 134: {
                return 65110;
            }
            case 135: {
                return 65111;
            }
            case 136: {
                return 65112;
            }
            case 137: {
                return 65113;
            }
            case 138: {
                return 65114;
            }
            case 139: {
                return 65115;
            }
            case 140: {
                return 65116;
            }
            case 141: {
                return 65117;
            }
            case 142: {
                return 65118;
            }
            case 143: {
                return 65119;
            }
            case 150: {
                return 38;
            }
            case 151: {
                return 42;
            }
            case 152: {
                return 34;
            }
            case 153: {
                return 60;
            }
            case 160: {
                return 62;
            }
            case 161: {
                return 91;
            }
            case 162: {
                return 93;
            }
            case 512: {
                return 64;
            }
            case 513: {
                return 58;
            }
            case 514: {
                return 226;
            }
            case 515: {
                return 36;
            }
            case 516: {
                return 8364;
            }
            case 517: {
                return 33;
            }
            case 518: {
                return 161;
            }
            case 519: {
                return 40;
            }
            case 520: {
                return 35;
            }
            case 521: {
                return 43;
            }
            case 522: {
                return 41;
            }
            case 523: {
                return 95;
            }
            case 524: {
                return 65515;
            }
            case 65312: {
                return 65312;
            }
            case 65406: {
                return 65027;
            }
            case 65368: {
                return 65368;
            }
        }
        throw new IllegalArgumentException("Cannot type keycode " + code);
    }

    private boolean requiresShift(int xlibKeySym) {
        switch (xlibKeySym) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseMove(int x, int y) {
        try {
            this.screen.getClient().mouseEvent(this.mouseButtons, x, y);
            this.mouseX = x;
            this.mouseY = y;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mouseDown(int buttons) {
        if ((buttons & 0x10) != 0) {
            this.mouseButtons |= 1;
        }
        if ((buttons & 8) != 0) {
            this.mouseButtons |= 2;
        }
        if ((buttons & 4) != 0) {
            this.mouseButtons |= 4;
        }
        this.mouseMove(this.mouseX, this.mouseY);
    }

    @Override
    public int mouseUp(int buttons) {
        if ((buttons & 0x10) != 0) {
            this.mouseButtons &= 0xFFFFFFFE;
        }
        if ((buttons & 8) != 0) {
            this.mouseButtons &= 0xFFFFFFFD;
        }
        if ((buttons & 4) != 0) {
            this.mouseButtons &= 0xFFFFFFFB;
        }
        this.mouseMove(this.mouseX, this.mouseY);
        int remainingButtons = 0;
        if ((this.mouseButtons & 1) != 0) {
            remainingButtons |= 0x10;
        }
        if ((this.mouseButtons & 2) != 0) {
            remainingButtons |= 8;
        }
        if ((this.mouseButtons & 4) != 0) {
            remainingButtons |= 4;
        }
        return remainingButtons;
    }

    @Override
    public void mouseReset() {
        this.mouseButtons = 0;
        this.mouseMove(this.mouseX, this.mouseY);
    }

    @Override
    public void clickStarts() {
    }

    @Override
    public void clickEnds() {
    }

    @Override
    public void smoothMove(Location dest) {
        this.smoothMove(new Location(this.mouseX, this.mouseY), dest, (long)(Settings.MoveMouseDelay * 1000.0f));
    }

    @Override
    public void smoothMove(Location src, Location dest, long duration) {
        if (duration <= 0L) {
            this.mouseMove(dest.getX(), dest.getY());
            return;
        }
        float x = src.getX();
        float y = src.getY();
        float dx = dest.getX() - src.getX();
        float dy = dest.getY() - src.getY();
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        do {
            float fraction = (float)elapsed / (float)duration;
            this.mouseMove((int)(x + fraction * dx), (int)(y + fraction * dy));
            this.delay(this.autoDelay);
        } while ((elapsed = System.currentTimeMillis() - start) < duration);
        this.mouseMove(dest.x, dest.y);
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        if (wheelAmt == Mouse.WHEEL_DOWN) {
            this.mouseButtons |= 0x10;
            this.mouseMove(this.mouseX, this.mouseY);
            this.mouseButtons &= 0xFFFFFFEF;
            this.mouseMove(this.mouseX, this.mouseY);
        } else if (wheelAmt == -1) {
            this.mouseButtons |= 8;
            this.mouseMove(this.mouseX, this.mouseY);
            this.mouseButtons &= 0xFFFFFFF7;
            this.mouseMove(this.mouseX, this.mouseY);
        }
    }

    @Override
    public void waitForIdle() {
    }

    @Override
    public void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void setAutoDelay(int ms) {
        this.autoDelay = ms;
    }

    @Override
    public Color getColorAt(int x, int y) {
        ScreenImage image = this.captureScreen(new Rectangle(x, y, 1, 1));
        return new Color(image.getImage().getRGB(0, 0));
    }

    @Override
    public void cleanup() {
    }
}

