/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import java.io.IOException;

public abstract class Socket {
    protected FdInStream instream;
    protected FdOutStream outstream;
    boolean ownStreams;
    boolean isShutdown_;
    boolean queryConnection;

    public Socket(FileDescriptor fd) {
        this.instream = new FdInStream(fd);
        this.outstream = new FdOutStream(fd);
        this.ownStreams = true;
        this.isShutdown_ = false;
        this.queryConnection = false;
    }

    public FdInStream inStream() {
        return this.instream;
    }

    public FdOutStream outStream() {
        return this.outstream;
    }

    public FileDescriptor getFd() {
        return this.outstream.getFd();
    }

    public void shutdown() {
        this.isShutdown_ = true;
    }

    public void close() throws IOException {
        this.getFd().close();
    }

    public final boolean isShutdown() {
        return this.isShutdown_;
    }

    public abstract int getMyPort();

    public abstract String getPeerAddress();

    public abstract String getPeerName();

    public abstract int getPeerPort();

    public abstract String getPeerEndpoint();

    public abstract boolean sameMachine();

    public void setRequiresQuery() {
        this.queryConnection = true;
    }

    public final boolean requiresQuery() {
        return this.queryConnection;
    }

    protected Socket() {
        this.instream = null;
        this.outstream = null;
        this.ownStreams = false;
        this.isShutdown_ = false;
        this.queryConnection = false;
    }

    protected Socket(FdInStream i, FdOutStream o, boolean own) {
        this.instream = i;
        this.outstream = o;
        this.ownStreams = own;
        this.isShutdown_ = false;
        this.queryConnection = false;
    }
}

