/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rdr.TimedOut;

public class FdOutStream
extends OutStream {
    static final int DEFAULT_BUF_SIZE = 16384;
    static final int minBulkSize = 1024;
    protected FileDescriptor fd;
    protected boolean blocking;
    protected int timeoutms;
    protected int start;
    protected int sentUpTo;
    protected int offset;
    protected int bufSize;

    public FdOutStream(FileDescriptor fd_, boolean blocking_, int timeoutms_, int bufSize_) {
        this.fd = fd_;
        this.blocking = blocking_;
        this.timeoutms = timeoutms_;
        this.bufSize = bufSize_ > 0 ? bufSize_ : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.start = 0;
        this.sentUpTo = 0;
        this.ptr = 0;
        this.end = this.start + this.bufSize;
    }

    public FdOutStream(FileDescriptor fd_) {
        this(fd_, true, -1, 0);
    }

    public void setTimeout(int timeoutms_) {
        this.timeoutms = timeoutms_;
    }

    public void setBlocking(boolean blocking_) {
        this.blocking = blocking_;
    }

    @Override
    public int length() {
        return this.offset + this.ptr - this.sentUpTo;
    }

    @Override
    public void flush() {
        int timeoutms_ = this.blocking ? this.timeoutms : 0;
        while (this.sentUpTo < this.ptr) {
            int n = this.writeWithTimeout(this.b, this.sentUpTo, this.ptr - this.sentUpTo, timeoutms_);
            if (n == 0) {
                if (!this.blocking) break;
                if (timeoutms_ == 0 && this.timeoutms != 0) {
                    timeoutms_ = this.timeoutms;
                    break;
                }
                throw new TimedOut();
            }
            this.sentUpTo += n;
            this.offset += n;
        }
        if (this.sentUpTo == this.ptr) {
            this.ptr = this.sentUpTo = this.start;
        }
    }

    private int writeWithTimeout(byte[] data, int dataPtr, int length, int timeoutms) {
        int n;
        do {
            Integer tv = timeoutms != -1 ? new Integer(timeoutms) : null;
            try {
                n = this.fd.select(4, tv);
            }
            catch (java.lang.Exception e) {
                System.out.println(e.toString());
                throw new Exception(e.getMessage());
            }
        } while (n < 0);
        if (n == 0) {
            return 0;
        }
        try {
            n = this.fd.write(data, dataPtr, length);
        }
        catch (java.lang.Exception e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    @Override
    protected int overrun(int itemSize, int nItems) {
        if (itemSize > this.bufSize) {
            throw new Exception("FdOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (itemSize > this.end - this.ptr) {
            if (this.sentUpTo - this.start > this.bufSize / 4 && itemSize < this.bufSize - (this.ptr - this.sentUpTo)) {
                System.arraycopy(this.b, this.ptr, this.b, this.start, this.ptr - this.sentUpTo);
                this.ptr = this.start + (this.ptr - this.sentUpTo);
                this.sentUpTo = this.start;
            } else {
                boolean realBlocking = this.blocking;
                this.blocking = true;
                this.flush();
                this.blocking = realBlocking;
            }
        }
        if (itemSize * nItems > this.end - this.ptr) {
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public void setFd(FileDescriptor fd_) {
        this.fd = fd_;
    }

    public int getBufSize() {
        return this.bufSize;
    }
}

