/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.jcraft.jzlib.ZStream;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.InStream;

public class ZlibInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private InStream underlying;
    private int bufSize;
    private int offset;
    private ZStream zs;
    private int bytesIn;
    private int start;

    public ZlibInStream(int bufSize_) {
        this.bufSize = bufSize_;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.bytesIn = 0;
        this.zs = new ZStream();
        this.zs.next_in = null;
        this.zs.next_in_index = 0;
        this.zs.avail_in = 0;
        if (this.zs.inflateInit() != 0) {
            this.zs = null;
            throw new Exception("ZlinInStream: inflateInit failed");
        }
        this.start = 0;
        this.end = 0;
        this.ptr = 0;
    }

    public ZlibInStream() {
        this(16384);
    }

    protected void finalize() throws Throwable {
        try {
            this.b = null;
            this.zs.inflateEnd();
        }
        finally {
            super.finalize();
        }
    }

    public void setUnderlying(InStream is, int bytesIn_) {
        this.underlying = is;
        this.bytesIn = bytesIn_;
        this.ptr = this.end = this.start;
    }

    @Override
    public int pos() {
        return this.offset + this.ptr - this.start;
    }

    public void reset() {
        this.ptr = this.end = this.start;
        if (this.underlying == null) {
            return;
        }
        while (this.bytesIn > 0) {
            this.decompress(true);
            this.end = this.start;
        }
        this.underlying = null;
    }

    @Override
    protected int overrun(int itemSize, int nItems, boolean wait) {
        if (itemSize > this.bufSize) {
            throw new Exception("ZlibInStream overrun: max itemSize exceeded");
        }
        if (this.underlying == null) {
            throw new Exception("ZlibInStream overrun: no underlying stream");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, this.start, this.end - this.ptr);
        }
        this.offset += this.ptr - this.start;
        this.end -= this.ptr - this.start;
        this.ptr = this.start;
        while (this.end - this.ptr < itemSize) {
            if (this.decompress(wait)) continue;
            return 0;
        }
        if (itemSize * nItems > this.end - this.ptr) {
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    private boolean decompress(boolean wait) {
        int rc;
        this.zs.next_out = this.b;
        this.zs.next_out_index = this.end;
        this.zs.avail_out = this.start + this.bufSize - this.end;
        int n = this.underlying.check(1, 1, wait);
        if (n == 0) {
            return false;
        }
        this.zs.next_in = this.underlying.getbuf();
        this.zs.next_in_index = this.underlying.getptr();
        this.zs.avail_in = this.underlying.getend() - this.underlying.getptr();
        if (this.zs.avail_in > this.bytesIn) {
            this.zs.avail_in = this.bytesIn;
        }
        if ((rc = this.zs.inflate(2)) != 0) {
            throw new Exception("ZlibInStream: inflate failed");
        }
        this.bytesIn -= this.zs.next_in_index - this.underlying.getptr();
        this.end = this.zs.next_out_index;
        this.underlying.setptr(this.zs.next_in_index);
        return true;
    }
}

