/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import java.awt.image.ColorModel;

public class PixelFormat {
    public int bpp;
    public int depth;
    public boolean bigEndian;
    public boolean trueColour;
    public int redMax;
    public int greenMax;
    public int blueMax;
    public int redShift;
    public int greenShift;
    public int blueShift;

    public PixelFormat(int b, int d, boolean e, boolean t) {
        this.bpp = b;
        this.depth = d;
        this.bigEndian = e;
        this.trueColour = t;
    }

    public PixelFormat(int b, int d, boolean e, boolean t, int rm, int gm, int bm, int rs, int gs, int bs) {
        this(b, d, e, t);
        this.redMax = rm;
        this.greenMax = gm;
        this.blueMax = bm;
        this.redShift = rs;
        this.greenShift = gs;
        this.blueShift = bs;
    }

    public PixelFormat() {
        this(8, 8, false, true, 7, 7, 3, 0, 3, 6);
    }

    public boolean equal(PixelFormat x) {
        return this.bpp == x.bpp && this.depth == x.depth && (this.bigEndian == x.bigEndian || this.bpp == 8) && this.trueColour == x.trueColour && (!this.trueColour || this.redMax == x.redMax && this.greenMax == x.greenMax && this.blueMax == x.blueMax && this.redShift == x.redShift && this.greenShift == x.greenShift && this.blueShift == x.blueShift);
    }

    public void read(InStream is) {
        this.bpp = is.readU8();
        this.depth = is.readU8();
        this.bigEndian = is.readU8() != 0;
        this.trueColour = is.readU8() != 0;
        this.redMax = is.readU16();
        this.greenMax = is.readU16();
        this.blueMax = is.readU16();
        this.redShift = is.readU8();
        this.greenShift = is.readU8();
        this.blueShift = is.readU8();
        is.skip(3);
    }

    public void write(OutStream os) {
        os.writeU8(this.bpp);
        os.writeU8(this.depth);
        os.writeU8(this.bigEndian ? 1 : 0);
        os.writeU8(this.trueColour ? 1 : 0);
        os.writeU16(this.redMax);
        os.writeU16(this.greenMax);
        os.writeU16(this.blueMax);
        os.writeU8(this.redShift);
        os.writeU8(this.greenShift);
        os.writeU8(this.blueShift);
        os.pad(3);
    }

    public final boolean is888() {
        if (!this.trueColour) {
            return false;
        }
        if (this.bpp != 32) {
            return false;
        }
        if (this.depth != 24) {
            return false;
        }
        if (this.redMax != 255) {
            return false;
        }
        if (this.greenMax != 255) {
            return false;
        }
        return this.blueMax == 255;
    }

    public int pixelFromRGB(int red, int green, int blue, ColorModel cm) {
        if (this.trueColour) {
            int r = (red * this.redMax + Short.MAX_VALUE) / 65535;
            int g = (green * this.greenMax + Short.MAX_VALUE) / 65535;
            int b = (blue * this.blueMax + Short.MAX_VALUE) / 65535;
            return r << this.redShift | g << this.greenShift | b << this.blueShift;
        }
        if (cm != null) {
            int colours = 1 << this.depth;
            int diff = 262144;
            int col = 0;
            for (int i = 0; i < colours; ++i) {
                int b;
                int bd;
                int g;
                int gd;
                int r = cm.getRed(i);
                int rd = r - red >> 8;
                int d = rd * rd + (gd = (g = cm.getGreen(i)) - green >> 8) * gd + (bd = (b = cm.getBlue(i)) - blue >> 8) * bd;
                if (d >= diff) continue;
                col = i;
                diff = d;
            }
            return col;
        }
        return 0;
    }

    public void bufferFromRGB(int[] dst, int dstPtr, byte[] src, int srcPtr, int pixels) {
        if (this.is888()) {
            for (int i = srcPtr; i < pixels; ++i) {
                int b;
                int g;
                int r;
                if (this.bigEndian) {
                    r = (src[3 * i + 0] & 0xFF) << 24 - this.redShift;
                    g = (src[3 * i + 1] & 0xFF) << 24 - this.greenShift;
                    b = (src[3 * i + 2] & 0xFF) << 24 - this.blueShift;
                    dst[dstPtr + i] = r | g | b | 0xFF;
                    continue;
                }
                r = (src[3 * i + 0] & 0xFF) << this.redShift;
                g = (src[3 * i + 1] & 0xFF) << this.greenShift;
                b = (src[3 * i + 2] & 0xFF) << this.blueShift;
                dst[dstPtr + i] = 0xFF000000 | r | g | b;
            }
        } else {
            int[] rgb = new int[4];
            int i = srcPtr;
            int j = dstPtr;
            while (i < pixels) {
                int r = src[i++] & 0xFF;
                int g = src[i++] & 0xFF;
                int b = src[i++] & 0xFF;
                int p = ColorModel.getRGBdefault().getDataElement(new int[]{255, r, g, b}, 0);
                this.bufferFromPixel(dst, j, p);
                j += this.bpp / 8;
            }
        }
    }

    public void rgbFromBuffer(byte[] dst, int dstPtr, byte[] src, int srcPtr, int pixels, ColorModel cm) {
        for (int i = 0; i < pixels; ++i) {
            int p = this.pixelFromBuffer(src, srcPtr);
            srcPtr += this.bpp / 8;
            dst[dstPtr++] = (byte)cm.getRed(p);
            dst[dstPtr++] = (byte)cm.getGreen(p);
            dst[dstPtr++] = (byte)cm.getBlue(p);
        }
    }

    public int pixelFromBuffer(byte[] buffer, int bufferPtr) {
        int p = 0;
        if (this.bigEndian) {
            switch (this.bpp) {
                case 32: {
                    p = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | 0xFF;
                    break;
                }
                case 16: {
                    p = (buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF;
                    break;
                }
                case 8: {
                    p = buffer[0] & 0xFF;
                }
            }
        } else {
            p = buffer[0] & 0xFF;
            if (this.bpp >= 16) {
                p |= (buffer[1] & 0xFF) << 8;
                if (this.bpp == 32) {
                    p |= (buffer[2] & 0xFF) << 16;
                    p |= (buffer[3] & 0xFF) << 24;
                }
            }
        }
        return p;
    }

    public String print() {
        StringBuffer s = new StringBuffer();
        s.append("depth " + this.depth + " (" + this.bpp + "bpp)");
        if (this.bpp != 8) {
            if (this.bigEndian) {
                s.append(" big-endian");
            } else {
                s.append(" little-endian");
            }
        }
        if (!this.trueColour) {
            s.append(" colour-map");
            return s.toString();
        }
        if (this.blueShift == 0 && this.greenShift > this.blueShift && this.redShift > this.greenShift && this.blueMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.redShift - this.greenShift) - 1 && this.redMax == (1 << this.depth - this.redShift) - 1) {
            s.append(" rgb" + (this.depth - this.redShift) + (this.redShift - this.greenShift) + this.greenShift);
            return s.toString();
        }
        if (this.redShift == 0 && this.greenShift > this.redShift && this.blueShift > this.greenShift && this.redMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.blueShift - this.greenShift) - 1 && this.blueMax == (1 << this.depth - this.blueShift) - 1) {
            s.append(" bgr" + (this.depth - this.blueShift) + (this.blueShift - this.greenShift) + this.greenShift);
            return s.toString();
        }
        s.append(" rgb max " + this.redMax + "," + this.greenMax + "," + this.blueMax + " shift " + this.redShift + "," + this.greenShift + "," + this.blueShift);
        return s.toString();
    }

    public void bufferFromPixel(int[] buffer, int bufPtr, int p) {
        if (this.bigEndian) {
            switch (this.bpp) {
                case 32: {
                    buffer[bufPtr++] = p >> 24 & 0xFF;
                    buffer[bufPtr++] = p >> 16 & 0xFF;
                    break;
                }
                case 16: {
                    buffer[bufPtr++] = p >> 8 & 0xFF;
                    break;
                }
                case 8: {
                    buffer[bufPtr++] = p >> 0 & 0xFF;
                }
            }
        } else {
            buffer[0] = p >> 0 & 0xFF;
            if (this.bpp >= 16) {
                buffer[1] = p >> 8 & 0xFF;
                if (this.bpp == 32) {
                    buffer[2] = p >> 16 & 0xFF;
                    buffer[3] = p >> 24 & 0xFF;
                }
            }
        }
    }
}

