/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Rect;

public class RawDecoder
extends Decoder {
    CMsgReader reader;
    static LogWriter vlog = new LogWriter("RawDecoder");

    public RawDecoder(CMsgReader reader_) {
        this.reader = reader_;
    }

    @Override
    public void readRect(Rect r, CMsgHandler handler) {
        int x = r.tl.x;
        int y = r.tl.y;
        int w = r.width();
        int h = r.height();
        int[] imageBuf = new int[w * h];
        int nPixels = imageBuf.length;
        int bytesPerRow = w * (this.reader.bpp() / 8);
        while (h > 0) {
            int nRows = nPixels / w;
            if (nRows > h) {
                nRows = h;
            }
            this.reader.getInStream().readPixels(imageBuf, nPixels, this.reader.bpp() / 8, handler.cp.pf().bigEndian);
            handler.imageRect(new Rect(x, y, x + w, y + nRows), imageBuf);
            h -= nRows;
            y += nRows;
        }
    }
}

