/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Point;

public class Rect {
    public Point tl;
    public Point br;

    public Rect() {
        this.tl = new Point(0, 0);
        this.br = new Point(0, 0);
    }

    public Rect(Point tl_, Point br_) {
        this.tl = new Point(tl_.x, tl_.y);
        this.br = new Point(br_.x, br_.y);
    }

    public Rect(int x1, int y1, int x2, int y2) {
        this.tl = new Point(x1, y1);
        this.br = new Point(x2, y2);
    }

    public final void setXYWH(int x, int y, int w, int h) {
        this.tl.x = x;
        this.tl.y = y;
        this.br.x = x + w;
        this.br.y = y + h;
    }

    public final Rect intersect(Rect r) {
        Rect result = new Rect();
        result.tl.x = Math.max(this.tl.x, r.tl.x);
        result.tl.y = Math.max(this.tl.y, r.tl.y);
        result.br.x = Math.max(Math.min(this.br.x, r.br.x), result.tl.x);
        result.br.y = Math.max(Math.min(this.br.y, r.br.y), result.tl.y);
        return result;
    }

    public final Rect union_boundary(Rect r) {
        if (r.is_empty()) {
            return this;
        }
        if (this.is_empty()) {
            return r;
        }
        Rect result = new Rect();
        result.tl.x = Math.min(this.tl.x, r.tl.x);
        result.tl.y = Math.min(this.tl.y, r.tl.y);
        result.br.x = Math.max(this.br.x, r.br.x);
        result.br.y = Math.max(this.br.y, r.br.y);
        return result;
    }

    public final Rect translate(Point p) {
        return new Rect(this.tl.translate(p), this.br.translate(p));
    }

    public final boolean equals(Rect r) {
        return r.tl.equals(this.tl) && r.br.equals(this.br);
    }

    public final boolean is_empty() {
        return this.tl.x >= this.br.x || this.tl.y >= this.br.y;
    }

    public final void clear() {
        this.tl = new Point();
        this.br = new Point();
    }

    public final boolean enclosed_by(Rect r) {
        return this.tl.x >= r.tl.x && this.tl.y >= r.tl.y && this.br.x <= r.br.x && this.br.y <= r.br.y;
    }

    public final boolean overlaps(Rect r) {
        return this.tl.x < r.br.x && this.tl.y < r.br.y && this.br.x > r.tl.x && this.br.y > r.tl.y;
    }

    public final int area() {
        int area = (this.br.x - this.tl.x) * (this.br.y - this.tl.y);
        if (area > 0) {
            return area;
        }
        return 0;
    }

    public final Point dimensions() {
        return new Point(this.width(), this.height());
    }

    public final int width() {
        return this.br.x - this.tl.x;
    }

    public final int height() {
        return this.br.y - this.tl.y;
    }

    public final boolean contains(Point p) {
        return this.tl.x <= p.x && this.tl.y <= p.y && this.br.x > p.x && this.br.y > p.y;
    }
}

