/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.CSecurityIdent;
import com.tigervnc.rfb.CSecurityNone;
import com.tigervnc.rfb.CSecurityPlain;
import com.tigervnc.rfb.CSecurityStack;
import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.CSecurityVeNCrypt;
import com.tigervnc.rfb.CSecurityVncAuth;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;

public class SecurityClient
extends Security {
    String msg = null;
    static StringParameter secTypes = new StringParameter("SecurityTypes", "Specify which security scheme to use (None, VncAuth)", "Ident,TLSIdent,X509Ident,X509Plain,TLSPlain,X509Vnc,TLSVnc,X509None,TLSNone,VncAuth,None", Configuration.ConfigurationObject.ConfViewer);

    public SecurityClient() {
        super(secTypes);
    }

    public CSecurity GetCSecurity(int secType) {
        assert (CConn.upg != null);
        assert (this.msg != null);
        if (!this.IsSupported(secType)) {
            throw new Exception("Security type not supported");
        }
        switch (secType) {
            case 1: {
                return new CSecurityNone();
            }
            case 2: {
                return new CSecurityVncAuth();
            }
            case 19: {
                return new CSecurityVeNCrypt(this);
            }
            case 256: {
                return new CSecurityPlain();
            }
            case 265: {
                return new CSecurityIdent();
            }
            case 257: {
                return new CSecurityStack(257, "TLS with no password", new CSecurityTLS(true), null);
            }
            case 258: {
                return new CSecurityStack(258, "TLS with VNCAuth", new CSecurityTLS(true), new CSecurityVncAuth());
            }
            case 259: {
                return new CSecurityStack(259, "TLS with Username/Password", new CSecurityTLS(true), new CSecurityPlain());
            }
            case 266: {
                return new CSecurityStack(266, "TLS with username only", new CSecurityTLS(true), new CSecurityIdent());
            }
            case 260: {
                return new CSecurityStack(260, "X509 with no password", new CSecurityTLS(false), null);
            }
            case 261: {
                return new CSecurityStack(261, "X509 with VNCAuth", new CSecurityTLS(false), new CSecurityVncAuth());
            }
            case 262: {
                return new CSecurityStack(262, "X509 with Username/Password", new CSecurityTLS(false), new CSecurityPlain());
            }
            case 267: {
                return new CSecurityStack(267, "X509 with username only", new CSecurityTLS(false), new CSecurityIdent());
            }
        }
        throw new Exception("Security type not supported");
    }

    public static void setDefaults() {
        CSecurityTLS.setDefaults();
    }
}

