/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class BIPixelBuffer
extends PlatformPixelBuffer
implements ImageObserver {
    BufferedImage image;
    DataBuffer db;
    Rectangle clip = new Rectangle();
    static LogWriter vlog = new LogWriter("BIPixelBuffer");

    public BIPixelBuffer(int w, int h, CConn cc_, DesktopWindow desktop_) {
        super(w, h, cc_, desktop_);
    }

    @Override
    public void setPF(PixelFormat pf) {
        super.setPF(pf);
        this.createImage(this.width(), this.height());
    }

    @Override
    public void updateColourMap() {
        super.updateColourMap();
        this.createImage(this.width_, this.height_);
    }

    @Override
    public void resize(int w, int h) {
        if (w == this.width() && h == this.height()) {
            return;
        }
        this.width_ = w;
        this.height_ = h;
        this.createImage(w, h);
    }

    private void createImage(int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        WritableRaster wr = this.cm instanceof IndexColorModel ? ((IndexColorModel)this.cm).createCompatibleWritableRaster(w, h) : ((DirectColorModel)this.cm).createCompatibleWritableRaster(w, h);
        this.image = new BufferedImage(this.cm, wr, true, null);
        this.db = wr.getDataBuffer();
    }

    @Override
    public void fillRect(int x, int y, int w, int h, int pix) {
        Graphics2D graphics = (Graphics2D)this.image.getGraphics();
        switch (this.format.depth) {
            case 24: {
                graphics.setColor(new Color(pix));
                graphics.fillRect(x, y, w, h);
                break;
            }
            default: {
                Color color = new Color(0xFF000000 | this.cm.getRed(pix) << 16 | this.cm.getGreen(pix) << 8 | this.cm.getBlue(pix));
                graphics.setColor(color);
                graphics.fillRect(x, y, w, h);
            }
        }
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageRect(int x, int y, int w, int h, Object pix) {
        if (pix instanceof Image) {
            Image img = (Image)pix;
            Rectangle rectangle = this.clip = new Rectangle(x, y, w, h);
            synchronized (rectangle) {
                tk.prepareImage(img, -1, -1, this);
                try {
                    this.clip.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new Exception("Error decoding JPEG data");
                }
            }
            this.clip = null;
            img.flush();
        } else {
            if (this.image.getSampleModel().getTransferType() == 0) {
                byte[] bytes = new byte[((int[])pix).length];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)((int[])pix)[i];
                }
                pix = bytes;
            }
            this.image.getSampleModel().setDataElements(x, y, w, h, pix, this.db);
        }
    }

    @Override
    public void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        Graphics2D graphics = (Graphics2D)this.image.getGraphics();
        graphics.copyArea(srcX, srcY, w, h, x - srcX, y - srcY);
        graphics.dispose();
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0xA0) == 0) {
            return true;
        }
        if ((infoflags & 0x20) != 0 && this.clip != null) {
            Rectangle rectangle = this.clip;
            synchronized (rectangle) {
                Graphics2D graphics = (Graphics2D)this.image.getGraphics();
                graphics.drawImage(img, this.clip.x, this.clip.y, this.clip.width, this.clip.height, null);
                graphics.dispose();
                this.clip.notify();
            }
        }
        return false;
    }
}

