/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.DesktopWindow;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import java.nio.ByteOrder;

public abstract class PlatformPixelBuffer
extends PixelBuffer {
    protected static Toolkit tk = Toolkit.getDefaultToolkit();
    protected Image image;
    int nColours;
    byte[] reds;
    byte[] greens;
    byte[] blues;
    CConn cc;
    DesktopWindow desktop;
    static LogWriter vlog = new LogWriter("PlatformPixelBuffer");

    public PlatformPixelBuffer(int w, int h, CConn cc_, DesktopWindow desktop_) {
        this.cc = cc_;
        this.desktop = desktop_;
        PixelFormat nativePF = this.getNativePF();
        if (nativePF.depth > this.cc.serverPF.depth) {
            this.setPF(this.cc.serverPF);
        } else {
            this.setPF(nativePF);
        }
        this.resize(w, h);
    }

    public abstract void resize(int var1, int var2);

    public PixelFormat getNativePF() {
        PixelFormat pf;
        this.cm = tk.getColorModel();
        if (this.cm.getColorSpace().getType() == 5) {
            int depth;
            int n = depth = this.cm.getPixelSize() > 24 ? 24 : this.cm.getPixelSize();
            int bpp = depth > 16 ? 32 : (depth > 8 ? 16 : 8);
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            boolean bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
            boolean trueColour = depth > 8;
            int redShift = this.cm.getComponentSize()[0] + this.cm.getComponentSize()[1];
            int greenShift = this.cm.getComponentSize()[0];
            int blueShift = 0;
            pf = new PixelFormat(bpp, depth, bigEndian, trueColour, depth > 8 ? 255 : 0, depth > 8 ? 255 : 0, depth > 8 ? 255 : 0, depth > 8 ? redShift : 0, depth > 8 ? greenShift : 0, depth > 8 ? blueShift : 0);
        } else {
            pf = new PixelFormat(8, 8, false, false, 7, 7, 3, 0, 3, 6);
        }
        vlog.debug("Native pixel format is " + pf.print());
        return pf;
    }

    public abstract void imageRect(int var1, int var2, int var3, int var4, Object var5);

    public void setColourMapEntries(int firstColour, int nColours_, int[] rgbs) {
        this.nColours = nColours_;
        this.reds = new byte[this.nColours];
        this.blues = new byte[this.nColours];
        this.greens = new byte[this.nColours];
        for (int i = 0; i < this.nColours; ++i) {
            this.reds[firstColour + i] = (byte)(rgbs[i * 3] >> 8);
            this.greens[firstColour + i] = (byte)(rgbs[i * 3 + 1] >> 8);
            this.blues[firstColour + i] = (byte)(rgbs[i * 3 + 2] >> 8);
        }
    }

    public void updateColourMap() {
        this.cm = new IndexColorModel(8, this.nColours, this.reds, this.greens, this.blues);
    }

    public abstract Image getImage();
}

