/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.features2d;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.utils.Converters;

public class FeatureDetector {
    protected final long nativeObj;
    private static final int GRIDDETECTOR = 1000;
    private static final int PYRAMIDDETECTOR = 2000;
    private static final int DYNAMICDETECTOR = 3000;
    public static final int FAST = 1;
    public static final int STAR = 2;
    public static final int SIFT = 3;
    public static final int SURF = 4;
    public static final int ORB = 5;
    public static final int MSER = 6;
    public static final int GFTT = 7;
    public static final int HARRIS = 8;
    public static final int SIMPLEBLOB = 9;
    public static final int DENSE = 10;
    public static final int BRISK = 11;
    public static final int GRIDRETECTOR = 1000;
    public static final int GRID_FAST = 1001;
    public static final int GRID_STAR = 1002;
    public static final int GRID_SIFT = 1003;
    public static final int GRID_SURF = 1004;
    public static final int GRID_ORB = 1005;
    public static final int GRID_MSER = 1006;
    public static final int GRID_GFTT = 1007;
    public static final int GRID_HARRIS = 1008;
    public static final int GRID_SIMPLEBLOB = 1009;
    public static final int GRID_DENSE = 1010;
    public static final int GRID_BRISK = 1011;
    public static final int PYRAMID_FAST = 2001;
    public static final int PYRAMID_STAR = 2002;
    public static final int PYRAMID_SIFT = 2003;
    public static final int PYRAMID_SURF = 2004;
    public static final int PYRAMID_ORB = 2005;
    public static final int PYRAMID_MSER = 2006;
    public static final int PYRAMID_GFTT = 2007;
    public static final int PYRAMID_HARRIS = 2008;
    public static final int PYRAMID_SIMPLEBLOB = 2009;
    public static final int PYRAMID_DENSE = 2010;
    public static final int PYRAMID_BRISK = 2011;
    public static final int DYNAMIC_FAST = 3001;
    public static final int DYNAMIC_STAR = 3002;
    public static final int DYNAMIC_SIFT = 3003;
    public static final int DYNAMIC_SURF = 3004;
    public static final int DYNAMIC_ORB = 3005;
    public static final int DYNAMIC_MSER = 3006;
    public static final int DYNAMIC_GFTT = 3007;
    public static final int DYNAMIC_HARRIS = 3008;
    public static final int DYNAMIC_SIMPLEBLOB = 3009;
    public static final int DYNAMIC_DENSE = 3010;
    public static final int DYNAMIC_BRISK = 3011;

    protected FeatureDetector(long addr) {
        this.nativeObj = addr;
    }

    public static FeatureDetector create(int detectorType) {
        FeatureDetector retVal = new FeatureDetector(FeatureDetector.create_0(detectorType));
        return retVal;
    }

    public void detect(Mat image, MatOfKeyPoint keypoints, Mat mask) {
        MatOfKeyPoint keypoints_mat = keypoints;
        FeatureDetector.detect_0(this.nativeObj, image.nativeObj, keypoints_mat.nativeObj, mask.nativeObj);
    }

    public void detect(Mat image, MatOfKeyPoint keypoints) {
        MatOfKeyPoint keypoints_mat = keypoints;
        FeatureDetector.detect_1(this.nativeObj, image.nativeObj, keypoints_mat.nativeObj);
    }

    public void detect(List<Mat> images, List<MatOfKeyPoint> keypoints, List<Mat> masks) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat keypoints_mat = new Mat();
        Mat masks_mat = Converters.vector_Mat_to_Mat(masks);
        FeatureDetector.detect_2(this.nativeObj, images_mat.nativeObj, keypoints_mat.nativeObj, masks_mat.nativeObj);
        Converters.Mat_to_vector_vector_KeyPoint(keypoints_mat, keypoints);
    }

    public void detect(List<Mat> images, List<MatOfKeyPoint> keypoints) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat keypoints_mat = new Mat();
        FeatureDetector.detect_3(this.nativeObj, images_mat.nativeObj, keypoints_mat.nativeObj);
        Converters.Mat_to_vector_vector_KeyPoint(keypoints_mat, keypoints);
    }

    public boolean empty() {
        boolean retVal = FeatureDetector.empty_0(this.nativeObj);
        return retVal;
    }

    public void read(String fileName) {
        FeatureDetector.read_0(this.nativeObj, fileName);
    }

    public void write(String fileName) {
        FeatureDetector.write_0(this.nativeObj, fileName);
    }

    protected void finalize() throws Throwable {
        FeatureDetector.delete(this.nativeObj);
    }

    private static native long create_0(int var0);

    private static native void detect_0(long var0, long var2, long var4, long var6);

    private static native void detect_1(long var0, long var2, long var4);

    private static native void detect_2(long var0, long var2, long var4, long var6);

    private static native void detect_3(long var0, long var2, long var4);

    private static native boolean empty_0(long var0);

    private static native void read_0(long var0, String var2);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

