/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.util.JythonHelper;

public class Debug {
    private static int DEBUG_LEVEL = 0;
    private static boolean loggerRedirectSupported = true;
    public static boolean shouldLogJython = false;
    private long _beginTime = 0L;
    private String _message;
    private String _title = null;
    private static PrintStream printout = null;
    private static PrintStream printoutuser = null;
    private static final DateFormat df = DateFormat.getDateTimeInstance(3, 2);
    public static String logfile;
    private static Object privateLogger;
    private static boolean privateLoggerPrefixAll;
    private static Method privateLoggerUser;
    private static String privateLoggerUserName;
    private static String privateLoggerUserPrefix;
    private static Method privateLoggerInfo;
    private static String privateLoggerInfoName;
    private static final String infoPrefix = "info";
    private static String privateLoggerInfoPrefix;
    private static Method privateLoggerAction;
    private static String privateLoggerActionName;
    private static final String actionPrefix = "log";
    private static String privateLoggerActionPrefix;
    private static Method privateLoggerError;
    private static String privateLoggerErrorName;
    private static final String errorPrefix = "error";
    private static String privateLoggerErrorPrefix;
    private static Method privateLoggerDebug;
    private static String privateLoggerDebugName;
    private static final String debugPrefix = "debug";
    private static String privateLoggerDebugPrefix;
    private static boolean isJython;
    private static boolean isJRuby;
    private static Object scriptRunner;
    private static boolean searchHighlight;
    private static PrintStream redirectedOut;
    private static PrintStream redirectedErr;

    public static void init() {
        if (DEBUG_LEVEL > 0) {
            Debug.logx(DEBUG_LEVEL, "Debug.init: from sikuli.Debug: on: %d", DEBUG_LEVEL);
        }
    }

    public static void highlightOn() {
        searchHighlight = true;
        Settings.Highlight = true;
    }

    public static void highlightOff() {
        searchHighlight = false;
        Settings.Highlight = false;
    }

    public static boolean shouldHighlight() {
        return searchHighlight;
    }

    public static void setLogger(Object logger) {
        if (!Debug.doSetLogger(logger)) {
            return;
        }
        privateLoggerPrefixAll = true;
        Debug.logx(3, "Debug: setLogger %s", logger);
    }

    public static void setLoggerNoPrefix(Object logger) {
        if (!Debug.doSetLogger(logger)) {
            return;
        }
        privateLoggerPrefixAll = false;
    }

    private static boolean doSetLogger(Object logger) {
        String className = logger.getClass().getName();
        isJython = className.contains("org.python");
        isJRuby = className.contains("org.jruby");
        if (isJRuby) {
            Debug.logx(3, "Debug: setLogger: given instance's class: %s", className);
            Debug.error("setLogger: not yet supported in JRuby script", new Object[0]);
            loggerRedirectSupported = false;
            return false;
        }
        privateLogger = logger;
        return true;
    }

    public static boolean setLoggerAll(String mAll) {
        if (!loggerRedirectSupported) {
            Debug.logx(3, "Debug: setLoggerAll: logger redirect not supported", new Object[0]);
            return false;
        }
        if (privateLogger != null) {
            Debug.logx(3, "Debug.setLoggerAll: %s", mAll);
            boolean success = true;
            success &= Debug.setLoggerUser(mAll);
            success &= Debug.setLoggerInfo(mAll);
            success &= Debug.setLoggerAction(mAll);
            success &= Debug.setLoggerError(mAll);
            return success &= Debug.setLoggerDebug(mAll);
        }
        return false;
    }

    private static boolean doSetLoggerCallback(String mName, CallbackType type) {
        if (privateLogger == null) {
            Debug.error("Debug: setLogger: no logger specified yet", new Object[0]);
            return false;
        }
        if (!loggerRedirectSupported) {
            Debug.logx(3, "Debug: setLogger: %s (%s) logger redirect not supported", new Object[]{mName, type});
        }
        if (isJython) {
            Object[] args = new Object[]{privateLogger, mName, type.toString()};
            if (!JythonHelper.get().checkCallback(args)) {
                Debug.logx(3, "Debug: setLogger: Jython: checkCallback returned: %s", args[0]);
                return false;
            }
        }
        try {
            if (type == CallbackType.INFO) {
                if (!isJython && !isJRuby) {
                    privateLoggerInfo = privateLogger.getClass().getMethod(mName, String.class);
                }
                privateLoggerInfoName = mName;
                return true;
            }
            if (type == CallbackType.ACTION) {
                if (!isJython && !isJRuby) {
                    privateLoggerAction = privateLogger.getClass().getMethod(mName, String.class);
                }
                privateLoggerActionName = mName;
                return true;
            }
            if (type == CallbackType.ERROR) {
                if (!isJython && !isJRuby) {
                    privateLoggerError = privateLogger.getClass().getMethod(mName, String.class);
                }
                privateLoggerErrorName = mName;
                return true;
            }
            if (type == CallbackType.DEBUG) {
                if (!isJython && !isJRuby) {
                    privateLoggerDebug = privateLogger.getClass().getMethod(mName, String.class);
                }
                privateLoggerDebugName = mName;
                return true;
            }
            if (type == CallbackType.USER) {
                if (!isJython && !isJRuby) {
                    privateLoggerUser = privateLogger.getClass().getMethod(mName, String.class);
                }
                privateLoggerUserName = mName;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Debug.error("Debug: setLoggerInfo: redirecting to %s failed: \n%s", mName, e.getMessage());
            return false;
        }
    }

    public static boolean setLoggerUser(String mUser) {
        if (mUser == null || mUser.isEmpty()) {
            privateLoggerUserName = "";
            return true;
        }
        return Debug.doSetLoggerCallback(mUser, CallbackType.USER);
    }

    public static boolean setLoggerInfo(String mInfo) {
        if (mInfo == null || mInfo.isEmpty()) {
            privateLoggerInfoName = "";
            return true;
        }
        return Debug.doSetLoggerCallback(mInfo, CallbackType.INFO);
    }

    public static boolean setLoggerAction(String mAction) {
        if (mAction == null || mAction.isEmpty()) {
            privateLoggerActionName = "";
            return true;
        }
        return Debug.doSetLoggerCallback(mAction, CallbackType.ACTION);
    }

    public static boolean setLoggerError(String mError) {
        if (mError == null || mError.isEmpty()) {
            privateLoggerErrorName = "";
            return true;
        }
        return Debug.doSetLoggerCallback(mError, CallbackType.ERROR);
    }

    public static boolean setLoggerDebug(String mDebug) {
        if (mDebug == null || mDebug.isEmpty()) {
            privateLoggerDebugName = "";
            return true;
        }
        return Debug.doSetLoggerCallback(mDebug, CallbackType.DEBUG);
    }

    public static void saveRedirected(PrintStream rdo, PrintStream rde) {
        redirectedOut = rdo;
        redirectedErr = rde;
    }

    public static void out(String msg) {
        if (redirectedOut != null && DEBUG_LEVEL > 2) {
            redirectedOut.println(msg);
        }
    }

    public static boolean setLogFile(String fileName) {
        if (fileName == null) {
            fileName = System.getProperty("sikuli.Logfile");
        }
        if (fileName != null) {
            if ("".equals(fileName)) {
                fileName = Settings.isMacApp ? "SikulixLog.txt" : FileManager.slashify(System.getProperty("user.dir"), true) + "SikulixLog.txt";
            }
            try {
                logfile = fileName;
                if (printout != null) {
                    printout.close();
                }
                printout = new PrintStream(fileName);
                Debug.log(3, "Debug: setLogFile: " + fileName, new Object[0]);
                return true;
            }
            catch (Exception ex) {
                System.out.printf("[Error] Logfile %s not accessible - check given path", fileName);
                System.out.println();
                return false;
            }
        }
        return false;
    }

    public static boolean isLogToFile() {
        return printout != null;
    }

    public static boolean setUserLogFile(String fileName) {
        if (fileName == null) {
            fileName = System.getProperty("sikuli.LogfileUser");
        }
        if (fileName != null) {
            if ("".equals(fileName)) {
                fileName = Settings.isMacApp ? "UserLog.txt" : FileManager.slashify(System.getProperty("user.dir"), true) + "UserLog.txt";
            }
            try {
                if (printoutuser != null) {
                    printoutuser.close();
                }
                printoutuser = new PrintStream(fileName);
                Debug.log(3, "Debug: setLogFile: " + fileName, new Object[0]);
                return true;
            }
            catch (FileNotFoundException ex) {
                System.out.printf("[Error] User logfile %s not accessible - check given path", fileName);
                System.out.println();
                return false;
            }
        }
        return false;
    }

    public static boolean isUserLogToFile() {
        return printoutuser != null;
    }

    public static int getDebugLevel() {
        return DEBUG_LEVEL;
    }

    public static int setDebugLevel() {
        Debug.setDebugLevel(0);
        return DEBUG_LEVEL;
    }

    public static void setDebugLevel(int level) {
        DEBUG_LEVEL = level;
        Settings.DebugLogs = DEBUG_LEVEL > 0;
    }

    public static void on(int level) {
        Debug.setDebugLevel(level);
    }

    public static void on(String level) {
        Debug.setDebugLevel(level);
    }

    public static boolean is(int level) {
        return DEBUG_LEVEL >= level;
    }

    public static int is() {
        return DEBUG_LEVEL;
    }

    public static void off() {
        Debug.setDebugLevel(0);
    }

    public static void setDebugLevel(String level) {
        try {
            DEBUG_LEVEL = Integer.parseInt(level);
            Settings.DebugLogs = DEBUG_LEVEL > 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static boolean doRedirect(CallbackType type, String pre, String message, Object ... args) {
        boolean success = false;
        String error = "";
        if (privateLogger != null) {
            String prefix = "";
            String pln = "";
            Method plf = null;
            if (type == CallbackType.INFO && !privateLoggerInfoName.isEmpty()) {
                prefix = privateLoggerPrefixAll ? privateLoggerInfoPrefix : "";
                plf = privateLoggerInfo;
                pln = privateLoggerInfoName;
            } else if (type == CallbackType.ACTION && !privateLoggerActionName.isEmpty()) {
                prefix = privateLoggerPrefixAll ? privateLoggerActionPrefix : "";
                plf = privateLoggerAction;
                pln = privateLoggerActionName;
            } else if (type == CallbackType.ERROR && !privateLoggerErrorName.isEmpty()) {
                prefix = privateLoggerPrefixAll ? privateLoggerErrorPrefix : "";
                plf = privateLoggerError;
                pln = privateLoggerErrorName;
            } else if (type == CallbackType.DEBUG && !privateLoggerDebugName.isEmpty()) {
                prefix = privateLoggerPrefixAll ? (privateLoggerDebugPrefix.isEmpty() ? pre : privateLoggerDebugPrefix) : "";
                plf = privateLoggerDebug;
                pln = privateLoggerDebugName;
            } else if (type == CallbackType.USER && !privateLoggerUserName.isEmpty()) {
                prefix = privateLoggerPrefixAll ? (privateLoggerUserPrefix.isEmpty() ? pre : privateLoggerUserPrefix) : "";
                plf = privateLoggerUser;
                pln = privateLoggerUserName;
            }
            if (!pln.isEmpty()) {
                String msg = null;
                msg = args == null ? prefix + message : String.format(prefix + message, args);
                if (isJython) {
                    success = JythonHelper.get().runLoggerCallback(new Object[]{privateLogger, pln, msg});
                } else if (isJRuby) {
                    success = false;
                } else {
                    try {
                        plf.invoke(privateLogger, msg);
                        return true;
                    }
                    catch (Exception e) {
                        error = ": " + e.getMessage();
                        success = false;
                    }
                }
                if (!success) {
                    Debug.error("calling (%s) logger.%s failed - resetting to default%s", new Object[]{type, pln, error});
                    if (type == CallbackType.INFO) {
                        privateLoggerInfoName = "";
                    } else if (type == CallbackType.ACTION) {
                        privateLoggerActionName = "";
                    } else if (type == CallbackType.ERROR) {
                        privateLoggerErrorName = "";
                    } else if (type == CallbackType.DEBUG) {
                        privateLoggerDebugName = "";
                    } else if (type == CallbackType.USER) {
                        privateLoggerUserName = "";
                    }
                }
            }
        }
        return success;
    }

    public static void action(String message, Object ... args) {
        if (Settings.ActionLogs) {
            if (Debug.doRedirect(CallbackType.ACTION, "", message, args)) {
                return;
            }
            if (Debug.is(3)) {
                Debug.logx(3, message, args);
            } else {
                Debug.log(-1, actionPrefix, message, args);
            }
        }
    }

    @Deprecated
    public static void history(String message, Object ... args) {
        Debug.action(message, args);
    }

    public static void info(String message, Object ... args) {
        if (Settings.InfoLogs) {
            if (Debug.doRedirect(CallbackType.INFO, "", message, args)) {
                return;
            }
            Debug.log(-1, infoPrefix, message, args);
        }
        if (Debug.is(3)) {
            Debug.logx(3, message, args);
        }
    }

    public static void error(String message, Object ... args) {
        if (Debug.doRedirect(CallbackType.ERROR, "", message, args)) {
            return;
        }
        Debug.log(-1, errorPrefix, message, args);
    }

    public static void test(String message, Object ... args) {
        if (message.contains("#returned#")) {
            message = message.replace("#returned#", "returned: " + ((Boolean)args[0] != false ? "true" : "false"));
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        Debug.log(-1, "test", message, args);
    }

    public static void log(String message, Object ... args) {
        Debug.log(0, message, args);
    }

    public static boolean logJython() {
        return Debug.logJython(null);
    }

    public static boolean logJython(Boolean state) {
        if (null != state) {
            shouldLogJython = state;
        }
        return shouldLogJython;
    }

    public static void logj(String message, Object ... args) {
        if (shouldLogJython) {
            Debug.log(0, "Jython: " + message, args);
        }
    }

    public static void user(String message, Object ... args) {
        if (Settings.UserLogs) {
            if (Settings.UserLogTime) {
                Debug.log(-99, String.format("%s (%s)", Settings.UserLogPrefix, df.format(new Date())), message, args);
            } else {
                Debug.log(-99, String.format("%s", Settings.UserLogPrefix), message, args);
            }
        }
    }

    public static void log(int level, String message, Object ... args) {
        if (Settings.DebugLogs) {
            Debug.log(level, debugPrefix, message, args);
        }
    }

    public static String logx(int level, String message, Object ... args) {
        String sout = "";
        sout = level == -1 || level == -100 ? Debug.log(level, errorPrefix, message, args) : (level == -2 ? Debug.log(level, actionPrefix, message, args) : (level == -3 ? Debug.log(level, "", message, args) : Debug.log(level, debugPrefix, message, args)));
        return sout;
    }

    public static String logp(String msg, Object ... args) {
        String out = String.format(msg, args);
        System.out.println(out);
        return out;
    }

    private static synchronized String log(int level, String prefix, String message, Object ... args) {
        String sout = "";
        String stime = "";
        if (level <= DEBUG_LEVEL) {
            if (level == 3 && message.startsWith("TRACE: ") && !Settings.TraceLogs) {
                return "";
            }
            if (Settings.LogTime && level != -99) {
                stime = String.format(" (%s)", df.format(new Date()));
            }
            if (!prefix.isEmpty()) {
                prefix = "[" + prefix + stime + "] ";
            }
            sout = String.format(message, args);
            boolean isRedirected = false;
            if (level > -99) {
                isRedirected = Debug.doRedirect(CallbackType.DEBUG, prefix, sout, null);
            } else if (level == -99) {
                isRedirected = Debug.doRedirect(CallbackType.USER, prefix, sout, null);
            }
            if (!isRedirected) {
                if (level == -99 && printoutuser != null) {
                    printoutuser.print(prefix + sout);
                    printoutuser.println();
                } else if (printout != null) {
                    printout.print(prefix + sout);
                    printout.println();
                } else {
                    System.out.print(prefix + sout);
                    System.out.println();
                }
                if (level == -1 || level == -100 || level > 2) {
                    Debug.out(prefix + sout);
                }
            }
        }
        return prefix + sout;
    }

    public static void profile(String message, Object ... args) {
        if (Settings.ProfileLogs) {
            Debug.log(-1, "profile", message, args);
        }
    }

    public static void enter(String message, Object ... args) {
        Debug.profile("entering: " + message, args);
    }

    public static void exit(String message, Object ... args) {
        Debug.profile("exiting: " + message, args);
    }

    public static Debug startTimer() {
        return Debug.startTimer("", new Object[0]);
    }

    public static Debug startTimer(String message, Object ... args) {
        Debug timer = new Debug();
        timer.startTiming(message, args);
        return timer;
    }

    public long end() {
        if (this._title == null) {
            return this.endTiming(this._message, false, new Object[0]);
        }
        return this.endTiming(this._title, false, new Object[0]);
    }

    public long lap(String message) {
        if (this._title == null) {
            return this.endTiming("(" + message + ") " + this._message, true, new Object[0]);
        }
        return this.endTiming("(" + message + ") " + this._title, true, new Object[0]);
    }

    private void startTiming(String message, Object ... args) {
        int pos = message.indexOf("\t");
        if (pos < 0) {
            this._title = null;
            this._message = message;
        } else {
            this._title = message.substring(0, pos);
            this._message = message.replace("\t", " ");
        }
        if (!"".equals(this._message)) {
            Debug.profile("TStart: " + this._message, args);
        }
        this._beginTime = new Date().getTime();
    }

    private long endTiming(String message, boolean isLap, Object ... args) {
        if (this._beginTime == 0L) {
            Debug.profile("TError: timer not started (%s)", message);
            return -1L;
        }
        long t = new Date().getTime();
        long dt = t - this._beginTime;
        if (!isLap) {
            this._beginTime = 0L;
        }
        if (!"".equals(message)) {
            Debug.profile(String.format((isLap ? "TLap:" : "TEnd") + " (%.3f sec): ", Float.valueOf((float)dt / 1000.0f)) + message, args);
        }
        return dt;
    }

    static {
        privateLogger = null;
        privateLoggerPrefixAll = true;
        privateLoggerUser = null;
        privateLoggerUserName = "";
        privateLoggerUserPrefix = "";
        privateLoggerInfo = null;
        privateLoggerInfoName = "";
        privateLoggerInfoPrefix = "[info] ";
        privateLoggerAction = null;
        privateLoggerActionName = "";
        privateLoggerActionPrefix = "[log] ";
        privateLoggerError = null;
        privateLoggerErrorName = "";
        privateLoggerErrorPrefix = "[error] ";
        privateLoggerDebug = null;
        privateLoggerDebugName = "";
        privateLoggerDebugPrefix = "";
        scriptRunner = null;
        searchHighlight = false;
        redirectedOut = null;
        redirectedErr = null;
        String debug = System.getProperty("sikuli.Debug");
        if (debug != null && "".equals(debug)) {
            DEBUG_LEVEL = 0;
            Settings.DebugLogs = false;
        } else {
            try {
                DEBUG_LEVEL = Integer.parseInt(debug);
                Settings.DebugLogs = DEBUG_LEVEL > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Debug.setLogFile(null);
        Debug.setUserLogFile(null);
    }

    private static enum CallbackType {
        INFO,
        ACTION,
        ERROR,
        DEBUG,
        USER;

    }
}

